/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;

public class TestGraphEvents
extends GraphTestBase {
    public TestGraphEvents(String name) {
        super(name);
    }

    public void testGraphEventContent() {
        this.testGraphEventContents("testing", "an example");
        this.testGraphEventContents("toasting", Boolean.TRUE);
        this.testGraphEventContents("tasting", Triple.create("we are here"));
    }

    public void testGraphEventsRemove() {
        this.testGraphEventsRemove("s", "p", "o");
        this.testGraphEventsRemove("s", "p", "17");
        this.testGraphEventsRemove("_s", "p", "'object'");
        this.testGraphEventsRemove("not:known", "p", "'chat'fr");
    }

    private void testGraphEventsRemove(String S, String P, String O) {
        Triple expected = Triple.create(S + " " + P + " " + O);
        GraphEvents e2 = GraphEvents.remove(TestGraphEvents.node(S), TestGraphEvents.node(P), TestGraphEvents.node(O));
        TestGraphEvents.assertEquals(expected, e2.getContent());
        TestGraphEvents.assertEquals((Object)"remove", e2.getTitle());
    }

    private void testGraphEventContents(String title, Object expected) {
        GraphEvents e2 = new GraphEvents(title, expected);
        TestGraphEvents.assertEquals((Object)title, e2.getTitle());
        TestGraphEvents.assertEquals(expected, e2.getContent());
    }
}

