/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.impl.WrappedGraph;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.graph.test.MetaTestGraph;
import com.hp.hpl.jena.graph.test.TestReifier;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.mem.SmallGraphMem;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Set;
import junit.framework.TestSuite;

public class TestGraph
extends GraphTestBase {
    public TestGraph(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite result = new TestSuite(TestGraph.class);
        result.addTest(TestGraph.suite(MetaTestGraph.class, GraphMem.class));
        result.addTest(TestGraph.suite(TestReifier.class, GraphMem.class));
        result.addTest(TestGraph.suite(MetaTestGraph.class, SmallGraphMem.class));
        result.addTest(TestGraph.suite(TestReifier.class, SmallGraphMem.class));
        result.addTest(TestGraph.suite(MetaTestGraph.class, WrappedGraphMem.class));
        result.addTest(TestGraph.suite(TestReifier.class, WrappedGraphMem.class));
        return result;
    }

    public static TestSuite suite(Class classWithTests, Class graphClass) {
        return MetaTestGraph.suite(classWithTests, graphClass);
    }

    public void testWrappedSame() {
        Graph m = Factory.createGraphMem();
        WrappedGraph w = new WrappedGraph(m);
        TestGraph.graphAdd(m, "a trumps b; c eats d");
        TestGraph.assertIsomorphic(m, w);
        TestGraph.graphAdd(w, "i write this; you read that");
        TestGraph.assertIsomorphic(w, m);
    }

    public void testListSubjectsDoesntUseFind() {
        boolean[] called = new boolean[]{false};
        Graph g = Factory.createGraphMem();
        ExtendedIterator subjects = g.queryHandler().subjectsFor(null, null);
        Set s = CollectionFactory.createHashedSet();
        while (subjects.hasNext()) {
            s.add(subjects.next());
        }
        TestGraph.assertFalse("find should not have been called", called[0]);
    }

    public void testListPredicatesDoesntUseFind() {
        boolean[] called = new boolean[]{false};
        Graph g = Factory.createGraphMem();
        ExtendedIterator predicates = g.queryHandler().predicatesFor(null, null);
        Set s = CollectionFactory.createHashedSet();
        while (predicates.hasNext()) {
            s.add(predicates.next());
        }
        TestGraph.assertFalse("find should not have been called", called[0]);
    }

    public void testListObjectsDoesntUseFind() {
        boolean[] called = new boolean[]{false};
        Graph g = Factory.createGraphMem();
        ExtendedIterator subjects = g.queryHandler().objectsFor(null, null);
        Set s = CollectionFactory.createHashedSet();
        while (subjects.hasNext()) {
            s.add(subjects.next());
        }
        TestGraph.assertFalse("find should not have been called", called[0]);
    }

    public static class WrappedGraphMem
    extends WrappedGraph {
        public WrappedGraphMem(ReificationStyle style) {
            super(Factory.createGraphMem(style));
        }
    }
}

