/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.StageElement;
import com.hp.hpl.jena.graph.query.ValuatorSet;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import junit.framework.TestSuite;

public class TestStageElements
extends QueryTestBase {
    protected Pipelet p = new Pipelet();

    public TestStageElements(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestStageElements.class);
    }

    public void testPutBindings() {
        StageElement.PutBindings b = new StageElement.PutBindings(this.p);
        Domain d = this.makeDomain(Node.ANY);
        b.run(d);
        TestStageElements.assertEquals(d, this.p.lastPut);
        TestStageElements.assertNotSame(d, this.p.lastPut);
    }

    public void testPutBindingsTwice() {
        StageElement.PutBindings b = new StageElement.PutBindings(this.p);
        Domain d1 = this.makeDomain(Node.ANY);
        Domain d2 = this.makeDomain(Node.create("_blank"), Node.create("17"));
        b.run(d1);
        b.run(d2);
        TestStageElements.assertEquals(d2, this.p.lastPut);
        TestStageElements.assertNotSame(d2, this.p.lastPut);
    }

    public void testValuatorStageTrue() {
        ControlledValuator vs = new ControlledValuator(true);
        MockElement next = new MockElement();
        StageElement.RunValuatorSet r = new StageElement.RunValuatorSet(vs, next);
        Domain d = this.makeDomain(Node.create("_blank"), Node.create("17"));
        r.run(d);
        TestStageElements.assertTrue(next.wasRun);
        TestStageElements.assertSame(d, next.lastDomain);
    }

    public void testValuatorStageFalse() {
        ControlledValuator vs = new ControlledValuator(false);
        MockElement next = new MockElement();
        StageElement.RunValuatorSet r = new StageElement.RunValuatorSet(vs, next);
        Domain d = this.makeDomain(Node.create("_blank"), Node.create("17"));
        r.run(d);
        TestStageElements.assertFalse(next.wasRun);
        TestStageElements.assertNull(next.lastDomain);
    }

    protected Domain makeDomain(Node X) {
        return this.makeDomain(X, null);
    }

    protected Domain makeDomain(Node X, Node Y2) {
        Domain d = new Domain(3);
        d.setElement(1, X);
        d.setElement(2, Y2);
        return d;
    }

    protected static final class Pipelet
    implements Pipe {
        public Domain lastPut;

        protected Pipelet() {
        }

        public boolean hasNext() {
            return false;
        }

        public Domain get() {
            return null;
        }

        public void put(Domain d) {
            this.lastPut = d;
        }

        public void close() {
        }

        public void close(Exception e2) {
        }
    }

    protected static final class ControlledValuator
    extends ValuatorSet {
        protected boolean result;

        public ControlledValuator(boolean result) {
            this.result = result;
        }

        public boolean evalBool(IndexValues vv) {
            return this.result;
        }
    }

    protected static final class MockElement
    extends StageElement {
        public boolean wasRun = false;
        public Domain lastDomain = null;

        protected MockElement() {
        }

        public void run(Domain current) {
            this.wasRun = true;
            this.lastDomain = current;
        }
    }
}

