/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Dyadic;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.PatternLiteral;
import com.hp.hpl.jena.graph.query.Rewrite;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import junit.framework.TestSuite;

public class TestExpressions
extends QueryTestBase {
    public TestExpressions(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestExpressions.class);
    }

    public void testExpressionPatternLanguages() {
        TestExpressions.assertEquals("http://jena.hpl.hp.com/2003/07/query/RDQL", "http://jena.hpl.hp.com/2003/07/query/RDQL");
    }

    public void testBooleanEquality() {
        TestExpressions.assertEquals(Expression.TRUE, Expression.TRUE);
        TestExpressions.assertEquals(Expression.FALSE, Expression.FALSE);
        TestExpressions.assertDiffer(Expression.TRUE, Expression.FALSE);
        TestExpressions.assertDiffer(Expression.FALSE, Expression.TRUE);
    }

    public void testDyadicEquality() {
        Expression A = this.lit("Aaa");
        Expression B = this.lit("Bee");
        TestExpressions.assertDiffer(A, B);
        TestExpressions.assertEquals(this.contains(A, "groo"), this.contains(A, "groo"));
        TestExpressions.assertEquals(this.contains(B, "oops"), this.contains(B, "oops"));
        TestExpressions.assertDiffer(this.contains(A, "groo"), this.contains(A, "glue"));
        TestExpressions.assertDiffer(this.contains(A, "groo"), this.contains(B, "groo"));
        TestExpressions.assertDiffer(this.contains(A, "blue"), this.startsWith(A, "blue"));
        TestExpressions.assertDiffer(this.contains(A, "blue"), this.endsWith(A, "blue"));
        TestExpressions.assertDiffer(this.endsWith(A, "blue"), this.startsWith(A, "blue"));
    }

    public Expression contains(Expression L, PatternLiteral R) {
        return Rewrite.contains(L, R.getPatternString(), R.getPatternModifiers());
    }

    public Expression contains(Expression L, String R) {
        return Rewrite.contains(L, R, "");
    }

    public Expression endsWith(Expression L, String R) {
        return Rewrite.endsWith(L, R, "");
    }

    public Expression endsWith(Expression L, PatternLiteral R) {
        return Rewrite.endsWith(L, R.getPatternString(), R.getPatternModifiers());
    }

    public Expression startsWith(Expression L, String R) {
        return Rewrite.startsWith(L, R, "");
    }

    public Expression startsWith(Expression L, PatternLiteral R) {
        return Rewrite.startsWith(L, R.getPatternString(), R.getPatternModifiers());
    }

    public void testLiterals() {
        TestExpressions.assertTrue(Expression.TRUE.isConstant());
        TestExpressions.assertTrue(Expression.FALSE.isConstant());
        TestExpressions.assertEquals(Boolean.TRUE, Expression.TRUE.getValue());
        TestExpressions.assertEquals(Boolean.FALSE, Expression.FALSE.getValue());
    }

    public void testPrepareTRUE() {
        Valuator t = Expression.TRUE.prepare(emptyMapping);
        TestExpressions.assertEquals(true, t.evalBool(noIVs));
        TestExpressions.assertEquals(Boolean.TRUE, t.evalObject(noIVs));
    }

    public void testPrepareFALSE() {
        Valuator t = Expression.FALSE.prepare(emptyMapping);
        TestExpressions.assertEquals(false, t.evalBool(noIVs));
        TestExpressions.assertEquals(Boolean.FALSE, t.evalObject(noIVs));
    }

    public void testFixed() {
        this.testFixed("hello");
        this.testFixed("goodbye");
        this.testFixed(Boolean.TRUE);
        this.testFixed(new int[]{17, 27, 42});
    }

    protected void testFixed(Object value) {
        Expression e2 = this.lit(value);
        TestExpressions.assertEquals(value, e2.getValue());
        TestExpressions.assertEquals(value, this.evalObject(e2));
    }

    public void testDyadic() {
        Expression L = this.lit("a");
        Expression R = this.lit("b");
        Dyadic e2 = new Dyadic(L, "eh:op", R){

            public Object evalObject(Object x, Object y) {
                return "" + x + "--" + y;
            }
        };
        TestExpressions.assertEquals(2, e2.argCount());
        TestExpressions.assertSame(L, e2.getArg(0));
        TestExpressions.assertSame(R, e2.getArg(1));
        TestExpressions.assertEquals("eh:op", e2.getFun());
        TestExpressions.assertEquals((Object)"a--b", this.evalObject(e2));
    }

    public void testStartsWith() {
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("hello"), "h")));
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("hello"), "he")));
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("hello"), "hel")));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("HELLO"), "hel")));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("hello"), "HEL")));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("hello"), "e")));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("hello"), "llo")));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("hello"), "xhe")));
    }

    public void testStartsInsensitiveWith() {
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("hello"), this.pli("H"))));
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("hEllo"), this.pli("he"))));
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("heLlo"), this.pli("hEl"))));
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("HELLO"), this.pli("hel"))));
        TestExpressions.assertEquals(true, this.evalBool(this.startsWith(this.lit("hello"), this.pli("HEL"))));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("hello"), this.pli("e"))));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("hello"), this.pli("llo"))));
        TestExpressions.assertEquals(false, this.evalBool(this.startsWith(this.lit("hello"), this.pli("xhe"))));
    }

    public void testIsContains() {
        TestExpressions.assertEquals(true, Rewrite.isContains(this.pl("ambulance")));
        TestExpressions.assertEquals(true, Rewrite.isContains(this.pl("tendonitis", "i")));
        TestExpressions.assertEquals(false, Rewrite.isContains(this.pl("finishing", "z")));
    }

    public void testSensitiveContains() {
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.lit("hello"), "h")));
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.lit("hello"), "e")));
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.lit("hello"), "ll")));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("heLLo"), "ll")));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("hello"), "LL")));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("hello"), "x")));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("hello"), "the")));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("hello"), "lot")));
    }

    public void testInsensitiveContains() {
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.lit("Hello"), this.pli("h"))));
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.lit("hello"), this.pli("E"))));
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.lit("heLlo"), this.pli("lL"))));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("hello"), this.pli("X"))));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("hello"), this.pli("the"))));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.lit("hello"), this.pli("lot"))));
    }

    public void testLangedLiteralsEndsWith() {
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.litString("'spoo'en"), "o")));
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.litString("'spoo'go"), "o")));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.litString("'spot'go"), "o")));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.litString("'spot'en"), "o")));
    }

    public void testTypedLiteralsEndsWith() {
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.litString("'spoo'xsd:mint"), "o")));
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.litString("'spoo'xsd:gloo"), "o")));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.litString("'spot'xsd:slat"), "o")));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.litString("'spot'xsd:do"), "o")));
    }

    public void testLangedLiteralsContains() {
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.litString("'spoo'en"), "po")));
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.litString("'spoo'go"), "sp")));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.litString("'spot'go"), "go")));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.litString("'spot'en"), "en")));
    }

    public void testTypedLiteralsContains() {
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.litString("'spoo'xsd:mint"), "sp")));
        TestExpressions.assertEquals(true, this.evalBool(this.contains(this.litString("'spoo'xsd:gloo"), "po")));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.litString("'spot'xsd:slat"), "sl")));
        TestExpressions.assertEquals(false, this.evalBool(this.contains(this.litString("'spot'xsd:do"), "do")));
    }

    public void testEndsWith() {
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.lit("hello"), "o")));
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.lit("hello"), "lo")));
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.lit("hello"), "hello")));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("HELLO"), "hello")));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("hello"), "HELLO")));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("hello"), "ll")));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("hello"), "hel")));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("hello"), "quantum")));
    }

    public void testInsensitiveEndsWith() {
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.lit("hellO"), this.pli("o"))));
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.lit("hello"), this.pli("lO"))));
        TestExpressions.assertEquals(true, this.evalBool(this.endsWith(this.lit("HeLLo"), this.pli("HELlo"))));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("hello"), this.pli("ll"))));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("hello"), this.pli("hel"))));
        TestExpressions.assertEquals(false, this.evalBool(this.endsWith(this.lit("hello"), this.pli("quantum"))));
    }

    private Object evalObject(Expression e2) {
        return e2.prepare(emptyMapping).evalObject(noIVs);
    }

    private boolean evalBool(Expression e2) {
        return e2.prepare(emptyMapping).evalBool(noIVs);
    }

    protected Expression litString(String s) {
        return this.lit(Node.create(s));
    }

    protected Expression lit(Object x) {
        return new Expression.Fixed(x);
    }

    protected PatternLiteral pl(String c) {
        return this.pl(c, "");
    }

    protected PatternLiteral pli(String c) {
        return this.pl(c, "i");
    }

    protected PatternLiteral pl(final String c, final String m) {
        return new PatternLiteral(){

            public String getPatternString() {
                return c;
            }

            public String getPatternModifiers() {
                return m;
            }

            public String getPatternLanguage() {
                return "http://jena.hpl.hp.com/2003/07/query/RDQL";
            }
        };
    }
}

