/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.regexptrees.test;

import com.hp.hpl.jena.graph.query.regexptrees.Alternatives;
import com.hp.hpl.jena.graph.query.regexptrees.AnyOf;
import com.hp.hpl.jena.graph.query.regexptrees.AnySingle;
import com.hp.hpl.jena.graph.query.regexptrees.BackReference;
import com.hp.hpl.jena.graph.query.regexptrees.EndOfLine;
import com.hp.hpl.jena.graph.query.regexptrees.NoneOf;
import com.hp.hpl.jena.graph.query.regexptrees.Nothing;
import com.hp.hpl.jena.graph.query.regexptrees.OneOrMore;
import com.hp.hpl.jena.graph.query.regexptrees.Optional;
import com.hp.hpl.jena.graph.query.regexptrees.Paren;
import com.hp.hpl.jena.graph.query.regexptrees.PerlPatternParser;
import com.hp.hpl.jena.graph.query.regexptrees.RegexpTree;
import com.hp.hpl.jena.graph.query.regexptrees.Sequence;
import com.hp.hpl.jena.graph.query.regexptrees.SimpleGenerator;
import com.hp.hpl.jena.graph.query.regexptrees.StartOfLine;
import com.hp.hpl.jena.graph.query.regexptrees.Text;
import com.hp.hpl.jena.graph.query.regexptrees.ZeroOrMore;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import java.util.Arrays;
import junit.framework.TestSuite;

public class TestPerlyParser
extends GraphTestBase {
    public TestPerlyParser(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestPerlyParser.class);
    }

    public void testAlternateGenerator() {
        SimpleGenerator g = new SimpleGenerator(){

            public RegexpTree getAnySingle() {
                throw new FlagException();
            }
        };
        PerlPatternParser p = new PerlPatternParser(".", g);
        try {
            p.parseAtom();
            TestPerlyParser.fail("should be using supplied generator");
        }
        catch (FlagException e2) {
            TestPerlyParser.pass();
        }
    }

    public void testLit() {
        TestPerlyParser.assertEquals(Text.create("a"), Text.create("a"));
        TestPerlyParser.assertDiffer(Text.create("a"), Text.create("b"));
        TestPerlyParser.assertEquals(Text.create("aga").hashCode(), Text.create("aga").hashCode());
    }

    public void testInitialParserState() {
        TestPerlyParser.assertEquals(0, new PerlPatternParser("hello").getPointer());
        TestPerlyParser.assertEquals("hello", new PerlPatternParser("hello").getString());
    }

    public void testLetterAtoms() {
        for (char ch = '\u0000'; ch < '\u0100'; ch = (char)(ch + '\u0001')) {
            if (!Character.isLetter(ch)) continue;
            PerlPatternParser p = new PerlPatternParser("" + ch);
            TestPerlyParser.assertEquals(Text.create(ch), p.parseAtom());
            TestPerlyParser.assertEquals(1, p.getPointer());
        }
    }

    public void testEmptyExpression() {
        TestPerlyParser.assertEquals(new Nothing(), this.element(""));
    }

    public void testDotAtom() {
        this.testSimpleSpecialAtom(RegexpTree.ANY, ".");
    }

    public void testHatAtom() {
        this.testSimpleSpecialAtom(RegexpTree.SOL, "^");
    }

    public void testDollarAtom() {
        this.testSimpleSpecialAtom(RegexpTree.EOL, "$");
    }

    public void testTerminatorsReturnNull() {
        TestPerlyParser.assertEquals(new Nothing(), this.element("|"));
    }

    public void testSimpleBackslashEscapes() {
        for (char ch = '\u0000'; ch < '\u0100'; ch = (char)(ch + '\u0001')) {
            if ("bBAZnrtfdDwWSsxc0123456789".indexOf(ch) >= 0) continue;
            TestPerlyParser.assertEquals(Text.create(ch), new PerlPatternParser("\\" + ch).parseAtom());
        }
    }

    public void testSpecialBackslashEscapes() {
        String specials = "bBAZ";
        for (int i = 0; i < specials.length(); ++i) {
            try {
                new PerlPatternParser("\\" + specials.charAt(i)).parseAtom();
                TestPerlyParser.fail("backslash escape " + specials.charAt(i));
                continue;
            }
            catch (PerlPatternParser.SyntaxException e2) {
                TestPerlyParser.pass();
            }
        }
    }

    public void testWordEscapes() {
        String letters = "abcdefghijklmnopqrstuvwxyz";
        String wordChars = "0123456789" + letters + "_" + letters.toUpperCase();
        TestPerlyParser.assertEquals(new AnyOf(wordChars), this.element("\\w"));
        TestPerlyParser.assertEquals(new NoneOf(wordChars), this.element("\\W"));
    }

    public void testDigitEscapes() {
        TestPerlyParser.assertEquals(new AnyOf("0123456789"), this.element("\\d"));
        TestPerlyParser.assertEquals(new NoneOf("0123456789"), this.element("\\D"));
    }

    public void testWhitespaceEscapes() {
        TestPerlyParser.assertEquals(Text.create("\n"), this.element("\\n"));
        TestPerlyParser.assertEquals(Text.create("\t"), this.element("\\t"));
        TestPerlyParser.assertEquals(Text.create("\f"), this.element("\\f"));
        TestPerlyParser.assertEquals(Text.create("\r"), this.element("\\r"));
        TestPerlyParser.assertEquals(new AnyOf(" \r\n\t\f"), this.element("\\s"));
        TestPerlyParser.assertEquals(new NoneOf(" \r\n\t\f"), this.element("\\S"));
    }

    public void testHexEscapes() {
        this.assertParse(Text.create("\u00ac"), "\\xac");
        this.assertParse(Text.create("\u00ff"), "\\xff");
        this.assertParse(Text.create("\u0012"), "\\x12");
        this.assertParse(Text.create("\u00af"), "\\xAF");
    }

    public void testControlEscapes() {
        this.assertParse(Text.create("\u0001"), "\\cA");
        this.assertParse(Text.create("\u001a"), "\\cZ");
    }

    public void testNoQuantifier() {
        RegexpTree d = RegexpTree.ANY;
        TestPerlyParser.assertSame(d, this.quantifier("", d));
        TestPerlyParser.assertSame(d, this.quantifier("x", d));
        TestPerlyParser.assertSame(d, this.quantifier("[", d));
        TestPerlyParser.assertSame(d, this.quantifier("(", d));
        TestPerlyParser.assertSame(d, this.quantifier(".", d));
        TestPerlyParser.assertSame(d, this.quantifier("\\", d));
    }

    public void testStarQuantifier() {
        RegexpTree d = RegexpTree.EOL;
        TestPerlyParser.assertEquals(new ZeroOrMore(d), this.quantifier("*", d));
    }

    public void testPlusQuantifier() {
        RegexpTree d = RegexpTree.SOL;
        TestPerlyParser.assertEquals(new OneOrMore(d), this.quantifier("+", d));
    }

    public void testQueryQuantifier() {
        RegexpTree d = RegexpTree.ANY;
        TestPerlyParser.assertEquals(new Optional(d), this.quantifier("?", d));
    }

    public void testUnboundQuantifiers() {
        this.testUnboundQuantifier("*");
        this.testUnboundQuantifier("+");
        this.testUnboundQuantifier("?");
        this.testUnboundQuantifier("{");
    }

    private void testUnboundQuantifier(String q) {
        PerlPatternParser p = new PerlPatternParser(q);
        try {
            p.parseElement();
            TestPerlyParser.fail("must trap unbound quantifier " + q);
        }
        catch (PerlPatternParser.SyntaxException e2) {
            TestPerlyParser.pass();
        }
    }

    public void testUnitSeq() {
        PerlPatternParser p = new PerlPatternParser("x");
        TestPerlyParser.assertEquals(Text.create("x"), p.parseSeq());
    }

    public void testSeq() {
        PerlPatternParser p = new PerlPatternParser("^.$");
        TestPerlyParser.assertEquals(this.seq3(new StartOfLine(), new AnySingle(), new EndOfLine()), p.parseSeq());
    }

    public void testBracketConstruction() {
        this.assertParse(new Paren(Text.create("x")), "(x)");
    }

    public void testBracketClosure() {
        PerlPatternParser p = new PerlPatternParser("()y");
        TestPerlyParser.assertEquals(this.seq2(new Paren(new Nothing()), Text.create("y")), p.parseAlts());
    }

    public void testDetectsMissingClosingBracket() {
        PerlPatternParser p = new PerlPatternParser("(x");
        try {
            p.parseAlts();
            TestPerlyParser.fail("should detect missing close bracket");
        }
        catch (PerlPatternParser.SyntaxException e2) {
            TestPerlyParser.pass();
        }
    }

    public void testAlt() {
        PerlPatternParser L = new PerlPatternParser("abc");
        PerlPatternParser R = new PerlPatternParser("def");
        PerlPatternParser p = new PerlPatternParser("abc|def");
        TestPerlyParser.assertEquals(this.alt(L.parseSeq(), R.parseSeq()), p.parseAlts());
    }

    public void testSimpleClass() {
        this.assertParse(new AnyOf("x1B"), "[x1B]");
    }

    public void testSimpleClassNegated() {
        this.assertParse(new NoneOf("b0#"), "[^b0#]");
    }

    public void testClassRangeAlphabet() {
        this.assertParse(new AnyOf("ABCDEFGHIJKLMNOPQRSTUVWXYZ"), "[A-Z]");
    }

    public void testClassRangeSomeLetters() {
        this.assertParse(new AnyOf("abcdef"), "[a-f]");
    }

    public void testClassRangeDigits() {
        this.assertParse(new AnyOf("abc0123456789rst"), "[a-c0-9r-t]");
    }

    public void testClassHats() {
        this.assertParse(new AnyOf("ab^cd"), "[ab^cd]");
    }

    public void testClassRange() {
        this.assertParse(new AnyOf("-R"), "[-R]");
    }

    public void testClassBackslash() {
        this.assertParse(new AnyOf("]"), "[\\]]");
    }

    public void testBackReference() {
        this.assertParse(this.seq2(new Paren(Text.create("x")), new BackReference(1)), "(x)\\1");
    }

    public void testOctalNonBackReference() {
        this.assertParse(this.seq2(new Paren(Text.create("x")), Text.create("\b")), "(x)\\10");
    }

    protected RegexpTree seq2(RegexpTree a, RegexpTree b) {
        return Sequence.create(Arrays.asList(a, b));
    }

    protected RegexpTree seq3(RegexpTree a, RegexpTree b, RegexpTree c) {
        return Sequence.create(Arrays.asList(a, b, c));
    }

    protected RegexpTree alt(RegexpTree L, RegexpTree R) {
        return Alternatives.create(Arrays.asList(L, R));
    }

    public void testPerlParse() {
        TestPerlyParser.assertInstanceOf(Alternatives.class, PerlPatternParser.parse("this is|a pattern"));
        TestPerlyParser.assertInstanceOf(Alternatives.class, PerlPatternParser.parse("this is|a pattern", new SimpleGenerator()));
    }

    public void testOldSeq() {
        PerlPatternParser p = new PerlPatternParser("hello");
        TestPerlyParser.assertEquals(Text.create("h"), p.parseAtom());
        TestPerlyParser.assertEquals(1, p.getPointer());
        TestPerlyParser.assertEquals(Text.create("e"), p.parseAtom());
        TestPerlyParser.assertEquals(2, p.getPointer());
        TestPerlyParser.assertEquals(Text.create("l"), p.parseAtom());
        TestPerlyParser.assertEquals(3, p.getPointer());
        TestPerlyParser.assertEquals(Text.create("l"), p.parseAtom());
        TestPerlyParser.assertEquals(4, p.getPointer());
        TestPerlyParser.assertEquals(Text.create("o"), p.parseAtom());
        TestPerlyParser.assertEquals(5, p.getPointer());
        TestPerlyParser.assertEquals(new Nothing(), p.parseAtom());
    }

    public void assertParse(RegexpTree wanted, String toParse) {
        TestPerlyParser.assertEquals(wanted, new PerlPatternParser(toParse).parseAlts());
    }

    public void testSimpleSpecialAtom(Object wanted, String toParse) {
        PerlPatternParser p = new PerlPatternParser(toParse);
        TestPerlyParser.assertEquals(wanted, p.parseAtom());
        TestPerlyParser.assertEquals(1, p.getPointer());
    }

    protected RegexpTree quantifier(String toParse, RegexpTree x) {
        return new PerlPatternParser(toParse).parseQuantifier(x);
    }

    protected RegexpTree element(String toParse) {
        return new PerlPatternParser(toParse).parseElement();
    }

    protected static class FlagException
    extends RuntimeException {
        protected FlagException() {
        }
    }
}

