/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.test.AbstractTestReifier;
import com.hp.hpl.jena.graph.test.MetaTestGraph;
import com.hp.hpl.jena.shared.ReificationStyle;
import junit.framework.TestSuite;

public class TestReifier
extends AbstractTestReifier {
    private int count;
    private Graph properties;
    private IDBConnection con;

    public TestReifier(String name) {
        super(name);
    }

    public TestReifier(Class graphClass, String name, ReificationStyle style) {
        super(name);
    }

    public static TestSuite suite() {
        return MetaTestGraph.suite(TestReifier.class, LocalGraphRDB.class);
    }

    public void setUp() {
        this.con = TestConnection.makeAndCleanTestConnection();
        this.properties = this.con.getDefaultModelProperties().getGraph();
    }

    public void tearDown() throws Exception {
        this.con.close();
    }

    public Graph getGraph(ReificationStyle style) {
        return new LocalGraphRDB(style);
    }

    public Graph getGraph() {
        return this.getGraph(ReificationStyle.Minimal);
    }

    public class LocalGraphRDB
    extends GraphRDB {
        public LocalGraphRDB(ReificationStyle style) {
            super(TestReifier.this.con, "testGraph-" + TestReifier.this.count++, TestReifier.this.properties, LocalGraphRDB.styleRDB(style), true);
        }
    }
}

