/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.impl.DriverMap;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.test.JenaTestBase;
import com.hp.hpl.jena.util.FileManager;
import java.io.InputStream;
import junit.framework.TestSuite;

public class TestDriverMap
extends JenaTestBase {
    public TestDriverMap(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestDriverMap.class);
    }

    public void testAddDrivers() {
        String className = "some.class.name";
        String otherClassName = "other.class.name";
        TestDriverMap.assertEquals(null, DriverMap.get("test-absent-A"));
        TestDriverMap.assertEquals(null, DriverMap.get("test-Absent-A"));
        TestDriverMap.assertEquals(null, DriverMap.get("Test-absent-A"));
        TestDriverMap.assertEquals(null, DriverMap.get("tEST-absent-A"));
        TestDriverMap.assertEquals(null, DriverMap.get("test-absent-B"));
        TestDriverMap.assertEquals(null, DriverMap.get("test-absent-B"));
        DriverMap.add("test-absent-A", className);
        TestDriverMap.assertEquals(className, DriverMap.get("test-absent-A"));
        TestDriverMap.assertEquals(className, DriverMap.get("test-absent-A"));
        TestDriverMap.assertEquals(className, DriverMap.get("test-Absent-A"));
        TestDriverMap.assertEquals(className, DriverMap.get("Test-absent-A"));
        TestDriverMap.assertEquals(className, DriverMap.get("tEST-absent-A"));
        TestDriverMap.assertEquals(null, DriverMap.get("test-absent-B"));
        TestDriverMap.assertEquals(null, DriverMap.get("test-absent-B"));
        DriverMap.add("test-absent-B", otherClassName);
        TestDriverMap.assertEquals(otherClassName, DriverMap.get("test-absent-B"));
        TestDriverMap.assertEquals(otherClassName, DriverMap.get("test-absent-B"));
        TestDriverMap.assertEquals(className, DriverMap.get("test-absent-A"));
        TestDriverMap.assertEquals(className, DriverMap.get("test-absent-A"));
    }

    public void testBuiltinDrivers() {
        TestDriverMap.assertEquals("com.mysql.jdbc.Driver", DriverMap.get("mysql"));
        TestDriverMap.assertEquals("org.postgresql.Driver", DriverMap.get("postgres"));
        TestDriverMap.assertEquals("org.postgresql.Driver", DriverMap.get("postgresql"));
    }

    public void testNormalDrivers() {
        TestDriverMap.assertEquals("test.fake.Driver", DriverMap.get("test-fake-driver"));
        this.testDrivers(FileManager.get().open("etc/db-default-drivers.n3"));
    }

    public void testExtraDrivers() {
        this.testDrivers(FileManager.get().open("etc/db-extra-drivers.n3"));
    }

    protected void testDrivers(InputStream in) {
        if (in != null) {
            Resource ANY = null;
            Model m = ModelFactory.createDefaultModel();
            m.read(in, "", "N3");
            StmtIterator A = m.listStatements(ANY, DriverMap.driverClass, ANY);
            while (A.hasNext()) {
                Statement st = A.nextStatement();
                Resource S = st.getSubject();
                String className = st.getString();
                StmtIterator B = m.listStatements(S, DriverMap.driverName, ANY);
                while (B.hasNext()) {
                    String name = B.nextStatement().getString();
                    TestDriverMap.assertEquals(className, DriverMap.get(name));
                }
            }
        }
    }
}

