/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Resource;

public class TestMode
extends AssemblerTestBase {
    static final String someName = "aName";
    static final Resource someRoot = TestMode.resource("aRoot");

    public TestMode(String name) {
        super(name);
    }

    public void testConstantsExist() {
        Mode a = Mode.CREATE;
        Mode b = Mode.DEFAULT;
        Mode c = Mode.REUSE;
        Mode d = Mode.ANY;
        TestMode.assertDiffer(Mode.CREATE, Mode.DEFAULT);
        TestMode.assertDiffer(Mode.CREATE, Mode.REUSE);
        TestMode.assertDiffer(Mode.CREATE, Mode.ANY);
        TestMode.assertDiffer(Mode.DEFAULT, Mode.REUSE);
        TestMode.assertDiffer(Mode.DEFAULT, Mode.ANY);
        TestMode.assertDiffer(Mode.REUSE, Mode.ANY);
    }

    public void testCreate() {
        TestMode.assertEquals(true, Mode.CREATE.permitCreateNew(someRoot, someName));
        TestMode.assertEquals(false, Mode.CREATE.permitUseExisting(someRoot, someName));
    }

    public void testReuse() {
        TestMode.assertEquals(false, Mode.REUSE.permitCreateNew(someRoot, someName));
        TestMode.assertEquals(true, Mode.REUSE.permitUseExisting(someRoot, someName));
    }

    public void testAny() {
        TestMode.assertEquals(true, Mode.ANY.permitCreateNew(someRoot, someName));
        TestMode.assertEquals(true, Mode.ANY.permitUseExisting(someRoot, someName));
    }

    public void testDefault() {
        TestMode.assertEquals(false, Mode.DEFAULT.permitCreateNew(someRoot, someName));
        TestMode.assertEquals(true, Mode.DEFAULT.permitUseExisting(someRoot, someName));
    }
}

