/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.BadObjectException;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.assemblers.DocumentManagerAssembler;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import junit.framework.Assert;

public class TestDocumentManagerAssembler
extends AssemblerTestBase {
    public TestDocumentManagerAssembler(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return DocumentManagerAssembler.class;
    }

    public void testDocumentManagerAssemblerType() {
        this.testDemandsMinimalType(new DocumentManagerAssembler(), JA.DocumentManager);
    }

    public void testDocumentManagerVocabulary() {
        this.assertSubclassOf(JA.DocumentManager, JA.Object);
        this.assertDomain(JA.DocumentManager, JA.fileManager);
        this.assertRange(JA.FileManager, JA.fileManager);
        this.assertDomain(JA.DocumentManager, JA.policyPath);
    }

    public void testCreatesDocumentManager() {
        Resource root = this.resourceInModel("x rdf:type ja:DocumentManager");
        DocumentManagerAssembler a = new DocumentManagerAssembler();
        Object x = a.open(root);
        TestDocumentManagerAssembler.assertInstanceOf(OntDocumentManager.class, x);
    }

    public void testUsesFileManager() {
        Resource root = this.resourceInModel("x rdf:type ja:DocumentManager; x ja:fileManager f");
        DocumentManagerAssembler a = new DocumentManagerAssembler();
        FileManager fm = new FileManager();
        AssemblerTestBase.NamedObjectAssembler mock = new AssemblerTestBase.NamedObjectAssembler(TestDocumentManagerAssembler.resource("f"), fm);
        Object x = a.open(mock, root);
        TestDocumentManagerAssembler.assertInstanceOf(OntDocumentManager.class, x);
        TestDocumentManagerAssembler.assertSame(fm, ((OntDocumentManager)x).getFileManager());
    }

    public void testSetsPolicyPath() {
        Resource root = this.resourceInModel("x rdf:type ja:DocumentManager; x ja:policyPath 'somePath'");
        final ArrayList history = new ArrayList();
        DocumentManagerAssembler a = new DocumentManagerAssembler(){

            protected OntDocumentManager createDocumentManager() {
                return new OntDocumentManager(""){

                    public void setMetadataSearchPath(String path, boolean replace) {
                        Assert.assertEquals(false, replace);
                        history.add(path);
                        super.setMetadataSearchPath(path, replace);
                    }
                };
            }
        };
        OntDocumentManager d = (OntDocumentManager)a.open(root);
        TestDocumentManagerAssembler.assertEquals(TestDocumentManagerAssembler.listOfOne("somePath"), history);
    }

    public void testTrapsPolicyPathNotString() {
        this.testTrapsBadPolicyPath("aResource");
        this.testTrapsBadPolicyPath("17");
        this.testTrapsBadPolicyPath("'char'en");
        this.testTrapsBadPolicyPath("'cafe'xsd:integer");
    }

    private void testTrapsBadPolicyPath(String path) {
        Resource root = this.resourceInModel("x rdf:type ja:DocumentManager; x ja:policyPath <policy>".replaceAll("<policy>", path));
        ArrayList history = new ArrayList();
        DocumentManagerAssembler a = new DocumentManagerAssembler();
        try {
            a.open(root);
            TestDocumentManagerAssembler.fail("should trap illegal policy path object " + path);
        }
        catch (BadObjectException e2) {
            TestDocumentManagerAssembler.assertEquals(TestDocumentManagerAssembler.resource("x"), e2.getRoot());
            TestDocumentManagerAssembler.assertEquals(TestDocumentManagerAssembler.rdfNode(root.getModel(), path), e2.getObject());
        }
    }

    public void testSetsMetadata() {
        Resource root = this.resourceInModel("x rdf:type ja:DocumentManager; x ja:policyPath ''; x P a; a Q b; y R z");
        final Model expected = this.model("x rdf:type ja:DocumentManager; x ja:policyPath ''; x P a; a Q b");
        final ArrayList history = new ArrayList();
        DocumentManagerAssembler a = new DocumentManagerAssembler(){

            protected OntDocumentManager createDocumentManager() {
                return new OntDocumentManager(""){

                    public void processMetadata(Model m) {
                        ModelTestBase.assertIsoModels(expected, m);
                        history.add("called");
                        super.processMetadata(m);
                    }
                };
            }
        };
        OntDocumentManager d = (OntDocumentManager)a.open(root);
        TestDocumentManagerAssembler.assertEquals(TestDocumentManagerAssembler.listOfOne("called"), history);
    }
}

