/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.AssemblerHelp;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.assemblers.AssemblerGroup;
import com.hp.hpl.jena.assembler.exceptions.NoSpecificTypeException;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.BadDescriptionMultipleRootsException;
import com.hp.hpl.jena.shared.BadDescriptionNoRootException;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;

public class TestAssemblerHelp
extends AssemblerTestBase {
    public static boolean impIsLoaded = false;
    public static boolean impIsConstructed = false;
    static Model gremlinModel = TestAssemblerHelp.modelWithStatements("eh:Wossname ja:assembler 'com.hp.hpl.jena.assembler.test.TestAssemblerHelp$Gremlin'");
    static boolean gremlinInvoked = false;

    public TestAssemblerHelp(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        throw new BrokenException("TestAssemblers does not need this method");
    }

    public void testClosureFootprint() {
        Resource root = this.resourceInModel("x ja:reasoner y");
        Statement footprint = root.getModel().createStatement(JA.This, RDF.type, JA.Expanded);
        TestAssemblerHelp.assertFalse(root.getModel().contains(footprint));
        Resource expanded = AssemblerHelp.withFullModel(root);
        TestAssemblerHelp.assertTrue(expanded.getModel().contains(footprint));
    }

    public void testFootprintPreventsClosure() {
        Resource root = this.resourceInModel("x ja:reasoner y; ja:this rdf:type ja:Expanded");
        Model original = this.model("").add(root.getModel());
        Resource expanded = AssemblerHelp.withFullModel(root);
        TestAssemblerHelp.assertSame(root, expanded);
        TestAssemblerHelp.assertIsoModels(original, expanded.getModel());
    }

    public void testSpecificType() {
        this.testSpecificType("ja:Connectable", "x ja:connection _C");
        this.testSpecificType("ja:NamedModel", "x ja:modelName 'name'");
        this.testSpecificType("ja:NamedModel", "x ja:modelName 'name'; x rdf:type irrelevant");
        this.testSpecificType("ja:RDBModel", "x rdf:type ja:RDBModel; x rdf:type ja:Model");
    }

    public void testFindRootByExplicitType() {
        Model model = this.model("x rdf:type ja:Object; y rdf:type Irrelevant");
        Set roots = AssemblerHelp.findAssemblerRoots(model);
        TestAssemblerHelp.assertEquals(TestAssemblerHelp.resourceSet("x"), roots);
    }

    public void testFindRootByImplicitType() {
        Model model = this.model("x ja:reificationMode ja:Standard");
        Set roots = AssemblerHelp.findAssemblerRoots(model);
        TestAssemblerHelp.assertEquals(TestAssemblerHelp.resourceSet("x"), roots);
    }

    public void testFindMultipleRoots() {
        Model model = this.model("x rdf:type ja:Object; y ja:reificationMode ja:Minimal");
        Set roots = AssemblerHelp.findAssemblerRoots(model);
        TestAssemblerHelp.assertEquals(TestAssemblerHelp.resourceSet("y x"), roots);
    }

    public void testFindRootsWithSpecifiedType() {
        Model model = this.model("x rdf:type ja:Model; y rdf:type ja:Object");
        Set roots = AssemblerHelp.findAssemblerRoots(model, JA.Model);
        TestAssemblerHelp.assertEquals(TestAssemblerHelp.resourceSet("x"), roots);
    }

    public void testThrowsIfNoRoots() {
        try {
            AssemblerHelp.singleModelRoot(this.model(""));
            TestAssemblerHelp.fail("should trap if no roots");
        }
        catch (BadDescriptionNoRootException e2) {
            TestAssemblerHelp.pass();
        }
    }

    public void testThrowsIfManyRoots() {
        try {
            AssemblerHelp.singleModelRoot(this.model("a rdf:type ja:Model; b rdf:type ja:Model"));
            TestAssemblerHelp.fail("should trap if many roots");
        }
        catch (BadDescriptionMultipleRootsException e2) {
            TestAssemblerHelp.pass();
        }
    }

    public void testExtractsSingleRoot() {
        Resource it = AssemblerHelp.singleModelRoot(this.model("a rdf:type ja:Model"));
        TestAssemblerHelp.assertEquals(TestAssemblerHelp.resource("a"), it);
    }

    public void testSpecificTypeFails() {
        try {
            this.testSpecificType("xxx", "x rdf:type ja:Model; x rdf:type ja:PrefixMapping");
            TestAssemblerHelp.fail("should trap multiple types");
        }
        catch (NoSpecificTypeException e2) {
            TestAssemblerHelp.assertEquals(TestAssemblerHelp.resource("x"), e2.getRoot());
            TestAssemblerHelp.assertEquals(this.resources(e2.getRoot(), "ja:Model ja:PrefixMapping"), new HashSet(e2.getTypes()));
        }
    }

    private Set resources(Resource root, String items) {
        List L = TestAssemblerHelp.listOfStrings(items);
        HashSet<Resource> result = new HashSet<Resource>();
        for (int i = 0; i < L.size(); ++i) {
            result.add(TestAssemblerHelp.resource(root.getModel(), (String)L.get(i)));
        }
        return result;
    }

    private void testSpecificType(String expected, String specification) {
        Resource root = this.resourceInModel(specification);
        Resource rooted = (Resource)root.inModel(AssemblerHelp.fullModel(root.getModel()));
        Resource mst = AssemblerHelp.findSpecificType(rooted);
        TestAssemblerHelp.assertEquals(TestAssemblerHelp.resource(root.getModel(), expected), mst);
    }

    public void testClassAssociation() {
        String className = "com.hp.hpl.jena.assembler.test.TestAssemblerHelp$Imp";
        AssemblerGroup group = AssemblerGroup.create();
        Model m = this.model("eh:Wossname ja:assembler '" + className + "'");
        TestAssemblerHelp.assertEquals(false, impIsLoaded);
        AssemblerHelp.loadClasses(group, m);
        TestAssemblerHelp.assertEquals(true, impIsLoaded);
        TestAssemblerHelp.assertEquals(true, impIsConstructed);
        TestAssemblerHelp.assertEquals(className, group.assemblerFor(TestAssemblerHelp.resource("eh:Wossname")).getClass().getName());
    }

    public void testClassResourceConstructor() {
        AssemblerGroup group = AssemblerGroup.create();
        Model m = this.model("eh:Wossname ja:assembler 'com.hp.hpl.jena.assembler.test.TestAssemblerHelp$Gremlin'");
        TestAssemblerHelp.assertEquals(false, gremlinInvoked);
        AssemblerHelp.loadClasses(group, m);
        TestAssemblerHelp.assertEquals(true, gremlinInvoked);
    }

    public static class Gremlin
    extends AssemblerBase {
        public Gremlin() {
            Assert.fail("Gremlin no-argument constructor should not be called");
        }

        public Gremlin(Resource root) {
            Assert.assertEquals(ModelTestBase.resource("eh:Wossname"), root);
            ModelTestBase.assertIsoModels(gremlinModel, root.getModel());
            gremlinInvoked = true;
        }

        public Object open(Assembler a, Resource root, Mode irrelevant) {
            return null;
        }
    }

    public static class Imp
    extends AssemblerBase {
        public Imp() {
            impIsConstructed = true;
        }

        public Object open(Assembler a, Resource root, Mode irrelevant) {
            return null;
        }

        static {
            impIsLoaded = true;
        }
    }
}

