/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmd.CmdUtils;
import arq.cmd.TerminationException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdLineArgs;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.io.PrintStream;
import java.util.Iterator;

public class qexpr {
    public static void main(String[] argv) {
        block3: {
            try {
                qexpr.main2(argv);
            }
            catch (TerminationException ex) {
                System.exit(ex.getCode());
            }
            catch (CmdException ex) {
                System.err.println(ex.getMessage());
                if (ex.getCause() == null) break block3;
                ex.getCause().printStackTrace(System.err);
            }
        }
    }

    public static void main2(String[] argv) {
        CmdLineArgs cl = new CmdLineArgs(argv);
        ArgDecl helpDecl = new ArgDecl(false, "h", "help");
        cl.add(helpDecl);
        ArgDecl verboseDecl = new ArgDecl(false, "v", "verbose");
        cl.add(verboseDecl);
        ArgDecl versionDecl = new ArgDecl(false, "ver", "version", "V");
        cl.add(versionDecl);
        ArgDecl quietDecl = new ArgDecl(false, "q", "quiet");
        cl.add(quietDecl);
        ArgDecl reduceDecl = new ArgDecl(false, "reduce", "fold", "simplify");
        cl.add(reduceDecl);
        ArgDecl strictDecl = new ArgDecl(false, "strict");
        cl.add(strictDecl);
        ArgDecl printDecl = new ArgDecl(true, "print");
        cl.add(printDecl);
        try {
            cl.process();
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex.getMessage());
            qexpr.usage(System.err);
            throw new CmdException();
        }
        if (cl.contains(helpDecl)) {
            qexpr.usage();
            throw new TerminationException(0);
        }
        if (cl.contains(versionDecl)) {
            System.out.println("ARQ Version: 2.0 (Jena: 2.5.3-dev)");
            throw new TerminationException(0);
        }
        boolean verbose = cl.contains(verboseDecl);
        boolean quiet = cl.contains(quietDecl);
        if (cl.contains(strictDecl)) {
            ARQ.getContext().set(ARQ.extensionValueTypes, false);
        }
        boolean actionCopySubstitute = cl.contains(reduceDecl);
        boolean actionPrintPrefix = false;
        boolean actionPrintSPARQL = false;
        boolean actionPrint = cl.contains(printDecl);
        Iterator iter = cl.getValues(printDecl).iterator();
        while (iter.hasNext()) {
            String v = (String)iter.next();
            if (v.equalsIgnoreCase("prefix")) {
                actionPrintPrefix = true;
                continue;
            }
            if (v.equalsIgnoreCase("expr")) {
                actionPrintSPARQL = true;
                continue;
            }
            System.err.println("Unknown print form: " + v);
            throw new TerminationException(0);
        }
        for (int i = 0; i < cl.getNumPositional(); ++i) {
            String exprStr = cl.getPositionalArg(i);
            exprStr = cl.indirect(exprStr);
            try {
                PrefixMapping pmap = PrefixMapping.Factory.create();
                pmap.setNsPrefixes(ARQConstants.getGlobalPrefixMap());
                pmap.setNsPrefix("", "http://example/");
                pmap.setNsPrefix("ex", "http://example/ns#");
                Expr expr = ExprUtils.parse(exprStr, pmap);
                if (verbose) {
                    System.out.print(expr.toString() + " => ");
                }
                if (actionPrint) {
                    if (actionPrintSPARQL) {
                        System.out.println(ExprUtils.fmtSPARQL(expr));
                    }
                    if (actionPrintPrefix) {
                        System.out.println(ExprUtils.fmtPrefix(expr));
                    }
                    continue;
                }
                try {
                    if (actionCopySubstitute) {
                        Expr e2 = expr.copySubstitute(new BindingMap(), true);
                        System.out.println(e2.toString());
                        continue;
                    }
                    ExecutionContext env = new ExecutionContext(ARQ.getContext(), null, null);
                    NodeValue r = expr.eval(null, env);
                    Node n = r.asNode();
                    String s = FmtUtils.stringForNode(n);
                    System.out.println(s);
                    continue;
                }
                catch (ExprEvalException ex) {
                    System.out.println("Exception: " + ex.getMessage());
                    throw new TerminationException(2);
                }
            }
            catch (QueryParseException ex) {
                System.err.println("Parse error: " + ex.getMessage());
                throw new TerminationException(2);
            }
        }
    }

    static void usage() {
        qexpr.usage(System.out);
    }

    static void usage(PrintStream out) {
        out.println("Usage: expression");
    }

    static {
        CmdUtils.setLog4j();
        CmdUtils.setN3Params();
    }
}

