/*
 * Decompiled with CFR 0.152.
 */
package arq.examples;

import arq.examples.ExLucene1;
import com.hp.hpl.jena.query.larq.IndexBuilderSubject;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.util.StringUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.DC;

public class ExLucene4 {
    public static void main(String[] a) throws Exception {
        System.out.println("ARQ Example: " + Utils.classShortName(ExLucene4.class));
        System.out.println("ARQ: 2.0");
        System.out.println();
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = ExLucene4.buildSubjectTitleIndex(model, "testing/LARQ/data-1.ttl");
        String searchString = "+document";
        String queryString = StringUtils.join("\n", new String[]{"PREFIX xsd:    <http://www.w3.org/2001/XMLSchema#>", "PREFIX :       <http://example/>", "PREFIX pf:     <http://jena.hpl.hp.com/ARQ/property#>", "PREFIX  dc:    <http://purl.org/dc/elements/1.1/>", "SELECT ?doc {", "    ?doc pf:textMatch '" + searchString + "'.", "}"});
        ExLucene1.performQuery(model, index, queryString);
        index.close();
    }

    static IndexLARQ buildSubjectTitleIndex(Model model, String datafile) {
        IndexBuilderSubject larqBuilder = new IndexBuilderSubject(DC.title);
        model.register(larqBuilder);
        FileManager.get().readModel(model, datafile);
        larqBuilder.closeForWriting();
        model.unregister(larqBuilder);
        IndexLARQ index = larqBuilder.getIndex();
        return index;
    }
}

