/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModDataset;
import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.sparql.core.assembler.DatasetAssemblerVocab;
import com.hp.hpl.jena.sparql.util.GraphUtils;
import com.hp.hpl.jena.sparql.util.TypeNotUniqueException;
import com.hp.hpl.jena.util.FileManager;

public class ModAssembler
extends ModDataset {
    protected final ArgDecl assemblerDescDecl = new ArgDecl(true, "desc", "dataset");
    String assemblerFile = null;

    public ModAssembler() {
        AssemblerUtils.init();
    }

    public void processArgs(CmdArgModule cmdLine) {
        super.processArgs(cmdLine);
        if (cmdLine.contains(this.assemblerDescDecl)) {
            this.assemblerFile = cmdLine.getValue(this.assemblerDescDecl);
        }
    }

    public void registerWith(CmdGeneral cmdLine) {
        super.registerWith(cmdLine);
        cmdLine.add(this.assemblerDescDecl, "--desc=", "Description of dataset");
    }

    public Dataset getDataset() {
        if (this.dataset != null) {
            return this.dataset;
        }
        if (this.assemblerFile == null) {
            return super.getDataset();
        }
        DataSource ds = null;
        try {
            Model spec = null;
            try {
                spec = FileManager.get().loadModel(this.assemblerFile);
            }
            catch (Exception ex) {
                throw new CmdException("Failed reading dataset description: " + ex.getMessage());
            }
            Resource root = null;
            try {
                root = GraphUtils.getResourceByType(spec, DatasetAssemblerVocab.tDataset);
                if (root == null) {
                    String s = spec.shortForm(DatasetAssemblerVocab.tDataset.getURI());
                    throw new CmdException("No single resource for type " + s);
                }
            }
            catch (TypeNotUniqueException ex) {
                throw new CmdException("Multiple types for: " + DatasetAssemblerVocab.tDataset);
            }
            ds = (DataSource)Assembler.general.open(root);
        }
        catch (CmdException ex) {
            throw ex;
        }
        catch (NotFoundException ex) {
            throw new CmdException("Not found: " + ex.getMessage());
        }
        catch (JenaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Error creating dataset", ex);
        }
        this.dataset = ds;
        super.addGraphs(ds);
        return this.dataset;
    }
}

