/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.ArrayList;

public class PrintListBuiltin
extends BaseBuiltin {
    public String getName() {
        return "print_list";
    }

    public int getArgLength() {
        return 1;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 1) {
            return false;
        }
        this.printList(args, length, context);
        return true;
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        this.printList(args, length, context);
    }

    void printList(Node[] args, int length, RuleContext context) {
        this.printListR(args[0], context);
        System.out.println();
    }

    void printListR(Node n, RuleContext context) {
        Node first = Node.create((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
        Node rest = Node.create((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
        Node nil = Node.create((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        ArrayList<Node> al = new ArrayList<Node>();
        Node tmpN = n;
        while (!tmpN.equals((Object)nil)) {
            ClosableIterator ci = context.find(tmpN, first, null);
            Node e = ((Triple)ci.next()).getObject();
            al.add(e);
            ci = context.find(tmpN, rest, null);
            tmpN = ((Triple)ci.next()).getObject();
        }
        System.out.print("(");
        Node[] nn = al.toArray(new Node[0]);
        for (int i = 0; i < nn.length; ++i) {
            ClosableIterator ci;
            if (nn[i].isBlank() && (ci = context.find(nn[i], first, null)).hasNext() && (ci = context.find(nn[i], rest, null)).hasNext()) {
                this.printListR(nn[i], context);
                continue;
            }
            System.out.print(nn[i].toString() + " ");
        }
        System.out.print(") ");
    }
}

