/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.do_johodai.j314.sw.jc;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import jp.ac.do_johodai.j314.sw.jc.JTextAreaOutputStream;
import jp.ac.do_johodai.j314.sw.jc.JTextFieldInputStream;
import jp.ac.do_johodai.j314.sw.jc.JenaCheck;
import jp.ac.do_johodai.j314.sw.je.A3ChangeBuiltin;
import jp.ac.do_johodai.j314.sw.je.A3NewBuiltin;
import jp.ac.do_johodai.j314.sw.je.A3PrintBuiltin;
import jp.ac.do_johodai.j314.sw.je.A3ReadBuiltin;
import jp.ac.do_johodai.j314.sw.je.A3SetVisibleBuiltin;
import jp.ac.do_johodai.j314.sw.je.A3YesNoBuiltin;
import jp.ac.do_johodai.j314.sw.je.BindBuiltin;
import jp.ac.do_johodai.j314.sw.je.ConsBuiltin;
import jp.ac.do_johodai.j314.sw.je.DateTime2LongBuiltin;
import jp.ac.do_johodai.j314.sw.je.EndsWithBuiltin;
import jp.ac.do_johodai.j314.sw.je.Int2StringBuiltin;
import jp.ac.do_johodai.j314.sw.je.JEListener;
import jp.ac.do_johodai.j314.sw.je.JEMessage;
import jp.ac.do_johodai.j314.sw.je.JenaEngine;
import jp.ac.do_johodai.j314.sw.je.KeitaisoBuiltin;
import jp.ac.do_johodai.j314.sw.je.KeitaisoInitBuiltin;
import jp.ac.do_johodai.j314.sw.je.KeitaisokaisekiBuiltin;
import jp.ac.do_johodai.j314.sw.je.List2StringBuiltin;
import jp.ac.do_johodai.j314.sw.je.ListAppendBuiltin;
import jp.ac.do_johodai.j314.sw.je.ListBuiltin;
import jp.ac.do_johodai.j314.sw.je.Long2DateTimeBuiltin;
import jp.ac.do_johodai.j314.sw.je.NotEndsWithBuiltin;
import jp.ac.do_johodai.j314.sw.je.NotStartsWithBuiltin;
import jp.ac.do_johodai.j314.sw.je.PrintListBuiltin;
import jp.ac.do_johodai.j314.sw.je.RandIntBuiltin;
import jp.ac.do_johodai.j314.sw.je.ReadBuiltin;
import jp.ac.do_johodai.j314.sw.je.SMailBuiltin;
import jp.ac.do_johodai.j314.sw.je.SendN3Builtin;
import jp.ac.do_johodai.j314.sw.je.SendN3RESTBuiltin;
import jp.ac.do_johodai.j314.sw.je.StartsWithBuiltin;
import jp.ac.do_johodai.j314.sw.je.StateGetBuiltin;
import jp.ac.do_johodai.j314.sw.je.StatePrintBuiltin;
import jp.ac.do_johodai.j314.sw.je.StateSetBuiltin;
import jp.ac.do_johodai.j314.sw.je.String2IntBuiltin;
import jp.ac.do_johodai.j314.sw.je.StringConcatBuiltin;
import jp.ac.do_johodai.j314.sw.je.StringFormatBuiltin;
import jp.ac.do_johodai.j314.sw.ws.ServerWrapper;

public class JenaFrame
extends JFrame
implements ActionListener,
JEListener {
    private static final long serialVersionUID = 1L;
    JenaCheck jc;
    ServerWrapper serverWrapper;
    JenaEngine engine;
    long timerInterval = 1000L;
    int port = 8080;
    JMenuBar menuBar;
    JMenu fileMenu;
    JMenuItem loadRDFMI;
    JMenuItem loadRulesMI;
    JMenuItem saveRDFasN3MI;
    JMenuItem saveRulesMI;
    JMenuItem timerIntervalMI;
    JMenuItem setWSPortMI;
    JMenuItem startWebServiceMI;
    JMenuItem stopWebServiceMI;
    JMenuItem quitMI;
    JButton clearRDFButton;
    JButton resetRDFButton;
    JCheckBox traceCB;
    JCheckBox timerCB;
    JCheckBox owlDLCB;
    JComboBox reasonerModeCB;
    JTabbedPane tabP;
    JTextArea rulesTA;
    JButton setRulesButton;
    JButton resetRulesButton;
    JTextArea notation3TA;
    JButton printNotation3Button;
    JButton addNotation3Button;
    JButton delNotation3Button;
    JButton resetNotation3Button;
    JTextArea sparqlTA;
    JButton execSparqlButton;
    JButton resetSparqlButton;
    JButton insSparqlButton;
    JButton delSparqlButton;
    JTextField inputTF;
    JTextField inputTF2;
    JTextArea outputTA;
    JButton clearOutputButton;

    public JenaFrame(JenaCheck jc) {
        super("JenaCheck");
        this.jc = jc;
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.fileMenu = new JMenu("\u30d5\u30a1\u30a4\u30eb");
        this.menuBar.add(this.fileMenu);
        this.loadRDFMI = new JMenuItem("RDF\u3092\u30ed\u30fc\u30c9");
        this.loadRulesMI = new JMenuItem("\u30eb\u30fc\u30eb\u3092\u30ed\u30fc\u30c9");
        this.saveRDFasN3MI = new JMenuItem("RDF\u3092N3\u3067\u4fdd\u5b58");
        this.saveRulesMI = new JMenuItem("\u30eb\u30fc\u30eb\u3092\u4fdd\u5b58");
        this.timerIntervalMI = new JMenuItem("\u30bf\u30a4\u30de\u30fc\u306e\u30a4\u30f3\u30bf\u30fc\u30d0\u30eb\u3092\u30bb\u30c3\u30c8");
        this.setWSPortMI = new JMenuItem("WebService\u306e\u30dd\u30fc\u30c8\u3092\u6307\u5b9a\u3059\u308b");
        this.startWebServiceMI = new JMenuItem("WebService\u3092\u8d77\u52d5\u3059\u308b");
        this.stopWebServiceMI = new JMenuItem("WebService\u3092\u505c\u6b62\u3059\u308b");
        this.quitMI = new JMenuItem("\u7d42\u4e86\u3059\u308b");
        this.loadRDFMI.addActionListener(this);
        this.loadRulesMI.addActionListener(this);
        this.saveRDFasN3MI.addActionListener(this);
        this.saveRulesMI.addActionListener(this);
        this.timerIntervalMI.addActionListener(this);
        this.setWSPortMI.addActionListener(this);
        this.startWebServiceMI.addActionListener(this);
        this.stopWebServiceMI.addActionListener(this);
        this.quitMI.addActionListener(this);
        this.fileMenu.add(this.loadRDFMI);
        this.fileMenu.add(this.loadRulesMI);
        this.fileMenu.add(this.saveRDFasN3MI);
        this.fileMenu.add(this.saveRulesMI);
        this.fileMenu.add(this.timerIntervalMI);
        this.fileMenu.add(this.setWSPortMI);
        this.fileMenu.add(this.startWebServiceMI);
        this.fileMenu.add(this.stopWebServiceMI);
        this.fileMenu.add(this.quitMI);
        Font f = new Font("MonoSpaced", 0, 12);
        this.clearRDFButton = new JButton("RDF\u30e2\u30c7\u30eb\u3092\u7a7a\u306b\u3059\u308b");
        this.resetRDFButton = new JButton("RDF\u30e2\u30c7\u30eb\u3092\u63a8\u8ad6\u524d\u306b\u3082\u3069\u3059");
        this.traceCB = new JCheckBox("\u30c8\u30ec\u30fc\u30b9");
        this.timerCB = new JCheckBox("\u30bf\u30a4\u30de\u30fc");
        this.owlDLCB = new JCheckBox("OWL-DL");
        String[] s = new String[]{"hybrid", "forward", "forwardRETE", "backward"};
        this.reasonerModeCB = new JComboBox<String>(s);
        this.tabP = new JTabbedPane();
        this.rulesTA = new JTextArea(10, 60);
        this.rulesTA.setFont(f);
        this.setRulesButton = new JButton("\u30eb\u30fc\u30eb\u3092\u30bb\u30c3\u30c8");
        this.resetRulesButton = new JButton("\u30ea\u30bb\u30c3\u30c8");
        this.notation3TA = new JTextArea(15, 60);
        this.notation3TA.setFont(f);
        this.printNotation3Button = new JButton("\u8868\u793a");
        this.addNotation3Button = new JButton("\u8ffd\u52a0");
        this.delNotation3Button = new JButton("\u524a\u9664");
        this.resetNotation3Button = new JButton("\u30af\u30ea\u30a2");
        this.sparqlTA = new JTextArea(15, 60);
        this.sparqlTA.setFont(f);
        this.execSparqlButton = new JButton("\u691c\u7d22");
        this.insSparqlButton = new JButton("\u8ffd\u52a0");
        this.delSparqlButton = new JButton("\u524a\u9664");
        this.resetSparqlButton = new JButton("\u30af\u30ea\u30a2");
        this.inputTF = new JTextField();
        this.inputTF.setFont(f);
        this.inputTF.setMaximumSize(new Dimension(10000, 30));
        this.inputTF2 = new JTextField();
        this.inputTF2.setFont(f);
        this.inputTF2.setMaximumSize(new Dimension(10000, 30));
        this.outputTA = new JTextArea(15, 60);
        this.outputTA.setFont(f);
        this.clearOutputButton = new JButton("\u6a19\u6e96\u51fa\u529b\u3092\u30af\u30ea\u30a2");
        JTextAreaOutputStream jtaos = new JTextAreaOutputStream(this.outputTA, System.out);
        PrintStream ps = new PrintStream(jtaos, true);
        System.setOut(ps);
        System.setErr(ps);
        JTextFieldInputStream jtfis = new JTextFieldInputStream(this.inputTF);
        System.setIn(jtfis);
        this.engine = new JenaEngine();
        this.engine.registerBuiltin((Builtin)new BindBuiltin());
        this.engine.registerBuiltin((Builtin)new ReadBuiltin());
        this.engine.registerBuiltin((Builtin)new RandIntBuiltin());
        this.engine.registerBuiltin((Builtin)new String2IntBuiltin());
        this.engine.registerBuiltin((Builtin)new ListBuiltin());
        this.engine.registerBuiltin((Builtin)new ConsBuiltin());
        this.engine.registerBuiltin((Builtin)new List2StringBuiltin());
        this.engine.registerBuiltin((Builtin)new ListAppendBuiltin());
        this.engine.registerBuiltin((Builtin)new PrintListBuiltin());
        this.engine.registerBuiltin((Builtin)new StartsWithBuiltin());
        this.engine.registerBuiltin((Builtin)new EndsWithBuiltin());
        this.engine.registerBuiltin((Builtin)new NotStartsWithBuiltin());
        this.engine.registerBuiltin((Builtin)new NotEndsWithBuiltin());
        this.engine.registerBuiltin((Builtin)new StringConcatBuiltin());
        this.engine.registerBuiltin((Builtin)new StringFormatBuiltin());
        this.engine.registerBuiltin((Builtin)new Int2StringBuiltin());
        this.engine.registerBuiltin((Builtin)new StateSetBuiltin());
        this.engine.registerBuiltin((Builtin)new StateGetBuiltin());
        this.engine.registerBuiltin((Builtin)new StatePrintBuiltin());
        this.engine.registerBuiltin((Builtin)new SMailBuiltin());
        this.engine.registerBuiltin((Builtin)new Long2DateTimeBuiltin());
        this.engine.registerBuiltin((Builtin)new DateTime2LongBuiltin());
        this.engine.registerBuiltin((Builtin)new SendN3Builtin());
        this.engine.registerBuiltin((Builtin)new SendN3RESTBuiltin());
        A3NewBuiltin a3new = new A3NewBuiltin();
        a3new.setJenaEngine(this.engine);
        this.engine.registerBuiltin((Builtin)a3new);
        this.engine.registerBuiltin((Builtin)new A3SetVisibleBuiltin());
        this.engine.registerBuiltin((Builtin)new A3ChangeBuiltin());
        this.engine.registerBuiltin((Builtin)new A3PrintBuiltin());
        this.engine.registerBuiltin((Builtin)new A3ReadBuiltin());
        this.engine.registerBuiltin((Builtin)new A3YesNoBuiltin());
        this.engine.registerBuiltin((Builtin)new KeitaisoInitBuiltin());
        this.engine.registerBuiltin((Builtin)new KeitaisoBuiltin());
        this.engine.registerBuiltin((Builtin)new KeitaisokaisekiBuiltin());
        this.serverWrapper = new ServerWrapper(this.engine);
        this.serverWrapper.setPort(this.port);
        Box baseBox = Box.createVerticalBox();
        Box confBox = Box.createHorizontalBox();
        Box rulesBox = Box.createVerticalBox();
        Box rulesBBox = Box.createHorizontalBox();
        Box n3Box = Box.createVerticalBox();
        Box n3BBox = Box.createHorizontalBox();
        Box sparqlBox = Box.createVerticalBox();
        Box sparqlBBox = Box.createHorizontalBox();
        Box inputBox = Box.createHorizontalBox();
        Box inputBox2 = Box.createHorizontalBox();
        Box outputBox = Box.createVerticalBox();
        LineBorder b = new LineBorder(Color.black);
        confBox.setBorder(new TitledBorder(b, "\u8a2d\u5b9a\u3068\u304b"));
        rulesBox.setBorder(new TitledBorder(b, "\u30eb\u30fc\u30eb"));
        n3Box.setBorder(new TitledBorder(b, "Notation3"));
        sparqlBox.setBorder(new TitledBorder(b, "SPARQL"));
        inputBox.setBorder(new TitledBorder(b, "\u6a19\u6e96\u5165\u529b"));
        inputBox2.setBorder(new TitledBorder(b, "\u4e09\u7d44\u5165\u529b"));
        outputBox.setBorder(new TitledBorder(b, "\u6a19\u6e96\u51fa\u529b"));
        baseBox.add(confBox);
        baseBox.add(this.tabP);
        this.tabP.add("\u30eb\u30fc\u30eb", rulesBox);
        this.tabP.add("Notation3", n3Box);
        this.tabP.add("SPARQL", sparqlBox);
        baseBox.add(inputBox);
        baseBox.add(inputBox2);
        baseBox.add(outputBox);
        this.getContentPane().add(baseBox);
        confBox.add(this.clearRDFButton);
        confBox.add(this.resetRDFButton);
        confBox.add(this.traceCB);
        confBox.add(this.timerCB);
        confBox.add(this.owlDLCB);
        confBox.add(this.reasonerModeCB);
        confBox.add(Box.createHorizontalGlue());
        rulesBox.add(new JScrollPane(this.rulesTA));
        rulesBBox.add(this.setRulesButton);
        rulesBBox.add(this.resetRulesButton);
        n3Box.add(new JScrollPane(this.notation3TA));
        n3BBox.add(this.printNotation3Button);
        n3BBox.add(this.addNotation3Button);
        n3BBox.add(this.delNotation3Button);
        n3BBox.add(this.resetNotation3Button);
        sparqlBox.add(new JScrollPane(this.sparqlTA));
        sparqlBBox.add(this.execSparqlButton);
        sparqlBBox.add(this.insSparqlButton);
        sparqlBBox.add(this.delSparqlButton);
        sparqlBBox.add(this.resetSparqlButton);
        inputBox.add(this.inputTF);
        inputBox2.add(this.inputTF2);
        outputBox.add(new JScrollPane(this.outputTA));
        outputBox.add(this.clearOutputButton);
        rulesBox.add(rulesBBox);
        n3Box.add(n3BBox);
        sparqlBox.add(sparqlBBox);
        this.clearRDFButton.addActionListener(this);
        this.resetRDFButton.addActionListener(this);
        this.traceCB.addActionListener(this);
        this.timerCB.addActionListener(this);
        this.owlDLCB.addActionListener(this);
        this.reasonerModeCB.addActionListener(this);
        this.setRulesButton.addActionListener(this);
        this.resetRulesButton.addActionListener(this);
        this.printNotation3Button.addActionListener(this);
        this.addNotation3Button.addActionListener(this);
        this.delNotation3Button.addActionListener(this);
        this.resetNotation3Button.addActionListener(this);
        this.execSparqlButton.addActionListener(this);
        this.insSparqlButton.addActionListener(this);
        this.delSparqlButton.addActionListener(this);
        this.resetSparqlButton.addActionListener(this);
        this.inputTF.addActionListener(this);
        this.inputTF2.addActionListener(this);
        this.clearOutputButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.loadRDFMI) {
            String s = JOptionPane.showInputDialog(this, (Object)"input rdf URL:");
            if (s != null) {
                JEMessage m = new JEMessage(JEMessage.Type.LOAD_RDF, this, s);
                this.engine.recieveRequest(m);
            }
        } else if (ae.getSource() == this.loadRulesMI) {
            try {
                String s = JOptionPane.showInputDialog(this, (Object)"input rules URL:");
                if (s != null) {
                    String line;
                    URL url = new URL(s);
                    InputStreamReader isr = new InputStreamReader(url.openStream(), "utf-8");
                    BufferedReader br = new BufferedReader(isr);
                    this.rulesTA.setText("");
                    while ((line = br.readLine()) != null) {
                        this.rulesTA.append(line + "\n");
                    }
                }
                JEMessage m = new JEMessage(JEMessage.Type.SET_RULES, this, this.rulesTA.getText());
                this.engine.recieveRequest(m);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (ae.getSource() == this.saveRDFasN3MI) {
            String s = JOptionPane.showInputDialog(this, (Object)"save rdf URL:");
            if (s != null) {
                String query = "CONSTRUCT{?x ?y ?z}WHERE{?x ?y ?z}";
                JEMessage m = new JEMessage(JEMessage.Type.SPARQL, this, query);
                try {
                    m.setUserData(new URI(s));
                    this.engine.recieveRequest(m);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        } else if (ae.getSource() == this.saveRulesMI) {
            try {
                String s = JOptionPane.showInputDialog(this, (Object)"save rules URL:");
                if (s != null) {
                    URI uri = new URI(s);
                    PrintStream ps = new PrintStream(new File(uri), "UTF-8");
                    ps.println(this.rulesTA.getText());
                    ps.close();
                    System.out.println("(\u30c6\u30ad\u30b9\u30c8\u30a8\u30ea\u30a2\u306e)\u30eb\u30fc\u30eb\u3092" + s + "\u306b\u4fdd\u5b58\u3057\u307e\u3057\u305f\u3002");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (ae.getSource() == this.timerIntervalMI) {
            String s = JOptionPane.showInputDialog(this, (Object)"input timer interval(ms):");
            if (s != null) {
                this.timerInterval = Long.parseLong(s);
                System.out.println("\u30bf\u30a4\u30de\u30fc\u306e\u30a4\u30f3\u30bf\u30fc\u30d0\u30eb\u3092" + this.timerInterval + "(ms)\u306b\u5909\u66f4\u3057\u307e\u3057\u305f\u3002");
            }
        } else if (ae.getSource() == this.setWSPortMI) {
            String s = JOptionPane.showInputDialog(this, (Object)"input WebService port number:");
            if (s != null) {
                this.port = Integer.parseInt(s);
                this.serverWrapper.setPort(this.port);
                System.out.println("WebService\u306e\u30dd\u30fc\u30c8\u3092" + this.port + "\u306b\u5909\u66f4\u3057\u307e\u3057\u305f\u3002");
            }
        } else if (ae.getSource() == this.startWebServiceMI) {
            this.serverWrapper.start();
            System.out.println("WebService\u3092\u8d77\u52d5\u3055\u305b\u307e\u3057\u305f\u3002");
        } else if (ae.getSource() == this.stopWebServiceMI) {
            this.serverWrapper.stop();
            System.out.println("WebService\u3092\u505c\u6b62\u3055\u305b\u307e\u3057\u305f\u3002");
        } else if (ae.getSource() == this.quitMI) {
            this.jc.disposeThis();
        } else if (ae.getSource() == this.clearRDFButton) {
            this.engine.clearRDF();
            System.out.println("RDF\u30e2\u30c7\u30eb\u3092\u7a7a\u306b\u3057\u307e\u3057\u305f\uff0e");
        } else if (ae.getSource() == this.resetRDFButton) {
            this.engine.resetRDF();
            System.out.println("RDF\u30e2\u30c7\u30eb\u3092\u63a8\u8ad6\u524d\u306e\u72b6\u614b\u306b\u3082\u3069\u3057\u307e\u3057\u305f\uff0e");
        } else if (ae.getSource() == this.traceCB) {
            this.engine.setTrace(this.traceCB.isSelected());
            if (this.traceCB.isSelected()) {
                System.out.println("\u30c8\u30ec\u30fc\u30b9\u8868\u793a\u3092ON\u306b\u3057\u307e\u3059\uff0e");
            } else {
                System.out.println("\u30c8\u30ec\u30fc\u30b9\u8868\u793a\u3092OFF\u306b\u3057\u307e\u3059\uff0e");
            }
        } else if (ae.getSource() == this.timerCB) {
            JEMessage m = null;
            m = this.timerCB.isSelected() ? new JEMessage(JEMessage.Type.SET_TIMER, this, true, this.timerInterval) : new JEMessage(JEMessage.Type.SET_TIMER, this, false, this.timerInterval);
            this.engine.recieveRequest(m);
        } else if (ae.getSource() == this.owlDLCB) {
            this.engine.setEnableOWLDL(this.owlDLCB.isSelected());
            if (this.owlDLCB.isSelected()) {
                System.out.println("OWL-DL Reasoner\u3092\u6709\u52b9\u306b\u3057\u307e\u3059\u3002");
            } else {
                System.out.println("OWL-DL Reasoner\u3092\u7121\u52b9\u306b\u3057\u307e\u3059\u3002");
            }
        } else if (ae.getSource() == this.reasonerModeCB) {
            String mode = (String)this.reasonerModeCB.getSelectedItem();
            this.engine.setReasonerMode(mode);
            System.out.println("Reasoner\u306e\u63a8\u8ad6\u30e2\u30fc\u30c9\u3092[" + mode + "]\u306b\u3057\u307e\u3059\u3002");
        } else if (ae.getSource() == this.setRulesButton) {
            JEMessage m = new JEMessage(JEMessage.Type.SET_RULES, this, this.rulesTA.getText());
            this.engine.recieveRequest(m);
        } else if (ae.getSource() == this.resetRulesButton) {
            this.rulesTA.setText("");
            JEMessage m = new JEMessage(JEMessage.Type.SET_RULES, this, this.rulesTA.getText());
            this.engine.recieveRequest(m);
        } else if (ae.getSource() == this.printNotation3Button) {
            JEMessage m = new JEMessage(JEMessage.Type.SPARQL, this, "CONSTRUCT {?x ?y ?z} WHERE {?x ?y ?z}");
            m.setUserData(this.sparqlTA.getText());
            this.engine.recieveRequest(m);
        } else if (ae.getSource() == this.addNotation3Button) {
            JEMessage m = new JEMessage(JEMessage.Type.INSERT_N3, this, this.notation3TA.getText());
            this.engine.recieveRequest(m);
        } else if (ae.getSource() == this.delNotation3Button) {
            JEMessage m = new JEMessage(JEMessage.Type.DELETE_N3, this, this.notation3TA.getText());
            this.engine.recieveRequest(m);
        } else if (ae.getSource() == this.resetNotation3Button) {
            this.notation3TA.setText("");
        } else if (ae.getSource() == this.execSparqlButton) {
            JEMessage m = new JEMessage(JEMessage.Type.SPARQL, this, this.sparqlTA.getText());
            m.setUserData(this.sparqlTA.getText());
            this.engine.recieveRequest(m);
        } else if (ae.getSource() == this.insSparqlButton) {
            JEMessage m = new JEMessage(JEMessage.Type.INS_SPARQL, this, this.sparqlTA.getText());
            this.engine.recieveRequest(m);
        } else if (ae.getSource() == this.delSparqlButton) {
            JEMessage m = new JEMessage(JEMessage.Type.DEL_SPARQL, this, this.sparqlTA.getText());
            this.engine.recieveRequest(m);
        } else if (ae.getSource() == this.resetSparqlButton) {
            this.sparqlTA.setText("");
        } else if (ae.getSource() == this.inputTF) {
            String s = this.inputTF.getText();
            System.out.println(s);
        } else if (ae.getSource() == this.inputTF2) {
            String s = this.inputTF2.getText();
            System.out.println(s);
            this.inputTF2.setText("");
            JEMessage m = new JEMessage(JEMessage.Type.SET_INPUT, this, s);
            this.engine.recieveRequest(m);
        } else if (ae.getSource() == this.clearOutputButton) {
            this.outputTA.setText("");
        } else {
            System.out.println(ae.toString());
        }
    }

    public void performResultMessage(JEMessage m) {
        if (m.getType() == JEMessage.Type.INSERT_N3) {
            if (((Boolean)m.getResult()).booleanValue()) {
                System.out.println("RDF\u30e2\u30c7\u30eb\u306b\u8ffd\u52a0\u3057\u307e\u3057\u305f\uff0e");
            } else {
                System.out.println("RDF\u30e2\u30c7\u30eb\u3078\u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff0e");
            }
        } else if (m.getType() == JEMessage.Type.DELETE_N3) {
            if (((Boolean)m.getResult()).booleanValue()) {
                System.out.println("RDF\u30e2\u30c7\u30eb\u304b\u3089\u524a\u9664\u3057\u307e\u3057\u305f\uff0e");
            } else {
                System.out.println("RDF\u30e2\u30c7\u30eb\u304b\u3089\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff0e");
            }
        } else if (m.getType() == JEMessage.Type.SET_TIMER) {
            if (((Boolean)m.getResult()).booleanValue()) {
                System.out.println("\u30bf\u30a4\u30de\u30fc\u3092\u30bb\u30c3\u30c8\u3057\u307e\u3057\u305f\uff0e");
            } else {
                System.out.println("\u30bf\u30a4\u30de\u30fc\u6b62\u3081\u307e\u3057\u305f\uff0e");
            }
        } else if (m.getType() == JEMessage.Type.SET_RULES) {
            if (((Boolean)m.getResult()).booleanValue()) {
                System.out.println("\u30eb\u30fc\u30eb\u3092\u7a7a\u306b\u3057\u3066\u304b\u3089\u30bb\u30c3\u30c8\u3057\u307e\u3057\u305f\u3002");
            } else {
                System.out.println("\u30eb\u30fc\u30eb\u306e\u30bb\u30c3\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
        } else if (m.getType() == JEMessage.Type.LOAD_RDF) {
            if (((Boolean)m.getResult()).booleanValue()) {
                System.out.println("RDF\u30e2\u30c7\u30eb\u3092\u7a7a\u306b\u3057\u3066\u304b\u3089\u518d\u8aad\u307f\u8fbc\u307f\u3057\u307e\u3057\u305f\uff0e");
            } else {
                System.out.println("RDF\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
        } else if (m.getType() == JEMessage.Type.SPARQL) {
            Object result = m.getResult();
            if (result instanceof ResultSet) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                if (m.getUserData() instanceof String) {
                    Query q = QueryFactory.create((String)((String)m.getUserData()));
                    ResultSetFormatter.out((OutputStream)baos, (ResultSet)((ResultSet)result), (Query)q);
                } else {
                    ResultSetFormatter.out((OutputStream)baos, (ResultSet)((ResultSet)result));
                }
                try {
                    System.out.println(baos.toString("UTF-8"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (result instanceof Model) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ((Model)result).write((OutputStream)baos, "N3");
                    if (m.getUserData() instanceof URI) {
                        URI uri = (URI)m.getUserData();
                        PrintStream ps = new PrintStream(new File(uri), "UTF-8");
                        ps.print(baos.toString("UTF-8"));
                        ps.close();
                        System.out.println("RDF\u3092" + uri.toString() + "\u306b\u4fdd\u5b58\u3057\u307e\u3057\u305f\u3002");
                    } else if (m.getUserData() instanceof String) {
                        System.out.println(baos.toString("UTF-8"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (result instanceof Boolean) {
                System.out.println(result);
            } else {
                System.out.println("???");
            }
        } else if (m.getType() == JEMessage.Type.INS_SPARQL) {
            System.out.println("\u4ee5\u4e0b\u306e\u5185\u5bb9\u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002");
            String res = (String)m.getResult();
            System.out.println(res);
        } else if (m.getType() == JEMessage.Type.DEL_SPARQL) {
            System.out.println("\u4ee5\u4e0b\u306e\u5185\u5bb9\u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002");
            String res = (String)m.getResult();
            System.out.println(res);
        } else if (m.getType() != JEMessage.Type.SET_INPUT) {
            System.out.println("***???***");
        }
    }
}

