/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.do_johodai.j314.sw.jc;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JTextField;

public class JTextFieldInputStream
extends InputStream
implements ActionListener {
    JTextField textField;
    MyBuffer myBuffer;

    public JTextFieldInputStream(JTextField tf) {
        this.textField = tf;
        tf.addActionListener(this);
        this.myBuffer = new MyBuffer(tf);
    }

    public int read() throws IOException {
        try {
            return this.myBuffer.read();
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.textField) {
            this.myBuffer.addLine(this.textField.getText());
            this.textField.setText("");
        }
    }

    class MyBuffer {
        byte[] currentString = null;
        int counter = -1;
        boolean someOneWaiting = false;
        JTextField textField;

        MyBuffer(JTextField tf) {
            this.textField = tf;
            this.textField.setBackground(Color.white);
        }

        synchronized void addLine(String s) {
            if (!this.someOneWaiting) {
                return;
            }
            if (this.currentString != null) {
                return;
            }
            this.currentString = (s + "\n").getBytes();
            this.counter = 0;
            this.notifyAll();
        }

        synchronized int read() throws Exception {
            while (this.currentString == null) {
                this.someOneWaiting = true;
                this.textField.setBackground(Color.red);
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.counter >= this.currentString.length) {
                this.currentString = null;
                this.someOneWaiting = false;
                this.textField.setBackground(Color.white);
                this.counter = -1;
                return -1;
            }
            byte retValue = this.currentString[this.counter];
            ++this.counter;
            return retValue;
        }
    }
}

