/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah.oldjavah;

import com.sun.tools.javah.oldjavah.Gen;
import com.sun.tools.javah.oldjavah.Mangle;
import com.sun.tools.javah.oldjavah.Util;
import java.io.OutputStream;
import java.io.PrintWriter;
import sun.tools.java.ArrayType;
import sun.tools.java.MemberDefinition;
import sun.tools.java.MethodType;
import sun.tools.java.Type;

public class JNI
extends Gen {
    public String getIncludes() {
        return "#include <jni.h>";
    }

    public void write(OutputStream outputStream, String string) throws ClassNotFoundException {
        String string2 = Mangle.mangle(string, 1);
        PrintWriter printWriter = this.wrapWriter(outputStream);
        printWriter.println(this.guardBegin(string2));
        printWriter.println(this.cppGuardBegin());
        MemberDefinition[] memberDefinitionArray = this.env.getAllFields(string);
        for (int i = 0; i < memberDefinitionArray.length; ++i) {
            if (!memberDefinitionArray[i].isStatic()) continue;
            String string3 = null;
            string3 = this.defineForStatic(string, memberDefinitionArray[i]);
            if (string3 == null) continue;
            printWriter.println(string3);
        }
        MemberDefinition[] memberDefinitionArray2 = this.env.getNativeMethods(string);
        for (int i = 0; i < memberDefinitionArray2.length; ++i) {
            MemberDefinition memberDefinition = memberDefinitionArray2[i];
            MethodType methodType = (MethodType)memberDefinition.getType();
            String string4 = memberDefinition.getName().toString();
            boolean bl = false;
            for (int j = 0; j < memberDefinitionArray2.length; ++j) {
                if (memberDefinitionArray2[j] == memberDefinition || !string4.equals(memberDefinitionArray2[j].getName().toString())) continue;
                bl = true;
            }
            printWriter.println("/*");
            printWriter.println(" * Class:     " + string2);
            printWriter.println(" * Method:    " + Mangle.mangle(string4, 2));
            printWriter.println(" * Signature: " + methodType.getTypeSignature());
            printWriter.println(" */");
            printWriter.println("JNIEXPORT " + this.jniType(methodType.getReturnType()) + " JNICALL " + Mangle.mangleMethod(memberDefinition, string, bl ? 8 : 7));
            printWriter.print("  (JNIEnv *, ");
            Type[] typeArray = methodType.getArgumentTypes();
            if (memberDefinition.isStatic()) {
                printWriter.print("jclass");
            } else {
                printWriter.print("jobject");
            }
            if (typeArray.length > 0) {
                printWriter.print(", ");
            }
            for (int j = 0; j < typeArray.length; ++j) {
                printWriter.print(this.jniType(typeArray[j]));
                if (j == typeArray.length - 1) continue;
                printWriter.print(", ");
            }
            printWriter.println(");\n");
        }
        printWriter.println(this.cppGuardEnd());
        printWriter.println(this.guardEnd(string2));
    }

    protected final String jniType(Type type) {
        if (type instanceof ArrayType) {
            Type type2 = type.getElementType();
            switch (type2.getTypeCode()) {
                case 0: {
                    return "jbooleanArray";
                }
                case 1: {
                    return "jbyteArray";
                }
                case 2: {
                    return "jcharArray";
                }
                case 3: {
                    return "jshortArray";
                }
                case 4: {
                    return "jintArray";
                }
                case 5: {
                    return "jlongArray";
                }
                case 6: {
                    return "jfloatArray";
                }
                case 7: {
                    return "jdoubleArray";
                }
                case 9: 
                case 10: {
                    return "jobjectArray";
                }
            }
        } else {
            switch (type.getTypeCode()) {
                case 11: {
                    return "void";
                }
                case 0: {
                    return "jboolean";
                }
                case 1: {
                    return "jbyte";
                }
                case 2: {
                    return "jchar";
                }
                case 3: {
                    return "jshort";
                }
                case 4: {
                    return "jint";
                }
                case 5: {
                    return "jlong";
                }
                case 6: {
                    return "jfloat";
                }
                case 7: {
                    return "jdouble";
                }
                case 10: {
                    if (type == Type.tString) {
                        return "jstring";
                    }
                    if (type == Type.tClassDesc) {
                        return "jclass";
                    }
                    if (this.env.isThrowable(type)) {
                        return "jthrowable";
                    }
                    return "jobject";
                }
            }
        }
        Util.bug("jni.unknown.type");
        return null;
    }
}

