/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.views.swf;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import javax.management.RuntimeErrorException;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfFile;
import jp.sourceforge.swf2bmp2avi.plugin.Activator;
import jp.sourceforge.swf2bmp2avi.plugin.SwfCaptureParams;
import jp.sourceforge.swf2bmp2avi.plugin.SwfManager;
import jp.sourceforge.swf2bmp2avi.views.swf.SwfOleWrapper;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class SwfCapturePanel
extends Composite
implements OleListener {
    public static final String PROPERTY_CHANGE_START_SAVE = "START_SAVE";
    public static final String PROPERTY_CHANGE_FLAME_SAVE = "FRAME_SAVE";
    public static final String PROPERTY_CHANGE_END_SAVE = "END_SAVE";
    private SwfOleWrapper swfOle_ = null;
    private String loaderSwf_;
    private String targetSwfFileName_;
    private int beforeFrame_ = 0;
    private boolean isSaving_ = false;
    private boolean isAutoStop = true;
    private int autoCnt_;
    private SwfCaptureParams swfCaptureParams_;
    private PropertyChangeSupport propertyChangeListeners_ = new PropertyChangeSupport((Object)this);
    private boolean isAfterEndCall_ = false;
    private boolean isLostFrame_ = false;

    public SwfCapturePanel(Composite parent, SwfCaptureParams pSwfCaptureParams) throws IOException {
        super(parent, 0);
        this.swfCaptureParams_ = pSwfCaptureParams;
        this.initTempSwf(pSwfCaptureParams);
        this.createPartControl(this);
        RGB bgColorRGB = StringConverter.asRGB((String)Activator.getDefault().getPreferenceStore().getString("swf2avi.swf.bg_color"));
        String bgColorStr = String.format("#%2X%2X%2x", bgColorRGB.red, bgColorRGB.green, bgColorRGB.blue);
        this.log("\u80cc\u666f\u8272\u6307\u5b9a:" + bgColorStr);
        this.swfOle_.setBgColor(bgColorStr);
    }

    public void dispose() {
        if (this.swfOle_ != null) {
            this.swfOle_.dispose();
        }
        super.dispose();
    }

    private void log(String pMsg) {
        Activator.msg("[" + ((Object)((Object)this)).getClass().getSimpleName() + "]" + pMsg);
    }

    private void initTempSwf(SwfCaptureParams pSwfCaptureParams) throws IOException {
        pSwfCaptureParams.getCaptureOutputPath(true);
        File tempDir = Activator.getDefault().getTmpDir();
        String loaderPath = pSwfCaptureParams.getSwfLoader();
        this.loaderSwf_ = SwfManager.getInstance().createTempNoSound(loaderPath, pSwfCaptureParams.getSwfFps(), tempDir);
        this.log("\u2606\u2606\u3000SWF\u30ed\u30fc\u30c0\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u751f\u6210\u306b\u6210\u529f\uff1aFPS=" + pSwfCaptureParams.getSwfFps());
        this.log("\u3000\u3000\u3000(\u5143SWF)\t\t\uff1a" + loaderPath);
        this.log("\u3000\u3000\u3000(\u4e00\u6642SWF)\t\uff1a" + this.loaderSwf_);
        SwfFile swf = pSwfCaptureParams.getTargetSwf();
        this.targetSwfFileName_ = SwfManager.getInstance().createTempNoSound(swf, pSwfCaptureParams.getSwfFps(), tempDir);
        this.log("\u2606\u2606\u3000\u30bf\u30fc\u30b2\u30c3\u30c8\u306e\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u751f\u6210\u306b\u6210\u529f\uff1aFPS=" + pSwfCaptureParams.getSwfFps());
        this.log("\u3000\u3000\u3000(\u5143SWF)\t\t\uff1a" + swf.getReadFileName());
        this.log("\u3000\u3000\u3000(\u4e00\u6642SWF)\t\uff1a" + this.targetSwfFileName_);
        this.log("\u3000\u3000\u3000(\u5143SWF)\t LEN\t\uff1a" + new File(swf.getReadFileName()).length());
        this.log("\u3000\u3000\u3000(\u4e00\u6642SWF)LEN\t\uff1a" + new File(this.targetSwfFileName_).length());
    }

    private void createPartControl(Composite parent) {
        this.swfOle_ = new SwfOleWrapper(parent, 0x1000000);
        this.swfOle_.setSize(this.swfCaptureParams_.getSwfWidth(), this.swfCaptureParams_.getSwfHeight());
        RowLayout layout = new RowLayout();
        layout.center = true;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginBottom = 0;
        parent.setLayout((Layout)layout);
        this.swfOle_.setLayoutData(new RowData(this.swfCaptureParams_.getSwfWidth(), this.swfCaptureParams_.getSwfHeight()));
        this.initLoaderSwf();
        this.swfOle_.addOleEventListener(this);
    }

    private void initLoaderSwf() {
        File f = new File(this.loaderSwf_);
        if (!f.exists()) {
            this.log("\u30ed\u30fc\u30c0\u30d5\u30a1\u30a4\u30eb\u306a\u3057\uff1a" + f);
            throw new RuntimeErrorException(new Error());
        }
        this.swfOle_.loadMovie(this.loaderSwf_);
        this.swfOle_.play();
    }

    public void startCapture() {
        this.startCapture(true);
    }

    public void startCapture(boolean pIsAutoStop) {
        this.log("\u30ad\u30e3\u30d7\u30c1\u30e3\u958b\u59cb\uff1aSwfCapturePanel#startCapture() --- START");
        this.isAutoStop = pIsAutoStop;
        this.autoCnt_ = this.swfCaptureParams_.getSwfStartFrame();
        this.loadSwbSwf(this.targetSwfFileName_);
        this.log("\u30ad\u30e3\u30d7\u30c1\u30e3\u958b\u59cb\uff1aSwfCapturePanel#startCapture() --- END");
    }

    public void endCapture() {
        this.log("\u30ad\u30e3\u30d7\u30c1\u30e3\u7d42\u4e86\uff1aSwfCapturePanel#endCapture() --- START");
        this.endSave();
        this.log("\u30ad\u30e3\u30d7\u30c1\u30e3\u7d42\u4e86\uff1aSwfCapturePanel#endCapture() --- END");
    }

    public void handleEvent(OleEvent pEvent) {
        if (pEvent.arguments.length > 1) {
            this.receiveSwfFSCommand(pEvent.arguments[0].getString(), pEvent.arguments[1].getString());
        }
    }

    private void receiveSwfFSCommand(final String pCommand, final String pArg) {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                SwfCapturePanel.this.runCommandThred(pCommand, pArg);
            }
        });
    }

    private void runCommandThred(String pCommand, String pArg) {
        if (pCommand.equals("onLoadCompletedSubSwf")) {
            this.log("\u30ed\u30fc\u30c9\u5b8c\u4e86(onLoadCompletedSubSwf\u53d7\u4fe1):" + pArg);
            this.startSave();
            this.firePropertyChange(PROPERTY_CHANGE_START_SAVE, null, null);
        } else if (pCommand.equals("onEnterFrame")) {
            if (this.isAfterEndCall_) {
                this.isLostFrame_ = true;
            }
            this.log("onEnterFrame:" + pArg);
            this.saveImage(pArg);
        } else if (pCommand.equals("onLastFrame")) {
            if (this.isAfterEndCall_) {
                this.isLostFrame_ = true;
            }
            this.log("onLastFrame:" + pArg);
            this.saveImage(pArg);
            if (this.isAutoStop) {
                this.log("\u30d5\u30ec\u30fc\u30e0\u6700\u7d42\u306b\u3064\u304dPropertyChange\u3092\u9001\u4fe1");
                this.firePropertyChange(PROPERTY_CHANGE_END_SAVE, null, null);
                this.isAfterEndCall_ = true;
            }
        } else if (pCommand.equals("onStopFrame")) {
            this.log("onStopFrame:" + pArg);
            this.log("\u30d5\u30ec\u30fc\u30e0\u304c\u505c\u6b62\u3055\u308c\u305f\u305f\u3081PropertyChange\u3092\u9001\u4fe1");
            this.firePropertyChange(PROPERTY_CHANGE_END_SAVE, null, null);
        } else if (pCommand.equals("subSwfTotalFrames")) {
            this.log("subSwfTotalFrames:" + pArg);
        } else if (pCommand.equals("subSwfBaseFPS")) {
            this.log("subSwfBaseFPS:" + pArg);
        } else if (pCommand.equals("subSwfVersion")) {
            this.log("subSwfVersion:" + pArg);
        } else if (pCommand.equals("subSwfBaseHeight")) {
            this.log("subSwfBaseHeight:" + pArg);
        } else if (pCommand.equals("subSwfBaseWidth")) {
            this.log("subSwfBaseWidth:" + pArg);
        } else if (pCommand.equals("As3SwfLoader")) {
            this.log("[\u30c7\u30d0\u30c3\u30b0\u60c5\u5831]" + pArg);
        } else {
            this.log("[\u305d\u306e\u4ed6\u60c5\u5831]" + pCommand + " : " + pArg);
        }
    }

    private boolean saveImage(String pFrame) {
        if (pFrame == null) {
            this.log("\u306c\u308b\u307d\uff1f:" + pFrame);
            throw new RuntimeException("param is wrong ..." + pFrame);
        }
        int f = Integer.parseInt(pFrame);
        if (f < 1) {
            this.log("\u30d5\u30ec\u30fc\u30e0\u6307\u5b9a\u304c\u304a\u304b\u3057\u3044\uff1f:" + f);
            throw new RuntimeException("save frame is wrong ..." + f);
        }
        if (this.isAutoStop && f <= this.beforeFrame_) {
            this.log("\u540c\u30d5\u30ec\u30fc\u30e0\u56de\u907f\u306e\u305f\u3081Stop()\u3092\u30b3\u30fc\u30eb:" + f);
            this.stop(f);
            throw new RuntimeException("save frame must bigger than before frame ...(" + f + " : " + this.beforeFrame_ + ")");
        }
        this.beforeFrame_ = f;
        if (!this.swfCaptureParams_.isAfterStartFrame(f)) {
            this.log("\u958b\u59cb\u4f4d\u7f6e\u7bc4\u56f2\u5916\uff1a" + f + "<" + this.swfCaptureParams_.getSwfStartFrame());
            return false;
        }
        if (!this.swfCaptureParams_.isBeforeEndFrame(f)) {
            this.log("\u7d42\u4e86\u4f4d\u7f6e\u7bc4\u56f2\u5916\uff1a" + f + ">" + this.swfCaptureParams_.getSwfEndFrame());
            if (this.isAutoStop) {
                this.stop(f);
            }
            return false;
        }
        if (this.isAutoStop) {
            this.saveSnapshot(f);
        } else {
            this.saveSnapshot(this.autoCnt_++);
        }
        this.firePropertyChange(PROPERTY_CHANGE_FLAME_SAVE, null, f);
        return true;
    }

    private void saveSnapshot(int pFrame) {
        if (this.isSaving_) {
            String fileName = this.swfCaptureParams_.createSaveFileName(pFrame);
            int type = this.swfCaptureParams_.getImageType();
            Image img = this.swfOle_.getSnapshotImage();
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{img.getImageData()};
            imageLoader.save(fileName, type);
            img.dispose();
            File f = new File(fileName);
            if (this.swfCaptureParams_.isOutputAutoDelete()) {
                f.deleteOnExit();
            }
            this.log("BMP\u30bb\u30fc\u30d6\uff1a" + fileName);
        } else {
            this.log("\u975e\u30bb\u30fc\u30d6\u72b6\u614b\uff1a" + pFrame);
        }
    }

    private void startSave() {
        this.log("[  ] ... startSave");
        this.beforeFrame_ = 0;
        this.isSaving_ = true;
        this.start(this.swfCaptureParams_.getSwfStartFrame());
    }

    private void endSave() {
        this.log("[  ] ... endSave");
        this.beforeFrame_ = -1;
        this.isSaving_ = false;
    }

    private void start(int pFrame) {
        this.log("[F=" + pFrame + "] ... start (startSubMC " + pFrame + " ) ====> SwfLoader");
        String frameStr = "" + pFrame;
        this.sendCommandToSwf("startSubMC", frameStr);
    }

    private void stop(int pFrame) {
        this.log("[F=" + pFrame + "] ... Stop (startSubMC 0 ) ====> SwfLoader");
        this.sendCommandToSwf("startSubMC", "0");
    }

    private void loadSwbSwf(String pFile) {
        this.log("SwfCapturePanel:loadSwbSwf ---START");
        this.sendCommandToSwf("loadSubSwf", pFile);
        this.log("SwfCapturePanel:loadSwbSwf ---END");
    }

    private void sendCommandToSwf(String pCommand, String pArg1) {
        if (this.swfCaptureParams_.isOldVersion()) {
            this.swfOle_.setSwfProperty2(pCommand, pArg1);
        } else {
            this.swfOle_.callSwfCallFunction(pCommand, pArg1, null);
        }
    }

    public boolean isLoatFrame() {
        return this.isLostFrame_;
    }

    public void addPropertyChangeListener(PropertyChangeListener pListener) {
        this.propertyChangeListeners_.addPropertyChangeListener(pListener);
    }

    public void firePropertyChange(String pPropertyName, Object pOldValue, Object pNewValue) {
        this.propertyChangeListeners_.firePropertyChange(pPropertyName, pOldValue, pNewValue);
    }

    public void removePropertyChangeListener(PropertyChangeListener pListener) {
        this.propertyChangeListeners_.removePropertyChangeListener(pListener);
    }
}

