/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import jp.sourceforge.swf2bmp2avi.plugin.Activator;
import jp.sourceforge.swf2bmp2avi.plugin.SwfCaptureParams;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class Swf2BmpView
extends ViewPart
implements PropertyChangeListener {
    public static final String ID = "jp.sourceforge.swf2bmp2avi.swf2bmpview";
    private Label lblAreaDisp_;
    private Text textSwfFilePath_;
    private Button btnSelectSwfFile_;
    private Combo cmbLoaderSelect_;
    private Combo cmbFpsChangeSelect_;
    private Text textBaseFps_;
    private Text textRecordFps_;
    private Text textStartFrame_;
    private Text textEndFrame_;
    private Combo cmbSizeSelect_;
    private Text textSizeWidth_;
    private Text textSizeHeight_;
    private Text textOutputPath_;
    private Button btnExtractSound_;
    private Button btnExec_;
    private SwfCaptureParams swfCapturefParam_;

    public void init(IViewSite pSite) throws PartInitException {
        super.init(pSite);
        this.swfCapturefParam_ = Activator.getDefault().getSwCapturefParam();
        this.swfCapturefParam_.addPropertyChangeListener(this);
    }

    public void dispose() {
        this.swfCapturefParam_.removePropertyChangeListener(this);
        super.dispose();
    }

    private void log(String pMsg) {
        Activator.msg("[" + this.getClass().getSimpleName() + "]" + pMsg);
    }

    public void createPartControl(Composite parent) {
        this.lblAreaDisp_ = new Label(parent, 0x1000000);
        this.lblAreaDisp_.setText("");
        this.lblAreaDisp_.setBackground(this.getSite().getShell().getDisplay().getSystemColor(3));
        Label l = new Label(parent, 131072);
        l.setText("SWF\u30d5\u30a1\u30a4\u30eb");
        this.textSwfFilePath_ = new Text(parent, 2048);
        this.textSwfFilePath_.setText("");
        this.textSwfFilePath_.setText(this.swfCapturefParam_.getSwfFileName());
        this.btnSelectSwfFile_ = new Button(parent, 0x1000000);
        this.btnSelectSwfFile_.setText("\u9078 \u629e");
        this.btnSelectSwfFile_.setToolTipText("\u5143SWF\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e\u3057\u307e\u3059\u3002");
        l = new Label(parent, 131072);
        l.setText("\u518d\u751f\u5f62\u5f0f");
        this.cmbLoaderSelect_ = new Combo(parent, 8);
        this.cmbLoaderSelect_.setItems(SwfCaptureParams.LODER_TYPE_SELECT);
        this.cmbLoaderSelect_.select(this.swfCapturefParam_.getSwfLoderSelect());
        l = new Label(parent, 131072);
        l.setText("\u518d\u751f\u6642FPS");
        this.cmbFpsChangeSelect_ = new Combo(parent, 8);
        this.cmbFpsChangeSelect_.setItems(SwfCaptureParams.FPS_CHANGE_SELECT);
        this.cmbFpsChangeSelect_.select(this.swfCapturefParam_.getSwfFpsChangeSelect());
        this.textBaseFps_ = new Text(parent, 133120);
        this.textBaseFps_.setEditable(false);
        this.textBaseFps_.setText("" + this.swfCapturefParam_.getBaseFps());
        l = new Label(parent, 0);
        l.setText("\u2192");
        this.textRecordFps_ = new Text(parent, 133120);
        this.textRecordFps_.setTextLimit(3);
        this.btnExtractSound_ = new Button(parent, 0x1000000);
        this.btnExtractSound_.setText("\u97f3\u58f0\u62bd\u51fa");
        this.btnExtractSound_.setToolTipText("SWF\u304b\u3089\u97f3\u58f0\u30c7\u30fc\u30bf\u3092\u62bd\u51fa\u3057\u307e\u3059\u3002");
        l = new Label(parent, 0);
        l.setText("\u30d5\u30ec\u30fc\u30e0\u7bc4\u56f2");
        this.textStartFrame_ = new Text(parent, 133120);
        this.textStartFrame_.setTextLimit(6);
        this.textStartFrame_.setText("1");
        l = new Label(parent, 0x1000000);
        l.setText("\uff5e");
        this.textEndFrame_ = new Text(parent, 133120);
        this.textEndFrame_.setTextLimit(6);
        this.textEndFrame_.setText("" + this.swfCapturefParam_.getBaseFrames());
        l = new Label(parent, 131072);
        l.setText("\u518d\u751f\u30b5\u30a4\u30ba");
        this.cmbSizeSelect_ = new Combo(parent, 8);
        this.cmbSizeSelect_.setItems(SwfCaptureParams.DEF_SIZE_NAME);
        this.cmbSizeSelect_.select(this.swfCapturefParam_.getSwfSizeChangeSelect());
        this.textSizeWidth_ = new Text(parent, 133120);
        this.textSizeWidth_.setTextLimit(4);
        this.textSizeWidth_.setText("" + this.swfCapturefParam_.getBaseWidth());
        l = new Label(parent, 0);
        l.setText("x");
        this.textSizeHeight_ = new Text(parent, 133120);
        this.textSizeHeight_.setTextLimit(4);
        this.textSizeHeight_.setText("" + this.swfCapturefParam_.getBaseHeight());
        this.btnExec_ = new Button(parent, 0x1000000);
        this.btnExec_.setText("\u5b9f \u884c");
        this.btnExec_.setImage(Activator.getImage("icons/swf2bmp_32.png"));
        this.btnExec_.setToolTipText("SWF\u304b\u3089BMP\u3092\u751f\u6210\u3059\u308b\u51e6\u7406\u3092\u958b\u59cb\u3057\u307e\u3059\u3002");
        l = new Label(parent, 0);
        l.setText("BMP\u51fa\u529b\u5148");
        this.textOutputPath_ = new Text(parent, 2048);
        this.textOutputPath_.setEditable(false);
        this.textOutputPath_.setText(this.swfCapturefParam_.getCaptureOutputPath());
        this.chackFpsChangeSelect();
        this.checkSizeArea();
        this.createLayout(parent);
        this.createListeners(parent);
    }

    private void createLayout(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 12;
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 2;
        parent.setLayout((Layout)gridLayout);
        GridData gridData = null;
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 4;
        gridData.grabExcessVerticalSpace = true;
        this.lblAreaDisp_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textSwfFilePath_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 80;
        gridData.horizontalAlignment = 4;
        this.btnSelectSwfFile_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        this.cmbLoaderSelect_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.cmbFpsChangeSelect_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 50;
        this.textBaseFps_.setLayoutData((Object)gridData);
        gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 50;
        this.textRecordFps_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 80;
        gridData.verticalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.btnExtractSound_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 40;
        this.textStartFrame_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 40;
        this.textEndFrame_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        this.cmbSizeSelect_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 50;
        this.textSizeWidth_.setLayoutData((Object)gridData);
        gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 50;
        this.textSizeHeight_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 80;
        gridData.verticalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.btnExec_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textOutputPath_.setLayoutData((Object)gridData);
    }

    private void createListeners(Composite parent) {
        DropTarget target = new DropTarget((Control)parent, 17);
        FileTransfer transfer = FileTransfer.getInstance();
        Transfer[] types = new Transfer[]{transfer};
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent evt) {
                evt.detail = 1;
            }

            public void drop(DropTargetEvent evt) {
                String[] files = (String[])evt.data;
                int i = 0;
                while (i < files.length) {
                    File file = new File(files[i]);
                    String ddPath = file.getAbsolutePath();
                    if (ddPath.toLowerCase().endsWith(".swf")) {
                        Swf2BmpView.this.swfCapturefParam_.setSwfFileName(file.getAbsolutePath());
                        return;
                    }
                    ++i;
                }
            }
        });
        this.textSwfFilePath_.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent pE) {
                if (!Swf2BmpView.this.swfCapturefParam_.getSwfFileName().equals(Swf2BmpView.this.textSwfFilePath_.getText())) {
                    Swf2BmpView.this.swfCapturefParam_.setSwfFileName(Swf2BmpView.this.textSwfFilePath_.getText());
                }
            }

            public void focusGained(FocusEvent pE) {
            }
        });
        this.btnSelectSwfFile_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent pArg0) {
            }

            public void widgetSelected(SelectionEvent pArg0) {
                Swf2BmpView.this.openSwfFile();
            }
        });
        this.cmbLoaderSelect_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent pE) {
            }

            public void widgetSelected(SelectionEvent pE) {
                Swf2BmpView.this.swfCapturefParam_.setSwfLoderSelect(Swf2BmpView.this.cmbLoaderSelect_.getSelectionIndex());
            }
        });
        this.cmbFpsChangeSelect_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent pE) {
                Swf2BmpView.this.swfCapturefParam_.setSwfFpsChangeSelect(Swf2BmpView.this.cmbFpsChangeSelect_.getSelectionIndex());
                Swf2BmpView.this.chackFpsChangeSelect();
            }

            public void widgetDefaultSelected(SelectionEvent pE) {
            }
        });
        this.attachNumOnlyListeners(this.textRecordFps_);
        this.textRecordFps_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent pE) {
                Swf2BmpView.this.swfCapturefParam_.setSwfFps(Integer.parseInt(Swf2BmpView.this.textRecordFps_.getText()));
            }
        });
        this.btnExtractSound_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent pE) {
                Swf2BmpView.this.extractSoundData();
            }

            public void widgetDefaultSelected(SelectionEvent pE) {
            }
        });
        this.attachNumOnlyListeners(this.textStartFrame_);
        this.textStartFrame_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent pE) {
                Swf2BmpView.this.swfCapturefParam_.setSwfStartFrame(Integer.parseInt(Swf2BmpView.this.textStartFrame_.getText()));
            }
        });
        this.attachNumOnlyListeners(this.textEndFrame_);
        this.textEndFrame_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent pE) {
                int i = Integer.parseInt(Swf2BmpView.this.textEndFrame_.getText());
                if (i <= Swf2BmpView.this.swfCapturefParam_.getBaseFrames()) {
                    Swf2BmpView.this.swfCapturefParam_.setSwfEndFrame(i);
                } else {
                    Swf2BmpView.this.swfCapturefParam_.setSwfEndFrame(Swf2BmpView.this.swfCapturefParam_.getBaseFrames());
                    Swf2BmpView.this.textEndFrame_.setText("" + Swf2BmpView.this.swfCapturefParam_.getBaseFrames());
                }
            }
        });
        this.cmbSizeSelect_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent pE) {
                Swf2BmpView.this.swfCapturefParam_.setSwfSizeChangeSelect(Swf2BmpView.this.cmbSizeSelect_.getSelectionIndex());
                Swf2BmpView.this.checkSizeArea();
            }

            public void widgetDefaultSelected(SelectionEvent pE) {
            }
        });
        this.attachNumOnlyListeners(this.textSizeWidth_);
        this.textSizeWidth_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent pE) {
                Swf2BmpView.this.swfCapturefParam_.setSwfWidth(Integer.parseInt(Swf2BmpView.this.textSizeWidth_.getText()));
            }
        });
        this.attachNumOnlyListeners(this.textSizeHeight_);
        this.textSizeHeight_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent pE) {
                Swf2BmpView.this.swfCapturefParam_.setSwfHeight(Integer.parseInt(Swf2BmpView.this.textSizeHeight_.getText()));
            }
        });
        this.btnExec_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent pE) {
                Swf2BmpView.this.swfCapturefParam_.execCreateBmp();
            }

            public void widgetDefaultSelected(SelectionEvent pE) {
            }
        });
    }

    private void attachNumOnlyListeners(Text pText) {
        pText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent pE) {
                Display.getCurrent().getActiveShell().setImeInputMode(0);
            }

            public void focusLost(FocusEvent pE) {
            }
        });
        pText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent pE) {
                String val = pE.text;
                if (val == null || val.length() == 0) {
                    return;
                }
                try {
                    Integer.parseInt(val);
                }
                catch (NumberFormatException numberFormatException) {
                    pE.doit = false;
                }
            }
        });
    }

    private void checkSizeArea() {
        int index = this.swfCapturefParam_.getSwfSizeChangeSelect();
        if (index == 6) {
            this.textSizeWidth_.setEnabled(true);
            this.textSizeHeight_.setEnabled(true);
        } else {
            this.textSizeWidth_.setEnabled(false);
            this.textSizeHeight_.setEnabled(false);
            if (index > 0) {
                String[] ary = SwfCaptureParams.DEF_SIZE_VAL[index];
                if (ary != null) {
                    this.textSizeWidth_.setText(ary[0]);
                    this.textSizeHeight_.setText(ary[1]);
                }
            } else {
                this.textSizeWidth_.setText("" + this.swfCapturefParam_.getBaseWidth());
                this.textSizeHeight_.setText("" + this.swfCapturefParam_.getBaseHeight());
            }
        }
        this.swfCapturefParam_.setSwfWidth(Integer.parseInt(this.textSizeWidth_.getText()));
        this.swfCapturefParam_.setSwfHeight(Integer.parseInt(this.textSizeHeight_.getText()));
    }

    private void openSwfFile() {
        String path = this.swfCapturefParam_.getSwfFileName();
        FileDialog dialog = new FileDialog(this.getSite().getShell(), 4096);
        if (path != null) {
            dialog.setFileName(path);
        }
        String[] filterExt = new String[]{"*.swf", "*.*"};
        String[] filterNames = new String[]{"SWF\u30d5\u30a1\u30a4\u30eb(*.swf)", "\u5168\u3066(*.*)"};
        dialog.setFilterExtensions(filterExt);
        dialog.setFilterNames(filterNames);
        path = dialog.open();
        if (path != null) {
            this.swfCapturefParam_.setSwfFileName(path);
            this.textSwfFilePath_.setText(path);
        }
    }

    public void setFocus() {
        this.btnSelectSwfFile_.setFocus();
    }

    private void chackFpsChangeSelect() {
        int selFpsSelect = this.swfCapturefParam_.getSwfFpsChangeSelect();
        if (selFpsSelect == 8) {
            this.textRecordFps_.setEnabled(true);
        } else {
            this.textRecordFps_.setEnabled(false);
            String baseFps = this.textBaseFps_.getText();
            if (baseFps != null && baseFps.length() > 0) {
                try {
                    int dev = SwfCaptureParams.FPS_CHANGE_VALUET[selFpsSelect];
                    int changeFps = Integer.parseInt(baseFps) / dev;
                    if (changeFps == 0) {
                        changeFps = 1;
                    }
                    this.swfCapturefParam_.setSwfFps(changeFps);
                    this.textRecordFps_.setText("" + this.swfCapturefParam_.getSwfFps());
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            } else {
                this.textRecordFps_.setText("");
            }
        }
    }

    public void propertyChange(PropertyChangeEvent pEvt) {
        if (pEvt.getPropertyName().equals("fws_chnaged")) {
            this.log("SWF\u5909\u66f4\u30a4\u30d9\u30f3\u30c8\u53d7\u4fe1");
            this.textBaseFps_.setText("" + this.swfCapturefParam_.getBaseFps());
            this.textRecordFps_.setText("" + this.swfCapturefParam_.getSwfFps());
            this.chackFpsChangeSelect();
            this.textStartFrame_.setText("1");
            this.textEndFrame_.setText("" + this.swfCapturefParam_.getBaseFrames());
            this.textSizeWidth_.setText("" + this.swfCapturefParam_.getBaseWidth());
            this.textSizeHeight_.setText("" + this.swfCapturefParam_.getBaseHeight());
            this.checkSizeArea();
            this.textOutputPath_.setText(this.swfCapturefParam_.getCaptureOutputPath());
        } else if (pEvt.getPropertyName().equals("change_some_propety")) {
            this.cmbLoaderSelect_.select(this.swfCapturefParam_.getSwfLoderSelect());
            this.cmbFpsChangeSelect_.select(this.swfCapturefParam_.getSwfFpsChangeSelect());
            this.cmbSizeSelect_.select(this.swfCapturefParam_.getSwfSizeChangeSelect());
            this.textOutputPath_.setText(this.swfCapturefParam_.getCaptureOutputPath());
            this.chackFpsChangeSelect();
            this.checkSizeArea();
        }
    }

    public void extractSoundData() {
        SwfCaptureParams swfParam = Activator.getDefault().getSwCapturefParam();
        String swfFilePath = swfParam.getSwfFileName();
        if (swfFilePath == null || swfFilePath.length() == 0) {
            this.showMessage("SWF\u30d5\u30a1\u30a4\u30eb\u304c\u9078\u629e\u3055\u308c\u3044\u307e\u305b\u3093", "\u97f3\u58f0\u30c7\u30fc\u30bf\u62bd\u51fa");
            return;
        }
        File f = new File(swfFilePath);
        if (!f.exists() || !f.isFile()) {
            this.showMessage("SWF\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093", "\u97f3\u58f0\u30c7\u30fc\u30bf\u62bd\u51fa");
            return;
        }
        swfParam.extractSoundFile(this.getSite().getShell());
    }

    private void showMessage(String pMsg, String pTitle) {
        MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)pTitle, (String)pMsg);
    }
}

