/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.views;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import jp.sourceforge.swf2bmp2avi.io.BmpBinaryAccess;
import jp.sourceforge.swf2bmp2avi.plugin.Activator;
import jp.sourceforge.swf2bmp2avi.plugin.BmpInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BmpPartCtrl {
    public static final String ICON_BMP_16 = "icons/bmp_16.png";
    private boolean isSynchro_ = false;
    private Label lblAreaDisp_;
    private Composite parent_;
    private Text textBmpDirPath_;
    private Button btnSelectBmpDir_;
    private TableViewer tableViewer_;
    private Button btnBmpRefresh_;
    private Label bmpThumbnail_;
    private Button btnBmpDeleteAll_;
    private ArrayList<BmpInfo> bmpList_ = new ArrayList();
    private Image bmpThumbnailImg_ = null;

    public BmpPartCtrl(Composite pParent) {
        this.parent_ = pParent;
        this.createBmpPartControl(pParent);
    }

    protected void finalize() throws Throwable {
        if (this.bmpThumbnailImg_ != null) {
            this.bmpThumbnailImg_.dispose();
            this.bmpThumbnailImg_ = null;
        }
        super.finalize();
    }

    private void showMessage(String pMsg) {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Swf2Bmp\u5909\u63db", (String)pMsg);
    }

    public void createBmpPartControl(Composite parent) {
        this.lblAreaDisp_ = new Label(parent, 0x1000000);
        this.lblAreaDisp_.setText("");
        this.lblAreaDisp_.setBackground(parent.getShell().getDisplay().getSystemColor(6));
        Label l = new Label(parent, 0);
        l.setText("BMP\u5165\u529b\u5143");
        this.textBmpDirPath_ = new Text(parent, 2048);
        this.btnSelectBmpDir_ = new Button(parent, 0x1000000);
        this.btnSelectBmpDir_.setText("\u9078\u629e");
        this.btnSelectBmpDir_.setToolTipText("BMP\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u5148\u3092\u9078\u629e\u3057\u307e\u3059\u3002");
        this.btnBmpRefresh_ = new Button(parent, 0x1000000);
        this.btnBmpRefresh_.setText("BMP\u4e00\u89a7\u66f4\u65b0");
        this.btnBmpRefresh_.setToolTipText("BMP\u4e00\u89a7\u306e\u5185\u5bb9\u3092\u30ea\u30d5\u30ec\u30c3\u30b7\u30e5\u3057\u3001\u6700\u65b0\u306e\u72b6\u614b\u3092\u53cd\u6620\u3057\u307e\u3059\u3002");
        this.tableViewer_ = new TableViewer(parent, 770);
        this.tableViewer_.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer_.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        Table table = this.tableViewer_.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText("\u30d5\u30a1\u30a4\u30eb\u540d");
        column.setWidth(200);
        column = new TableColumn(table, 0x1000000);
        column.setText("\u66f4\u65b0\u65e5");
        column.setWidth(200);
        column = new TableColumn(table, 16384);
        column.setText("\u6982\u8981");
        column.setWidth(200);
        this.tableViewer_.setInput(this.bmpList_);
        this.bmpThumbnail_ = new Label(parent, 0x1000800);
        this.btnBmpDeleteAll_ = new Button(parent, 0x1000000);
        this.btnBmpDeleteAll_.setText("\u5168BMP\u524a\u9664");
        this.btnBmpDeleteAll_.setToolTipText("\u5168\u3066\u306eBMP\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u307e\u3059\u3002");
        this.initBmpLayout(parent);
        this.initListener();
    }

    public void initBmpLayout(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 8;
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 2;
        parent.setLayout((Layout)gridLayout);
        GridData gridData = null;
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 4;
        gridData.grabExcessVerticalSpace = true;
        this.lblAreaDisp_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textBmpDirPath_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalSpan = 1;
        gridData.widthHint = 60;
        gridData.horizontalAlignment = 4;
        this.btnSelectBmpDir_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 4;
        this.btnBmpRefresh_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.verticalSpan = 3;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        this.tableViewer_.getControl().setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        gridData.widthHint = 80;
        gridData.heightHint = 60;
        gridData.horizontalAlignment = 2;
        this.bmpThumbnail_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        gridData.widthHint = 90;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.btnBmpDeleteAll_.setLayoutData((Object)gridData);
    }

    private void initListener() {
        this.tableViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection ss = (StructuredSelection)event.getSelection();
                    BmpPartCtrl.this.onChangeBmpListSelect((BmpInfo)ss.getFirstElement());
                }
            }
        });
        this.textBmpDirPath_.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent pEvt) {
                BmpPartCtrl.this.refreshBmpList();
            }

            public void focusGained(FocusEvent pE) {
            }
        });
        this.btnSelectBmpDir_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent pArg0) {
            }

            public void widgetSelected(SelectionEvent pEvt) {
                BmpPartCtrl.this.openBmpDir();
            }
        });
        this.btnBmpRefresh_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent pArg0) {
            }

            public void widgetSelected(SelectionEvent pEvt) {
                BmpPartCtrl.this.refreshBmpList();
            }
        });
        this.btnBmpDeleteAll_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent pArg0) {
            }

            public void widgetSelected(SelectionEvent pEvt) {
                BmpPartCtrl.this.deleteAllBmps();
            }
        });
    }

    private void onChangeBmpListSelect(BmpInfo pInfo) {
        if (pInfo == null) {
            this.setBmpThumbnailImg(null);
        } else {
            this.setBmpThumbnailImg(pInfo.getFileFullPath());
        }
    }

    private void setBmpThumbnailImg(String pFilePath) {
        int w = this.bmpThumbnail_.getBounds().width;
        int h = this.bmpThumbnail_.getBounds().height;
        if (this.bmpThumbnailImg_ != null) {
            this.bmpThumbnailImg_.dispose();
            this.bmpThumbnailImg_ = null;
        }
        if (pFilePath != null && pFilePath.length() > 0) {
            Image tmpImg = new Image((Device)this.parent_.getDisplay(), pFilePath);
            ImageData imgDat = tmpImg.getImageData();
            this.bmpThumbnailImg_ = new Image((Device)this.parent_.getDisplay(), w, h);
            GC gc = new GC((Drawable)this.bmpThumbnailImg_);
            gc.drawImage(tmpImg, 0, 0, imgDat.width, imgDat.height, 0, 0, w, h);
            gc.dispose();
            tmpImg.dispose();
        }
        this.bmpThumbnail_.setImage(this.bmpThumbnailImg_);
    }

    private void openBmpDir() {
        File f;
        String path = this.textBmpDirPath_.getText();
        if (path != null && path.length() > 0 && !(f = new File(path)).exists() && f.getParentFile().exists()) {
            path = f.getParent();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.parent_.getShell());
        if (path != null) {
            dialog.setFilterPath(path);
        }
        if ((path = dialog.open()) != null) {
            this.textBmpDirPath_.setText(path);
            this.refreshBmpList();
        }
    }

    private void refreshBmpList() {
        this.parent_.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Table table = BmpPartCtrl.this.tableViewer_.getTable();
                BmpPartCtrl.this.bmpList_.clear();
                BmpPartCtrl.this.tableViewer_.refresh();
                table.setVisible(false);
                BmpPartCtrl.this.recreateBmpList();
                BmpPartCtrl.this.tableViewer_.refresh();
                try {
                    TableColumn[] columns = table.getColumns();
                    int i = 0;
                    while (i < columns.length) {
                        columns[i].pack();
                        ++i;
                    }
                }
                catch (Exception exception) {}
                table.setVisible(true);
            }
        });
        System.out.println("BMP\u30ea\u30b9\u30c8\u5185\u5bb9\u306e\u518d\u751f\u6210");
    }

    private void recreateBmpList() {
        String bmpInputDirPath = this.textBmpDirPath_.getText();
        if (bmpInputDirPath == null) {
            return;
        }
        File dir = new File(bmpInputDirPath);
        if (!dir.exists()) {
            return;
        }
        final File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File pPathname) {
                if (!pPathname.exists()) {
                    return false;
                }
                if (!pPathname.isFile()) {
                    return false;
                }
                return pPathname.getName().endsWith(".bmp");
            }
        });
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                BmpPartCtrl.this.progresRunRecreateBmpList(monitor, files);
            }
        };
        try {
            Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().run(true, true, op);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {}
    }

    private void progresRunRecreateBmpList(IProgressMonitor monitor, File[] files) throws InterruptedException {
        monitor.beginTask("BMP\u4e00\u89a7\u306e\u66f4\u65b0\u4e2d\u2026", files.length);
        this.bmpList_.clear();
        int totalCnt = files.length;
        int i = 0;
        while (i < totalCnt) {
            if (monitor.isCanceled()) {
                monitor.done();
                throw new InterruptedException("\u4e00\u89a7\u8868\u793a\u30ad\u30e3\u30f3\u30bb\u30eb");
            }
            monitor.worked(1);
            BmpInfo info = new BmpInfo();
            info.setFileName(files[i].getName());
            info.setFileFullPath(files[i].getAbsolutePath());
            info.setLastModified(files[i].lastModified());
            monitor.subTask("(" + i + "/" + totalCnt + ") ");
            if (totalCnt < 2000) {
                try {
                    BmpBinaryAccess readBmp = new BmpBinaryAccess(files[i].getAbsolutePath(), false);
                    info.setWidth(readBmp.getWidth());
                    info.setHeight(readBmp.getHeight());
                    info.setDeep(readBmp.getBitCount());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.bmpList_.add(info);
            ++i;
        }
        monitor.done();
    }

    public boolean isSynchro() {
        return this.isSynchro_;
    }

    public void setSynchro(boolean pIsSynchro) {
        this.isSynchro_ = pIsSynchro;
        if (this.isSynchro_) {
            this.textBmpDirPath_.setEnabled(false);
            this.btnSelectBmpDir_.setEnabled(false);
        } else {
            this.textBmpDirPath_.setEnabled(true);
            this.btnSelectBmpDir_.setEnabled(true);
        }
        this.refreshBmpList();
    }

    public void setBmpDirPath(String pDmpDir) {
        this.textBmpDirPath_.setText(pDmpDir);
    }

    public String getBmpDirPath() {
        return this.textBmpDirPath_.getText();
    }

    public ArrayList<BmpInfo> getBmpList() {
        return this.bmpList_;
    }

    private void deleteAllBmps() {
        ArrayList<BmpInfo> list = this.getBmpList();
        if (list == null || list.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            File f;
            BmpInfo bmp = list.get(i);
            if (bmp != null && (f = new File(bmp.getFileFullPath())).exists() && f.isFile() && !f.delete()) {
                this.showMessage("\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n " + f.getName());
                break;
            }
            ++i;
        }
        this.refreshBmpList();
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd H:m:s");

        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof BmpInfo) {
                BmpInfo info = (BmpInfo)obj;
                if (index == 0) {
                    return info.getFileName();
                }
                if (index == 1) {
                    return this.dateFormat.format(info.getLastModified());
                }
                if (index == 2) {
                    if (info.getWidth() == 0) {
                        return "";
                    }
                    return info.getWidth() + " x " + info.getHeight() + "  (" + info.getDeep() + "bit)";
                }
                return "--";
            }
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            if (index > 0) {
                return null;
            }
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return Activator.getImage(BmpPartCtrl.ICON_BMP_16);
        }
    }
}

