/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.sourceforge.swf2bmp2avi.process.ProcessRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FFmpegProcessRunner
extends ProcessRunner {
    private static final SimpleDateFormat FORMAT_TIMES = new SimpleDateFormat("00:mm:ss:SSS");
    private File ffmpegPath_;
    private String inputFile_;
    private String outputFile_;
    private String format_;
    private String videoCodec_;
    private String videoSize_;
    private String videoAspect_;
    private int videoFrames_;
    private int videoFPS_;
    private String videoBitrate_;
    private String audioInputFile_;
    private String audioCodec_;
    private String audioBitrate_;
    private int channels_;

    public FFmpegProcessRunner(File pFFmpegPath) {
        this.setFfmpegPath(pFFmpegPath);
    }

    public boolean execComvert() {
        List<String> params = this.createConvParam();
        this.dumpParams(params);
        try {
            this.execProcess(params);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    private List<String> createConvParam() {
        this.setDirectory(this.ffmpegPath_.getParent());
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.ffmpegPath_.getAbsolutePath());
        list.add("-itsoffset");
        list.add("0");
        if (this.videoFPS_ > 0) {
            list.add("-r");
            list.add("" + this.videoFPS_);
        }
        if (this.videoSize_ != null) {
            list.add("-s");
            list.add(this.videoSize_);
        }
        if (this.videoAspect_ != null) {
            list.add("-aspect");
            list.add(this.videoAspect_);
        }
        list.add("-i");
        list.add(this.inputFile_);
        if (this.audioInputFile_ != null) {
            if (this.audioInputFile_.toLowerCase().endsWith(".mp3") || this.audioInputFile_.toLowerCase().endsWith(".wav")) {
                list.add("-i");
                list.add(this.audioInputFile_);
            } else if (this.audioInputFile_.toLowerCase().endsWith(".timeinfo.txt")) {
                try {
                    String[][] timeFileAry = this.getTimeAndFileAry(this.audioInputFile_);
                    if (timeFileAry != null) {
                        list.add("-itsoffset");
                        list.add(timeFileAry[0][0]);
                        list.add("-i");
                        list.add(timeFileAry[0][1]);
                        list.add("-async");
                        list.add("1");
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (this.videoBitrate_ != null && this.videoBitrate_.trim().length() > 0) {
            list.add("-b");
            list.add(this.videoBitrate_);
        }
        if (this.videoFPS_ > 0) {
            list.add("-r");
            list.add("" + this.videoFPS_);
        }
        if (this.videoFrames_ > 0) {
            list.add("-vframes");
            list.add("" + this.videoFrames_);
        }
        if (this.videoSize_ != null) {
            list.add("-s");
            list.add(this.videoSize_);
        }
        if (this.videoAspect_ != null) {
            list.add("-aspect");
            list.add(this.videoAspect_);
        }
        if (this.format_ != null) {
            list.add("-f");
            list.add(this.format_);
        }
        if (this.videoCodec_ != null) {
            list.add("-vcodec");
            list.add(this.videoCodec_);
        }
        if (this.audioInputFile_ != null) {
            if (this.audioCodec_ != null) {
                list.add("-acodec");
                list.add(this.audioCodec_);
            }
            if (this.audioBitrate_ != null) {
                list.add("-ab");
                list.add(this.audioBitrate_);
            }
            if (this.channels_ > 0) {
                list.add("-ac");
                list.add("" + this.channels_);
            }
        } else {
            list.add("-an");
        }
        list.add("-y");
        list.add(this.outputFile_);
        return list;
    }

    private String[][] getTimeAndFileAry(String pConfFile) throws IOException {
        String line;
        ArrayList<String[]> wkParams = new ArrayList<String[]>();
        BufferedReader fr = new BufferedReader(new FileReader(pConfFile));
        while ((line = fr.readLine()) != null) {
            String[] paramAry;
            if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("//") || (paramAry = line.split(",")).length < 2) continue;
            try {
                int frame = Integer.parseInt(paramAry[0]);
                String timeStr = this.frameToTimeStr(frame);
                File soundFile = new File(paramAry[1].trim());
                if (!soundFile.exists() || !soundFile.isFile()) {
                    throw new FileNotFoundException("\u30d5\u30a1\u30a4r\u7121\u3057\uff1a" + soundFile.getAbsolutePath());
                }
                String[] paramSet = new String[]{timeStr, soundFile.getAbsolutePath()};
                wkParams.add(paramSet);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (wkParams.isEmpty()) {
            return null;
        }
        return (String[][])wkParams.toArray((T[])new String[0][0]);
    }

    private String frameToTimeStr(int pFram) {
        System.out.println("pFram = " + pFram);
        System.out.println(" 1000 * (pFram -1) = " + 1000 * (pFram - 1));
        System.out.println("this.videoFPS_ = " + this.videoFPS_);
        System.out.println("1000 * (pFram -1) / this.videoFPS_ = " + 1000 * (pFram - 1) / this.videoFPS_);
        long ms = 1000 * pFram / this.videoFPS_;
        System.out.println("Date(ms)  = " + new Date(ms));
        System.out.println("FMT = " + FORMAT_TIMES.format(new Date(ms)));
        return FORMAT_TIMES.format(new Date(ms));
    }

    public File getFfmpegPath() {
        return this.ffmpegPath_;
    }

    public void setFfmpegPath(File pFfmpegPath) {
        this.ffmpegPath_ = pFfmpegPath;
    }

    public String getInputFile() {
        return this.inputFile_;
    }

    public void setInputFile(String pInputFile) {
        this.inputFile_ = pInputFile;
    }

    public String getOutputFile() {
        return this.outputFile_;
    }

    public void setOutputFile(String pOutputFile) {
        this.outputFile_ = pOutputFile;
    }

    public String getFormat() {
        return this.format_;
    }

    public void setFormat(String pFormat) {
        this.format_ = pFormat;
    }

    public String getVideoCodec() {
        return this.videoCodec_;
    }

    public void setVideoCodec(String pVideoCodec) {
        this.videoCodec_ = pVideoCodec;
    }

    public int getVideoFPS() {
        return this.videoFPS_;
    }

    public void setVideoFPS(int pVideoFPS) {
        this.videoFPS_ = pVideoFPS;
    }

    public String getVideoSize() {
        return this.videoSize_;
    }

    public void setVideoSize(String pVideoSize) {
        this.videoSize_ = pVideoSize;
    }

    public String getAudioInputFile() {
        return this.audioInputFile_;
    }

    public void setAudioInputFile(String pAudioInputFile) {
        this.audioInputFile_ = pAudioInputFile;
    }

    public String getAudioCodec() {
        return this.audioCodec_;
    }

    public void setAudioCodec(String pAudioCodec) {
        this.audioCodec_ = pAudioCodec;
    }

    public String getVideoBitrate() {
        return this.videoBitrate_;
    }

    public void setVideoBitrate(String pVideoBitrate) {
        this.videoBitrate_ = pVideoBitrate;
    }

    public String getAudioBitrate() {
        return this.audioBitrate_;
    }

    public void setAudioBitrate(String pAudioBitrate) {
        this.audioBitrate_ = pAudioBitrate;
    }

    public int getChannels() {
        return this.channels_;
    }

    public void setChannels(int pChannels) {
        this.channels_ = pChannels;
    }

    public int getVideoFrames() {
        return this.videoFrames_;
    }

    public void setVideoFrames(int pVideoFrames) {
        this.videoFrames_ = pVideoFrames;
    }

    public String getVideoAspect() {
        return this.videoAspect_;
    }

    public void setVideoAspect(String videoAspect) {
        this.videoAspect_ = videoAspect;
    }
}

