/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.plugin;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import jp.sourceforge.swf2bmp2avi.io.swf.ISwfAnalyzeEventListener;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfAnalyzeEvent;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfFile;
import jp.sourceforge.swf2bmp2avi.plugin.Activator;
import jp.sourceforge.swf2bmp2avi.plugin.SwfManager;
import jp.sourceforge.swf2bmp2avi.process.ProcessRunner;
import jp.sourceforge.swf2bmp2avi.views.swf.SwfCaptureDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SwfCaptureParams
implements IPropertyChangeListener {
    public static final String EVENT_FWS_FILE_CHANGED = "fws_chnaged";
    public static final String EVENT_CHANGE_SOME_PROPATY = "change_some_propety";
    public static final String EVENT_CREATED_CAPTURE_IMAGE = "created_capture_image";
    public static final String EVENT_CREATED_SOUND_FONF = "created_sound_conf";
    public static final String FILE_SWF_PATH = "loaderswf";
    public static final String FILE_SWF_LOADER = "As3SwfLoader.swf";
    public static final String FILE_OLDSWF_LOADER = "OldVerLoader.swf";
    public static final String[] LODER_TYPE_SELECT = new String[]{"\u81ea\u52d5", "AS3\u7528", "\u65e7\u65b9\u5f0f\u7528"};
    public static final String[] FPS_CHANGE_SELECT = new String[]{"\u81ea\u52d5", "1/2\u30b9\u30ed\u30fc\u518d\u751f", "1/3\u30b9\u30ed\u30fc\u518d\u751f", "1/4\u30b9\u30ed\u30fc\u518d\u751f", "1/5\u30b9\u30ed\u30fc\u518d\u751f", "1/10\u30b9\u30ed\u30fc\u518d\u751f", "1/12\u30b9\u30ed\u30fc\u518d\u751f", "1/15\u30b9\u30ed\u30fc\u518d\u751f", "FPS\u624b\u52d5\u8a2d\u5b9a"};
    public static final int FPS_CHANGE_INDEX_MANUAL = 8;
    public static final int[] FPS_CHANGE_VALUET = new int[]{1, 2, 3, 4, 5, 10, 12, 15, 1};
    public static final String[] DEF_SIZE_NAME = new String[]{"\u81ea\u52d5", "256x192", "400x300", "512x288", "512x384", "800x600", "\u624b\u52d5\u8a2d\u5b9a"};
    public static final String[][] DEF_SIZE_VAL;
    public static final String OUTPUT_BMP_TEMP_PATH_APPEND = "_s2b2a_bmp";
    public static final String OUTPUT_BMP_PREFIX = "s2b2a_";
    public static final String OUTPUT_BMP_SEQUENCE_PART = "000000";
    private static final NumberFormat numFormat;
    public static final String OUTPUT_BMP_EXTENSION = ".bmp";
    public static final String OUTPUT_SOUND_TEMP_PATH_APPEND = "_s2b2a_sound";
    private String swfFileName_;
    private int swfLoderSelect_;
    private int swfFpsChangeSelect_;
    private int swfFps_;
    private int swfStartFrame_;
    private int swfEndFrame_;
    private int swfSizeChangeSelect_;
    private int swfWidth_;
    private int swfHeight_;
    private int baseVersion_;
    private int baseFrames_;
    private int baseFps_;
    private int baseWidth_;
    private int baseHeight_;
    private int swfOutputMode_;
    private String outputDirPath_;
    private boolean isOutputAutoDelete_;
    private String swfAs3LoaderCopy_;
    private String swfOldLoaderCopy_;
    private String outputSoundConfFile_;
    private SwfFile targetSwf_;
    private IPreferenceStore preferenceStore_;
    private PropertyChangeSupport listeners_ = new PropertyChangeSupport(this);

    static {
        String[][] stringArrayArray = new String[7][];
        stringArrayArray[1] = new String[]{"256", "192"};
        stringArrayArray[2] = new String[]{"400", "300"};
        stringArrayArray[3] = new String[]{"512", "288"};
        stringArrayArray[4] = new String[]{"512", "384"};
        stringArrayArray[5] = new String[]{"800", "600"};
        DEF_SIZE_VAL = stringArrayArray;
        numFormat = new DecimalFormat(OUTPUT_BMP_SEQUENCE_PART);
    }

    public SwfCaptureParams(IPreferenceStore pPreferenceStore) {
        this.preferenceStore_ = pPreferenceStore;
        this.load(pPreferenceStore);
        this.swfAs3LoaderCopy_ = this.checkSwfLoaderOnWork(FILE_SWF_LOADER);
        this.swfOldLoaderCopy_ = this.checkSwfLoaderOnWork(FILE_OLDSWF_LOADER);
    }

    public void load(IPreferenceStore pPreferenceStore) {
        this.swfOutputMode_ = pPreferenceStore.getInt("swf2avi.swf.output_mode");
        this.swfFileName_ = pPreferenceStore.getString("swf2avi.swf.file_Path");
        this.swfLoderSelect_ = pPreferenceStore.getInt("swf2avi.swf.loader_type_sel");
        this.swfFpsChangeSelect_ = pPreferenceStore.getInt("swf2avi.swf.cahnge_select");
        this.swfSizeChangeSelect_ = pPreferenceStore.getInt("swf2avi.swf.rec_size_sel");
        this.outputDirPath_ = pPreferenceStore.getString("swf2avi.swf.output_path");
        this.isOutputAutoDelete_ = pPreferenceStore.getBoolean("swf2avi.swf.putput_auto_delete");
        try {
            this.analyzeFpsFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void save(IPreferenceStore pPreferenceStore) {
        pPreferenceStore.setValue("swf2avi.swf.file_Path", this.swfFileName_);
    }

    private void showMessage(String pMsg) {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Swf2Bmp\u5909\u63db", (String)pMsg);
    }

    private boolean showQestion(String pMsg, String pTitle) {
        return MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)pTitle, (String)pMsg);
    }

    public void execCreateBmp() {
        String swfFileName = this.getSwfFileName();
        if (swfFileName == null || swfFileName.length() == 0) {
            this.showMessage("SWF\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            return;
        }
        File f = new File(swfFileName);
        if (!f.exists() || !f.isFile()) {
            this.showMessage("\u5bfe\u8c61SWF\u30d5\u30a1\u30a4\u30eb\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            return;
        }
        if (this.preferenceStore_.getBoolean("swf2avi.swf.before_delete_bmp")) {
            this.deleteAllBmps();
        }
        try {
            Shell shell = new Shell();
            SwfCaptureDialog d = new SwfCaptureDialog(shell, this);
            shell.pack();
            int ret = d.open();
            if (ret == -99) {
                this.showMessage("\u30d5\u30ec\u30fc\u30e0\u843d\u3061\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\n\u518d\u751f\u6642FPS\u306e\u5024\u3092\u5c0f\u3055\u304f\u3057\u3066\u5b9f\u884c\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        }
        catch (Exception e) {
            this.showMessage(e.toString());
        }
        this.firePropertyChange(EVENT_CREATED_CAPTURE_IMAGE, null, null);
    }

    private void deleteAllBmps() {
        String bmpPath = this.getCaptureOutputPath();
        if (bmpPath == null || bmpPath.length() <= 0) {
            return;
        }
        File dir = new File(bmpPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File pPathname) {
                if (!pPathname.exists()) {
                    return false;
                }
                if (!pPathname.isFile()) {
                    return false;
                }
                return pPathname.getName().endsWith(SwfCaptureParams.OUTPUT_BMP_EXTENSION);
            }
        });
        int i = 0;
        while (i < files.length) {
            files[i].delete();
            ++i;
        }
    }

    private String checkSwfLoaderOnWork(String pFileName) {
        File f;
        block30: {
            f = Activator.getDefault().getStateLocation().append(pFileName).toFile();
            if (!f.exists()) {
                InputStream in;
                block31: {
                    byte[] buff = new byte[1024];
                    FileOutputStream fo = null;
                    in = null;
                    try {
                        int len;
                        fo = new FileOutputStream(f);
                        URL u = Activator.getDefault().getBundle().getResource("/loaderswf/" + pFileName);
                        in = u.openStream();
                        BufferedInputStream bin = new BufferedInputStream(in);
                        while ((len = bin.read(buff)) != -1) {
                            fo.write(buff, 0, len);
                        }
                        fo.flush();
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                        if (fo != null) {
                            try {
                                fo.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        break block30;
                    }
                    catch (IOException ex) {
                        try {
                            ex.printStackTrace();
                            break block30;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (fo != null) {
                                try {
                                    fo.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    if (fo == null) break block31;
                    try {
                        fo.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return f.getAbsolutePath();
    }

    public void propertyChange(PropertyChangeEvent pEvent) {
        if (pEvent.getProperty().equals("swf2avi.swf.output_mode")) {
            this.swfOutputMode_ = this.preferenceStore_.getInt("swf2avi.swf.output_mode");
        } else if (pEvent.getProperty().equals("swf2avi.swf.output_path")) {
            this.outputDirPath_ = this.preferenceStore_.getString("swf2avi.swf.output_path");
        } else if (pEvent.getProperty().equals("swf2avi.swf.putput_auto_delete")) {
            this.isOutputAutoDelete_ = this.preferenceStore_.getBoolean("swf2avi.swf.putput_auto_delete");
        } else if (pEvent.getProperty().equals("swf2avi.swf.loader_type_sel")) {
            this.swfLoderSelect_ = this.preferenceStore_.getInt("swf2avi.swf.loader_type_sel");
        } else if (pEvent.getProperty().equals("swf2avi.swf.cahnge_select")) {
            this.swfFpsChangeSelect_ = this.preferenceStore_.getInt("swf2avi.swf.cahnge_select");
        } else if (pEvent.getProperty().equals("swf2avi.swf.rec_size_sel")) {
            this.swfSizeChangeSelect_ = this.preferenceStore_.getInt("swf2avi.swf.rec_size_sel");
        }
        this.firePropertyChange(EVENT_CHANGE_SOME_PROPATY, null, null);
    }

    public boolean isOldVersion() {
        boolean isOldVer = false;
        if (this.swfLoderSelect_ == 2) {
            isOldVer = true;
        } else if (this.swfLoderSelect_ == 0 && this.baseVersion_ < 9) {
            isOldVer = true;
        }
        return isOldVer;
    }

    public boolean isAfterStartFrame(int pFrame) {
        return this.swfStartFrame_ <= 0 || pFrame >= this.swfStartFrame_;
    }

    public boolean isBeforeEndFrame(int pFrame) {
        return this.swfEndFrame_ <= 0 || pFrame <= this.swfEndFrame_;
    }

    public String getAs3SwfLoderFile() {
        return this.swfAs3LoaderCopy_;
    }

    public String getOldSwfLoderFile() {
        return this.swfOldLoaderCopy_;
    }

    public String createSaveFileName(int pFrame) {
        String name = OUTPUT_BMP_PREFIX + numFormat.format(pFrame) + OUTPUT_BMP_EXTENSION;
        File f = new File(this.getCaptureOutputPath(), name);
        return f.getAbsolutePath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getCaptureOutputPath(boolean pIsCreate) throws IOException {
        String path = this.getCaptureOutputPath();
        if (!pIsCreate) return path;
        File dir = new File(path);
        if (!dir.exists()) {
            if (!dir.mkdirs()) throw new IOException("\u51fa\u529b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff1a" + dir);
            if (!this.isOutputAutoDelete()) return path;
            dir.deleteOnExit();
            return path;
        } else {
            if (dir.canWrite()) return path;
            throw new IOException("\u51fa\u529b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b\u66f8\u304d\u8fbc\u307f\u3067\u304d\u307e\u305b\u3093\uff1a" + dir);
        }
    }

    public String getCaptureOutputPath() {
        String basePath = "";
        if (this.swfOutputMode_ == 0) {
            String filePath = this.getSwfFileName();
            if (filePath != null && filePath.length() > 0) {
                if (filePath.toLowerCase().endsWith(".swf")) {
                    filePath = filePath.substring(0, filePath.length() - 4);
                }
                basePath = String.valueOf(filePath) + OUTPUT_BMP_TEMP_PATH_APPEND;
            }
        } else if (this.getOutputDirPath() != null) {
            basePath = this.getOutputDirPath();
        }
        return basePath;
    }

    public String getSoundOutputPath() {
        String basePath = "";
        String filePath = this.getSwfFileName();
        if (filePath != null && filePath.length() > 0) {
            if (filePath.toLowerCase().endsWith(".swf")) {
                filePath = filePath.substring(0, filePath.length() - 4);
            }
            basePath = String.valueOf(filePath) + OUTPUT_SOUND_TEMP_PATH_APPEND;
        }
        return basePath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSoundOutputPath(boolean pIsCreate) throws IOException {
        String basePath = this.getSoundOutputPath();
        if (!pIsCreate) return basePath;
        File dir = new File(basePath);
        if (!dir.exists()) {
            if (!dir.mkdirs()) throw new IOException("\u97f3\u58f0\u30c7\u30fc\u30bf\u51fa\u529b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff1a" + dir);
            if (!this.isOutputAutoDelete()) return basePath;
            dir.deleteOnExit();
            return basePath;
        } else {
            if (dir.canWrite()) return basePath;
            throw new IOException("\u97f3\u58f0\u30c7\u30fc\u30bf\u51fa\u529b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b\u66f8\u304d\u8fbc\u307f\u3067\u304d\u307e\u305b\u3093\uff1a" + dir);
        }
    }

    public int getImageType() {
        return 0;
    }

    public String getSwfLoader() {
        if (this.isOldVersion()) {
            return this.getOldSwfLoderFile();
        }
        return this.getAs3SwfLoderFile();
    }

    public String getSwfFileName() {
        return this.swfFileName_;
    }

    public String getSwfFileNameCoreName() {
        File f = new File(this.swfFileName_);
        String name = f.getName();
        if (name.toLowerCase().endsWith(".swf")) {
            name = name.substring(0, name.length() - 4);
        }
        return name;
    }

    public void setSwfFileName(String pSwfFileName) {
        this.swfFileName_ = pSwfFileName;
        try {
            this.analyzeFpsFile();
            this.firePropertyChange(EVENT_FWS_FILE_CHANGED, null, this.swfFileName_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void analyzeFpsFile() throws IOException {
        File f;
        if (this.swfFileName_ != null && this.swfFileName_.length() > 0 && (f = new File(this.swfFileName_)).exists() && f.isFile()) {
            this.targetSwf_ = SwfManager.getInstance().getUncompressSwfFileWithProgres(this.swfFileName_);
            this.setBaseVersion(this.targetSwf_.getSwfVersion());
            this.setBaseFrames(this.targetSwf_.getSwfFrameCount());
            this.setBaseFps(this.targetSwf_.getSwfFps());
            this.setBaseWidth(this.targetSwf_.getSwfWidth());
            this.setBaseHeight(this.targetSwf_.getSwfHeight());
            this.setSwfFps(this.targetSwf_.getSwfFps());
            this.setSwfWidth(this.targetSwf_.getSwfWidth());
            this.setSwfHeight(this.targetSwf_.getSwfHeight());
            this.setSwfStartFrame(1);
            this.setSwfEndFrame(this.targetSwf_.getSwfFrameCount());
        }
    }

    public boolean extractSoundFile(Shell pShell) {
        try {
            String nameCore = this.getSwfFileNameCoreName();
            String soundOutputDir = this.getSoundOutputPath(true);
            final String baseName = String.valueOf(soundOutputDir) + File.separator + nameCore;
            final String timeInfoFineName = String.valueOf(soundOutputDir) + File.separator + nameCore + ".timeinfo.txt";
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(pShell);
            progressDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor pMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        final IProgressMonitor monitor = pMonitor;
                        SwfCaptureParams.this.targetSwf_.addSwfAnalyzeEventListener(new ISwfAnalyzeEventListener(){

                            public void onAnalyzing(SwfAnalyzeEvent pEvent) {
                                if (pEvent.getEventID() == 21) {
                                    monitor.beginTask(pEvent.getMessag(), pEvent.getWorkingCount());
                                } else if (pEvent.getEventID() == 22) {
                                    monitor.done();
                                } else if (pEvent.getEventID() == 5) {
                                    monitor.subTask(pEvent.getMessag());
                                } else if (pEvent.getEventID() == 4) {
                                    monitor.worked(pEvent.getWorkingCount());
                                }
                            }
                        });
                        SwfCaptureParams.this.targetSwf_.writeSoundToFile(baseName, timeInfoFineName);
                        Activator.msg("\u30b5\u30a6\u30f3\u30c9\u66f8\u304d\u51fa\u3057\u5b8c\u4e86");
                    }
                    catch (IOException ex) {
                        throw new InterruptedException(ex.getMessage());
                    }
                }
            });
            Activator.msg("\u8a2d\u5b9a\u30c7\u30fc\u30bf\u66f8\u304d\u51fa\u3057");
            this.setOutputSoundConfFile(timeInfoFineName);
            Activator.msg("\u97f3\u58f0\u30c7\u30fc\u30bf\u51fa\u529b\u5b8c\u4e86\u30a4\u30d9\u30f3\u30c8\u9001\u4fe1\uff1a\u958b\u59cb");
            this.firePropertyChange(EVENT_CREATED_SOUND_FONF, null, timeInfoFineName);
            Activator.msg("\u97f3\u58f0\u30c7\u30fc\u30bf\u51fa\u529b\u5b8c\u4e86\u30a4\u30d9\u30f3\u30c8\u9001\u4fe1\uff1a\u7d42\u4e86");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.showMessage("\u97f3\u58f0\u30c7\u30fc\u30bf\u62bd\u51fa\u3092\u4e2d\u6b62\u3057\u307e\u3057\u305f \n" + e.getMessage());
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.showMessage("\u97f3\u58f0\u30c7\u30fc\u30bf\u62bd\u51fa\u3092\u4e2d\u6b62\u3057\u307e\u3057\u305f\n" + e.getMessage());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showMessage(e.toString());
            return false;
        }
        if (this.showQestion("\u97f3\u58f0\u30c7\u30fc\u30bf\u3092\u62bd\u51fa\u3057\u307e\u3057\u305f\u3002\n\u51fa\u529b\u30d5\u30a9\u30eb\u30c0\uff1a" + this.getSoundOutputPath() + "\n\u3053\u306e\u30d5\u30a9\u30eb\u30c0\u3092\u958b\u304d\u307e\u3059\u304b\uff1f", "\u97f3\u58f0\u30c7\u30fc\u30bf\u62bd\u51fa")) {
            ProcessRunner.openExplorer(String.valueOf(this.getSoundOutputPath()) + File.separator);
        }
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener pListener) {
        this.listeners_.addPropertyChangeListener(pListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener pListener) {
        this.listeners_.removePropertyChangeListener(pListener);
    }

    public void firePropertyChange(String pPropertyName, Object pOldValue, Object pNewValue) {
        this.listeners_.firePropertyChange(pPropertyName, pOldValue, pNewValue);
    }

    public int getSwfLoderSelect() {
        return this.swfLoderSelect_;
    }

    public void setSwfLoderSelect(int pSwfLoderSelect) {
        this.swfLoderSelect_ = pSwfLoderSelect;
    }

    public int getSwfFpsChangeSelect() {
        return this.swfFpsChangeSelect_;
    }

    public void setSwfFpsChangeSelect(int pSwfFpsChangeSelect) {
        this.swfFpsChangeSelect_ = pSwfFpsChangeSelect;
    }

    public int getSwfFps() {
        return this.swfFps_;
    }

    public void setSwfFps(int pSwfFps) {
        this.swfFps_ = pSwfFps;
    }

    public int getSwfSizeChangeSelect() {
        return this.swfSizeChangeSelect_;
    }

    public void setSwfSizeChangeSelect(int pSwfSizeChangeSelect) {
        this.swfSizeChangeSelect_ = pSwfSizeChangeSelect;
    }

    public int getSwfStartFrame() {
        return this.swfStartFrame_;
    }

    public void setSwfStartFrame(int pSwfStartFrame) {
        this.swfStartFrame_ = pSwfStartFrame;
    }

    public int getSwfEndFrame() {
        return this.swfEndFrame_;
    }

    public void setSwfEndFrame(int pSwfEndFrame) {
        this.swfEndFrame_ = pSwfEndFrame;
    }

    public int getSwfWidth() {
        return this.swfWidth_;
    }

    public void setSwfWidth(int pSwfWidth) {
        this.swfWidth_ = pSwfWidth;
    }

    public int getSwfHeight() {
        return this.swfHeight_;
    }

    public void setSwfHeight(int pSwfHeight) {
        this.swfHeight_ = pSwfHeight;
    }

    public int getBaseVersion() {
        return this.baseVersion_;
    }

    public void setBaseVersion(int pBaseVersion) {
        this.baseVersion_ = pBaseVersion;
    }

    public int getBaseFrames() {
        return this.baseFrames_;
    }

    public void setBaseFrames(int pBaseFrames) {
        this.baseFrames_ = pBaseFrames;
    }

    public int getBaseFps() {
        return this.baseFps_;
    }

    public void setBaseFps(int pBaseFps) {
        this.baseFps_ = pBaseFps;
    }

    public int getBaseWidth() {
        return this.baseWidth_;
    }

    public void setBaseWidth(int pBaseWidth) {
        this.baseWidth_ = pBaseWidth;
    }

    public int getBaseHeight() {
        return this.baseHeight_;
    }

    public void setBaseHeight(int pBaseHeight) {
        this.baseHeight_ = pBaseHeight;
    }

    private String getOutputDirPath() {
        return this.outputDirPath_;
    }

    public boolean isOutputAutoDelete() {
        return this.isOutputAutoDelete_;
    }

    public void setOutputAutoDelete(boolean pIsOutputAutoDelete) {
        this.isOutputAutoDelete_ = pIsOutputAutoDelete;
    }

    public String getOutputSoundConfFile() {
        return this.outputSoundConfFile_;
    }

    public void setOutputSoundConfFile(String pOutputSoundConfFile) {
        this.outputSoundConfFile_ = pOutputSoundConfFile;
    }

    public SwfFile getTargetSwf() {
        return this.targetSwf_;
    }
}

