/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.io.swf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.swf2bmp2avi.io.swf.ISoundPosition;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfTag;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfTagDefineSound;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfTagDefineSprite;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfTagPlaceObject;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfTagSoundStreamHead;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfTagStartSound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLineChecker {
    private static Map<String, SwfTagDefineSprite> spriteMap_;
    private static Map<String, SwfTagDefineSound> soundMap_;
    private static Set<ISoundPosition> outableSound_;
    private ArrayList<SwfTag> targetTagList_;
    private Iterator<SwfTag> targetIte_;
    private int basedFrameCnt_;
    private int frameCnt_;
    private ArrayList<TimeLineChecker> childTimeLines;

    private TimeLineChecker(ArrayList<SwfTag> pTargetTagList, int pBasedFrameCnt) {
        this.targetTagList_ = pTargetTagList;
        this.basedFrameCnt_ = pBasedFrameCnt;
        this.frameCnt_ = 0;
        this.childTimeLines = new ArrayList();
        this.targetIte_ = this.targetTagList_.iterator();
    }

    private int getGlobalTimeCnt() {
        return this.basedFrameCnt_ + this.frameCnt_;
    }

    private void addDefineSprite(SwfTagDefineSprite pSpriteObj) {
        spriteMap_.put("" + pSpriteObj.sprite_id, pSpriteObj);
    }

    private void checkPlaceObject(SwfTagPlaceObject pSpriteObj) {
        String id = "" + pSpriteObj.charactorId;
        SwfTagDefineSprite sprite = spriteMap_.get(id);
        if (sprite == null) {
            return;
        }
        TimeLineChecker childtimeTien = new TimeLineChecker(sprite.getChildList(), this.getGlobalTimeCnt());
        this.childTimeLines.add(childtimeTien);
    }

    private void addDefineSound(SwfTagDefineSound pDefineSound) {
        soundMap_.put("" + pDefineSound.sound_id, pDefineSound);
    }

    private void checkStartSound(SwfTagStartSound pStartSound) {
        String id = "" + pStartSound.soundId;
        SwfTagDefineSound soundDef = soundMap_.get(id);
        if (soundDef == null) {
            return;
        }
        soundDef.addStartFrame(this.getGlobalTimeCnt());
        outableSound_.add(soundDef);
    }

    private boolean checkNextFrame() {
        if (this.targetIte_ == null || !this.targetIte_.hasNext()) {
            return false;
        }
        ++this.frameCnt_;
        while (this.targetIte_.hasNext()) {
            SwfTag tagObj = this.targetIte_.next();
            if (tagObj.tag == 0) {
                return false;
            }
            if (tagObj.tag == 1) break;
            if (tagObj.tag == 39) {
                this.addDefineSprite((SwfTagDefineSprite)tagObj);
                continue;
            }
            if (tagObj.tag == 4 || tagObj.tag == 26 || tagObj.tag == 70) {
                this.checkPlaceObject((SwfTagPlaceObject)tagObj);
                continue;
            }
            if (tagObj.tag == 14) {
                this.addDefineSound((SwfTagDefineSound)tagObj);
                continue;
            }
            if (tagObj.tag == 15 || tagObj.tag == 89) {
                this.checkStartSound((SwfTagStartSound)tagObj);
                continue;
            }
            if (tagObj.tag != 18 && tagObj.tag != 45) continue;
            SwfTagSoundStreamHead streamHead = (SwfTagSoundStreamHead)tagObj;
            streamHead.addStartFrame(this.getGlobalTimeCnt());
            outableSound_.add(streamHead);
        }
        int i = this.childTimeLines.size() - 1;
        while (i >= 0) {
            if (!this.childTimeLines.get(i).checkNextFrame()) {
                this.childTimeLines.remove(i);
            }
            --i;
        }
        return true;
    }

    public static Set<ISoundPosition> checkOutableSound(ArrayList<SwfTag> pTargetTagList) {
        TimeLineChecker root = new TimeLineChecker(pTargetTagList, 0);
        TimeLineChecker.initStaticCollections();
        while (root.checkNextFrame()) {
        }
        return outableSound_;
    }

    private static void initStaticCollections() {
        spriteMap_ = new HashMap<String, SwfTagDefineSprite>();
        soundMap_ = new HashMap<String, SwfTagDefineSound>();
        outableSound_ = new HashSet<ISoundPosition>();
    }
}

