/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import jp.sourceforge.swf2bmp2avi.io.BinaryFileAccess;
import jp.sourceforge.swf2bmp2avi.io.swf.ISoundPosition;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfHeader;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfRect;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfTag;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfTagDefineSound;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfTagDefineSprite;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfTagPlaceObject;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfTagShowFrame;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfTagSoundStreamBlock;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfTagSoundStreamHead;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfTagStartSound;
import jp.sourceforge.swf2bmp2avi.io.swf.TimeLineChecker;
import jp.sourceforge.swf2bmp2avi.plugin.Activator;
import jp.sourceforge.swf2bmp2avi.util.DDD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwfBinaryAccess
extends BinaryFileAccess {
    private int forceFps_ = 0;
    private int forceWidth_ = 0;
    private int forceHeight_ = 0;
    private SwfHeader header_;
    private int bodyStartPos_;
    private ArrayList<SwfTag> tagList_ = new ArrayList();
    private static ArrayList<SwfTag> globalTagList_ = new ArrayList();
    private IProgressMonitor monitor;

    public static void main(String[] pArg) {
        try {
            System.out.println("00: " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory() + " ..." + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().totalMemory() + "%");
            SwfBinaryAccess self = new SwfBinaryAccess();
            System.out.println("01: " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory() + " ..." + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().totalMemory() + "%");
            Shell shell = new Shell();
            FileDialog fd = new FileDialog(shell);
            String[] ext = new String[]{"*.swf", "*.*"};
            fd.setFilterExtensions(ext);
            System.out.println("02: " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory() + " ..." + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().totalMemory() + "%");
            String f = fd.open();
            System.gc();
            System.out.println("03: " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory() + " ..." + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().totalMemory() + "%");
            if (f != null) {
                System.out.println("04: " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory() + " ..." + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().totalMemory() + "%");
                self.read(f);
                System.gc();
                System.out.println("05: " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory() + " ..." + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().totalMemory() + "%");
                self.dbgDipsBuff();
            }
            System.out.println("06: " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory() + " ..." + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().totalMemory() + "%");
            fd = new FileDialog(shell, 8192);
            fd.setText("\u30b5\u30a6\u30f3\u30c9\u62bd\u51fa\u5148");
            fd.setFilterExtensions(ext);
            String[] ext2 = new String[]{"*.mp3;*.wav", "*.*"};
            fd.setFilterExtensions(ext2);
            f = fd.open();
            if (f != null) {
                self.setForceFps(3);
                self.writeSoundToFile(f, String.valueOf(f) + ".timeinfo.txt");
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public SwfBinaryAccess() {
        super(true);
    }

    private void log(String pMsg) {
        Activator.msg("[" + this.getClass().getSimpleName() + "]" + pMsg);
    }

    @Override
    public void dbgDipsBuff() {
        super.dbgDipsBuff();
        System.out.println("--SWF\u30d8\u30c3\u30c0\u60c5\u5831\u51fa\u529b---------------------------");
        System.out.println(this.header_.toString());
        System.out.println("TAG\u6570 = " + this.tagList_.size());
        System.out.println("--TAG\u30ea\u30b9\u30c8\u60c5\u5831---------------------------");
        this.dbgDipsTags(this.tagList_, 0);
        System.out.println("----------------------------------------");
    }

    private void dbgDipsTags(ArrayList<SwfTag> pTagList, int pDesp) {
        String headStr = "";
        int i = 0;
        while (i < pDesp) {
            headStr = String.valueOf(headStr) + "    ";
            ++i;
        }
        i = 0;
        while (i < pTagList.size()) {
            String no;
            SwfTag tagObj = pTagList.get(i);
            String tagId = "" + tagObj.tag;
            if (tagId.length() == 1) {
                tagId = " " + tagId;
            }
            if ((no = "" + i).length() == 1) {
                no = "  " + no;
            } else if (no.length() == 2) {
                no = " " + no;
            }
            String baseInfo = "[" + no + "] TAG=" + tagId + ":(" + SwfTag.getTagName(tagObj.tag) + ")\tsize = " + tagObj.dataSize;
            if (tagObj.tag == 39) {
                SwfTagDefineSprite spriteTag = (SwfTagDefineSprite)tagObj;
                System.out.println(String.valueOf(headStr) + baseInfo + " (Sprite F=" + spriteTag.frame_count + ") child=" + spriteTag.getChildTagCount());
                System.out.println(String.valueOf(headStr) + "-" + pDesp + "------------------------------------");
                this.dbgDipsTags(spriteTag.getChildList(), pDesp + 1);
                System.out.println(String.valueOf(headStr) + "-" + pDesp + "------------------------------------");
            } else if (tagObj.tag == 1) {
                SwfTagShowFrame showFrame = (SwfTagShowFrame)tagObj;
                System.out.println(String.valueOf(headStr) + baseInfo + "\t \u30d5\u30ec\u30fc\u30e0\u8868\u793a\uff1a" + showFrame.getFrameNo() + "  ... " + showFrame.getTotalIndex());
            } else if (tagObj.tag == 4 || tagObj.tag == 26 || tagObj.tag == 70) {
                SwfTagPlaceObject placeObject = (SwfTagPlaceObject)tagObj;
                System.out.println(String.valueOf(headStr) + baseInfo + "\t \u914d\u7f6e\uff1a\tcharactorId = " + placeObject.charactorId + "  ... " + placeObject.className);
            } else if (tagObj.tag == 14) {
                SwfTagDefineSound soundDefine = (SwfTagDefineSound)tagObj;
                System.out.println(String.valueOf(headStr) + "\t ===\u30b5\u30a6\u30f3\u30c9\u5b9a\u7fa9=======================================");
                System.out.println(String.valueOf(headStr) + "\t sound_id            \t:" + soundDefine.sound_id);
                System.out.println(String.valueOf(headStr) + "\t sound_format        \t:" + soundDefine.sound_format);
                System.out.println(String.valueOf(headStr) + "\t sound_rate          \t:" + soundDefine.sound_rate);
                System.out.println(String.valueOf(headStr) + "\t sound_is_16bits     \t:" + soundDefine.sound_is_16bits);
                System.out.println(String.valueOf(headStr) + "\t sound_is_stereo     \t:" + soundDefine.sound_is_stereo);
                System.out.println(String.valueOf(headStr) + "\t sound_samples_count \t:" + soundDefine.sound_samples_count);
                System.out.println(String.valueOf(headStr) + "\t ======================================================");
            } else if (tagObj.tag == 15 || tagObj.tag == 15) {
                System.out.println(String.valueOf(headStr) + baseInfo + "\t\u30b5\u30a6\u30f3\u30c9\u958b\u59cb");
            } else if (tagObj.tag == 18 || tagObj.tag == 18) {
                SwfTagSoundStreamHead streamHead = (SwfTagSoundStreamHead)tagObj;
                System.out.println(String.valueOf(headStr) + baseInfo);
                System.out.println(String.valueOf(headStr) + "\t ===\u30b9\u30c8\u30ea\u30fc\u30e0\u30b5\u30a6\u30f3\u30c9\u30d8\u30c3\u30c0\u60c5\u5831=======================");
                System.out.println(String.valueOf(headStr) + "\t reserved       \t:" + streamHead.reserved);
                System.out.println(String.valueOf(headStr) + "\t playbackRate   \t:" + streamHead.playbackRate);
                System.out.println(String.valueOf(headStr) + "\t playbackSize   \t:" + streamHead.playbackSize);
                System.out.println(String.valueOf(headStr) + "\t playbackStereo \t:" + streamHead.playbackStereo);
                System.out.println(String.valueOf(headStr) + "\t format         \t:" + streamHead.format);
                System.out.println(String.valueOf(headStr) + "\t soundRate      \t:" + streamHead.soundRate);
                System.out.println(String.valueOf(headStr) + "\t soundSize      \t:" + streamHead.soundSize);
                System.out.println(String.valueOf(headStr) + "\t soundStereo    \t:" + streamHead.soundStereo);
                System.out.println(String.valueOf(headStr) + "\t sampleSize     \t:" + streamHead.sampleSize);
                System.out.println(String.valueOf(headStr) + "\t latencySeek    \t:" + streamHead.latencySeek);
                System.out.println(String.valueOf(headStr) + "\t ======================================================");
            } else if (tagObj.tag == 19) {
                System.out.println(String.valueOf(headStr) + baseInfo + "\t\u30b9\u30c8\u30ea\u30fc\u30e0\u30b5\u30a6\u30f3\u30c9\u30c7\u30fc\u30bf");
            } else {
                System.out.println(String.valueOf(headStr) + baseInfo);
            }
            ++i;
        }
    }

    public void setProgressMonitor(IProgressMonitor pMonitor) {
        this.monitor = pMonitor;
    }

    private void progresBeginTask(String pTaskMsg, int pTotalWorks) {
        if (this.monitor != null) {
            this.monitor.beginTask(pTaskMsg, pTotalWorks);
        }
    }

    private void progressWorked(int pWork) {
        if (this.monitor != null) {
            this.monitor.worked(pWork);
        }
    }

    private void progressSubTask(String pTaskMsg) {
        if (this.monitor != null) {
            this.monitor.subTask(pTaskMsg);
        }
    }

    private void progressDone() {
        if (this.monitor != null) {
            this.monitor.done();
        }
    }

    @Override
    public void read(String pFileName) throws IOException {
        this.log("SWF\u8aad\u8fbc\u307f\u958b\u59cb:" + pFileName);
        super.read(pFileName);
        globalTagList_.clear();
        this.log("super.read(pFileName)\uff1a\u5b8c\u4e86");
        this.clear();
        this.header_ = this.readSwfHeader();
        this.log("\u30d5\u30a1\u30a4\u30eb\u30d8\u30c3\u30c0\u90e8\u5206\u306e\u8aad\u307f\u53d6\u308a\uff1a\u5b8c\u4e86");
        this.bodyStartPos_ = this.position();
        this.log("\u30dc\u30c7\u30a3\u958b\u59cb\u4f4d\u7f6e\u3092\u8a18\u9332\uff1a\u5b8c\u4e86");
        int showFrameIdx = 1;
        int i = 0;
        while (this.position() < this.limit()) {
            this.log("\u30bf\u30b0\u89e3\u6790\u4e2d\uff1a" + i);
            SwfTag tagObj = this.readSwfTagHeader();
            tagObj = this.checkTagDetail(tagObj);
            if (tagObj.tag == 1) {
                ((SwfTagShowFrame)tagObj).setFrameNo(showFrameIdx++);
            }
            this.tagList_.add(tagObj);
            globalTagList_.add(tagObj);
            if (tagObj.tag == 0 || tagObj.dataPosition + tagObj.dataSize > this.limit()) break;
            this.position(tagObj.dataPosition + tagObj.dataSize);
            ++i;
        }
        this.log("SWF\u8aad\u8fbc\u307f\u7d42\u4e86:");
    }

    private SwfTag checkTagDetail(SwfTag pSwfTag) {
        if (pSwfTag.tag == 39) {
            return this.createDefineSprite(pSwfTag);
        }
        if (pSwfTag.tag == 1) {
            SwfTagShowFrame showFrame = new SwfTagShowFrame(pSwfTag);
            return showFrame;
        }
        if (pSwfTag.tag == 4) {
            SwfTagPlaceObject placeObject = new SwfTagPlaceObject(pSwfTag);
            placeObject.charactorId = this.getShort();
            placeObject.depth = this.getShort();
            return placeObject;
        }
        if (pSwfTag.tag == 26) {
            SwfTagPlaceObject placeObject2 = new SwfTagPlaceObject(pSwfTag);
            byte flg = this.get();
            placeObject2.depth = this.getShort();
            if ((flg & 2) == 2) {
                placeObject2.charactorId = this.getShort();
            }
            return placeObject2;
        }
        if (pSwfTag.tag == 70) {
            SwfTagPlaceObject placeObject3 = new SwfTagPlaceObject(pSwfTag);
            byte flg1 = this.get();
            byte flg2 = this.get();
            placeObject3.depth = this.getShort();
            if ((flg2 & 8) > 0 || (flg2 & 0x10) > 0 && (flg1 & 2) > 0) {
                placeObject3.className = this.getBufString();
            }
            if ((flg1 & 2) == 2) {
                placeObject3.charactorId = this.getShort();
            }
            return placeObject3;
        }
        if (pSwfTag.tag == 14) {
            SwfTagDefineSound definSoundTag = new SwfTagDefineSound(pSwfTag);
            definSoundTag.sound_id = this.getShort();
            byte flg = this.get();
            definSoundTag.sound_format = flg >>> 4 & 0xF;
            definSoundTag.sound_rate = flg >>> 2 & 3;
            definSoundTag.sound_is_16bits = flg >>> 1 & 1;
            definSoundTag.sound_is_stereo = flg & 1;
            definSoundTag.sound_samples_count = this.getInt();
            definSoundTag.soundDataStartPos = this.position();
            return definSoundTag;
        }
        if (pSwfTag.tag == 15 || pSwfTag.tag == 89) {
            SwfTagStartSound startSound = new SwfTagStartSound(pSwfTag);
            startSound.soundId = this.getShort();
            byte flg = this.get();
            startSound.soundInfo.reserved = flg >>> 6 & 3;
            startSound.soundInfo.syncStop = flg >>> 5 & 1;
            startSound.soundInfo.syncNoMultiple = flg >>> 4 & 1;
            startSound.soundInfo.hasEnvelope = flg >>> 3 & 1;
            startSound.soundInfo.hasLoops = flg >>> 2 & 1;
            startSound.soundInfo.hasOutPoint = flg >>> 1 & 1;
            startSound.soundInfo.hasInPoint = flg & 1;
            if (startSound.soundInfo.hasInPoint == 1) {
                startSound.soundInfo.inPoint = this.getInt();
            }
            if (startSound.soundInfo.hasOutPoint == 1) {
                startSound.soundInfo.outPoint = this.getInt();
            }
            if (startSound.soundInfo.hasLoops == 1) {
                startSound.soundInfo.loopCount = this.getShort();
            }
            if (startSound.soundInfo.hasEnvelope == 1) {
                startSound.soundInfo.envPoints = this.get();
            }
            return startSound;
        }
        if (pSwfTag.tag == 18 || pSwfTag.tag == 18) {
            SwfTagSoundStreamHead soundStreamHead = new SwfTagSoundStreamHead(pSwfTag);
            byte flg = this.get();
            soundStreamHead.reserved = flg >>> 4 & 0xF;
            soundStreamHead.playbackRate = flg >>> 2 & 3;
            soundStreamHead.playbackSize = flg >>> 1 & 1;
            soundStreamHead.playbackStereo = flg & 1;
            flg = this.get();
            soundStreamHead.format = flg >>> 4 & 0xF;
            soundStreamHead.soundRate = flg >>> 2 & 3;
            soundStreamHead.soundSize = flg >>> 1 & 1;
            soundStreamHead.soundStereo = flg & 1;
            soundStreamHead.sampleSize = this.getShort();
            if (soundStreamHead.format == 2) {
                soundStreamHead.latencySeek = this.getShort();
            }
            return soundStreamHead;
        }
        if (pSwfTag.tag == 19) {
            SwfTagSoundStreamBlock saoundStreamBlock = new SwfTagSoundStreamBlock(pSwfTag);
            return saoundStreamBlock;
        }
        return pSwfTag;
    }

    private SwfTagDefineSprite createDefineSprite(SwfTag pSwfTag) {
        SwfTagDefineSprite spriteTag = new SwfTagDefineSprite(pSwfTag);
        spriteTag.sprite_id = this.getShort();
        spriteTag.frame_count = this.getShort();
        int showFrameIdx = 1;
        int i = 0;
        while (this.position() < this.limit()) {
            SwfTag childTag = this.readSwfTagHeader();
            childTag = this.checkTagDetail(childTag);
            if (childTag.tag == 1) {
                ((SwfTagShowFrame)childTag).setFrameNo(showFrameIdx++);
                ((SwfTagShowFrame)childTag).setParentSprite(spriteTag);
            }
            spriteTag.addChildTag(childTag);
            globalTagList_.add(childTag);
            if (childTag.tag == 0) break;
            this.position(childTag.dataPosition + childTag.dataSize);
            ++i;
        }
        return spriteTag;
    }

    private SwfHeader readSwfHeader() throws IOException {
        SwfHeader swfHeader = new SwfHeader();
        swfHeader.signature_ = new byte[3];
        swfHeader.signature_[0] = this.get();
        swfHeader.signature_[1] = this.get();
        swfHeader.signature_[2] = this.get();
        swfHeader.version_ = this.get();
        swfHeader.fileLength_ = this.getInt();
        if (swfHeader.signature_[0] == 67) {
            this.uncompress(8, this.limit() - 8);
            this.position(8);
        }
        swfHeader.frameSize_ = this.getSwfRect();
        swfHeader.frameRate_point_ = this.get();
        swfHeader.frameRate_dec_ = this.get();
        swfHeader.frameCount_ = this.getShort();
        return swfHeader;
    }

    private void uncompress(int pFrom, int pSize) throws IOException {
        this.log("SWF\u89e3\u51cd\u958b\u59cb");
        byte[] headerArea = new byte[pFrom];
        this.buffer_.position(0);
        this.buffer_.get(headerArea);
        this.log("from\u4f4d\u7f6e\u4ee5\u524d\u306e\u30b3\u30d4\u30fc:\u7d42\u4e86");
        byte[] tmpBuff = new byte[pSize];
        this.buffer_.position(pFrom);
        this.buffer_.get(tmpBuff);
        this.log("From\u4f4d\u7f6e\u304b\u3089size\u306e\u30c7\u30fc\u30bf\u30b3\u30d4\u30fc:\u7d42\u4e86");
        Inflater unzipIn = new Inflater();
        unzipIn.reset();
        unzipIn.setInput(tmpBuff);
        this.log("\u89e3\u51cd\u76f4\u524d");
        DDD.startTime("\u89e3\u51cd\u958b\u59cb");
        ByteArrayOutputStream unzipOut = new ByteArrayOutputStream(4096);
        byte[] result = new byte[4096];
        while (!unzipIn.finished()) {
            int resultLength;
            try {
                resultLength = unzipIn.inflate(result);
            }
            catch (DataFormatException e) {
                e.printStackTrace();
                throw new IOException(e.getLocalizedMessage());
            }
            unzipOut.write(result, 0, resultLength);
        }
        unzipIn.end();
        this.log("\u89e3\u51cd\u76f4\u5f8c");
        DDD.checkTime("\u89e3\u51cd\u7d50\u679c\u3092ByteArrayOutputStream\u306b\u9806\u6b21\u683c\u7d0d:\u7d42\u4e86");
        byte[] outBytes = unzipOut.toByteArray();
        int size = pFrom + outBytes.length;
        ByteBuffer newBuff = ByteBuffer.allocate(size);
        newBuff.put(headerArea);
        newBuff.put(outBytes, 0, outBytes.length - 0);
        newBuff.position(0);
        newBuff.put(0, (byte)70);
        newBuff.position(0);
        newBuff.order(this.buffer_.order());
        this.buffer_ = newBuff;
        DDD.checkTime("SWF\u89e3\u51cd\u5b8c\u4e86");
    }

    private SwfTag readSwfTagHeader() {
        SwfTag tagHeaader = new SwfTag();
        tagHeaader.position = this.position();
        int dat = this.getShort() & 0xFFFF;
        tagHeaader.tag = dat >>> 6;
        tagHeaader.dataSize = dat & 0x3F;
        tagHeaader.dataPosition = this.position();
        if (tagHeaader.dataSize == 63) {
            tagHeaader.isLongType = true;
            tagHeaader.dataSize = this.getInt();
            tagHeaader.dataPosition = this.position();
        }
        return tagHeaader;
    }

    protected SwfRect getSwfRect() throws IOException {
        byte head = this.get();
        int bitSize = head >>> 3 & 0x1F;
        int allSize = bitSize * 4;
        int needLoadCount = (allSize - 3) / 8 + 1;
        byte[] buff = new byte[needLoadCount];
        int i = 0;
        while (i < needLoadCount) {
            buff[i] = this.get();
            ++i;
        }
        int[] datAry = new int[4];
        int datAryIdx = 0;
        int bitCnt = 3;
        int work = head & 7;
        int i2 = 0;
        while (i2 < buff.length) {
            if (bitCnt < bitSize) {
                work = work << 8 | buff[i2] & 0xFF;
                bitCnt += 8;
            }
            if (bitCnt >= bitSize) {
                datAry[datAryIdx] = work >>> (bitCnt -= bitSize);
                work -= datAry[datAryIdx] << bitCnt;
                ++datAryIdx;
            }
            ++i2;
        }
        SwfRect rect = new SwfRect();
        rect.Nbits = bitSize;
        rect.Xmin = datAry[0];
        rect.Xmax = datAry[1];
        rect.Ymin = datAry[2];
        rect.Ymax = datAry[3];
        rect.allBuff = new byte[buff.length + 1];
        rect.allBuff[0] = head;
        int i3 = 0;
        while (i3 < buff.length) {
            rect.allBuff[i3 + 1] = buff[i3];
            ++i3;
        }
        return rect;
    }

    public boolean writeWithoutSoundStreamData(String pFileName) {
        block15: {
            FileOutputStream stream = null;
            try {
                try {
                    stream = new FileOutputStream(pFileName);
                    FileChannel channel = stream.getChannel();
                    ByteBuffer swfHead = this.slice(0, this.bodyStartPos_);
                    if (this.forceFps_ > 0) {
                        swfHead.put(this.bodyStartPos_ - 3, (byte)this.forceFps_);
                    }
                    channel.write(swfHead);
                    this.writeTagListWithoutSound(channel, this.tagList_);
                    int fileLength = (int)channel.position();
                    swfHead.position(5);
                    swfHead.putInt(5, fileLength);
                    swfHead.limit(9);
                    channel.position(5L);
                    channel.write(swfHead, 4L);
                    channel.position(fileLength);
                    channel.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.clear();
        return true;
    }

    public void writeTagListWithoutSound(FileChannel channel, ArrayList<SwfTag> pTagList) throws IOException {
        System.out.println("\u30b9\u30d7\u30e9\u30a4\u30c8\u5185\u30bf\u30b0\u30ea\u30b9\u30c8\u958b\u59cb write pos=" + channel.position() + " write size = " + channel.size() + "    list count =" + pTagList.size() + " ");
        ByteBuffer wb = null;
        int i = 0;
        while (i < pTagList.size()) {
            SwfTag tagObj = pTagList.get(i);
            if (SwfTag.isAboutSoundTag(tagObj.tag)) {
                System.out.println("\u30c7\u30fc\u30bf\u7cfb\u30bf\u30b0\u9664\u5916\uff1a" + tagObj.tag);
            } else {
                int tagHeadSize = 2;
                if (tagObj.isLongType) {
                    tagHeadSize += 4;
                }
                long wraitePosTagHead = channel.position();
                wb = this.slice(tagObj.position, tagHeadSize);
                channel.write(wb);
                if (tagObj.tag == 39) {
                    long beforePose = channel.position();
                    wb = this.slice(tagObj.dataPosition, 4);
                    channel.write(wb);
                    ArrayList<SwfTag> childList = ((SwfTagDefineSprite)tagObj).getChildList();
                    this.writeTagListWithoutSound(channel, childList);
                    int writeSize = (int)(channel.position() - beforePose);
                    System.out.println("\u66f8\u304d\u63db\u3048\u30b5\u30a4\u30ba\uff1a" + channel.position() + " - " + beforePose + " ==> " + writeSize);
                    long currentPos = channel.position();
                    wb = this.slice(tagObj.position, tagHeadSize);
                    if (tagObj.isLongType) {
                        wb.putInt(2, writeSize);
                        System.out.println("\u62e1\u5f35\u30b5\u30a4\u30ba\u66f8\u304d\u63db\u3048\uff1a" + tagObj.dataSize + "\u2192" + writeSize);
                    } else {
                        short val = (short)(tagObj.tag << 6 & (writeSize & 0x3F));
                        wb.putShort(0, val);
                        System.out.println("\u6a19\u6e96\u30b5\u30a4\u30ba\u66f8\u304d\u63db\u3048\uff1a" + tagObj.dataSize + "\u2192" + writeSize + "  TagHead= =" + val);
                    }
                    wb.position(0);
                    channel.position(tagObj.position);
                    channel.write(wb, wraitePosTagHead);
                    channel.position(currentPos);
                } else {
                    wb = this.slice(tagObj.dataPosition, tagObj.dataSize);
                    channel.write(wb);
                    System.out.println("......\u305d\u306e\u307e\u307e\u51fa\u529b tag=" + tagObj.tag + " WRITE pos=" + channel.position() + " WRITE size=" + channel.size());
                }
            }
            ++i;
        }
        System.out.println("\u30b9\u30d7\u30e9\u30a4\u30c8\u5185\u30bf\u30b0\u30ea\u30b9\u30c8\u7d42\u4e86 write pos=" + channel.position() + " write size = " + channel.size());
    }

    public static String createTempNoSoundSwf(String pBaseSwfName, int pFps, File pTmpDir) throws IOException {
        SwfBinaryAccess swf = new SwfBinaryAccess();
        swf.read(pBaseSwfName);
        System.out.println("\u4e00\u6642\uff1a" + pTmpDir);
        File tmpFile = File.createTempFile("s2b2atmp_", "swf", pTmpDir);
        tmpFile.deleteOnExit();
        System.out.println("\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\uff1a" + tmpFile.getAbsolutePath());
        swf.setForceFps(pFps);
        swf.writeWithoutSoundStreamData(tmpFile.getAbsolutePath());
        return tmpFile.getAbsolutePath();
    }

    public void writeSoundToFile(String pBaseName, String pTimeInfoFileName) throws IOException {
        String baseName = pBaseName;
        if (baseName.toLowerCase().endsWith(".mp3") || baseName.toLowerCase().endsWith(".wav")) {
            baseName = baseName.substring(0, baseName.length() - 4);
        }
        this.progresBeginTask("\u97f3\u58f0\u30c7\u30fc\u30bf\u62bd\u51fa\u4e2d", globalTagList_.size() + 3);
        this.nestedWriteSoundFile(this.tagList_, baseName);
        this.writeSoundStartTimeInfo(this.tagList_, pTimeInfoFileName);
        this.progressSubTask("\u3067\u3051\u305f\uff3c(^o^)\uff0f");
        this.progressWorked(1);
        this.progressDone();
    }

    private void nestedWriteSoundFile(ArrayList<SwfTag> ptagList, String pBaseName) throws IOException {
        Iterator<SwfTag> ite = ptagList.iterator();
        FileOutputStream stream = null;
        AbstractInterruptibleChannel channel = null;
        int outputCnt = 0;
        try {
            try {
                int i = 0;
                while (ite.hasNext()) {
                    SwfTag tagObj = ite.next();
                    this.progressWorked(1);
                    this.progressSubTask(SwfTag.getTagName(tagObj.tag));
                    if (tagObj.tag == 14) {
                        this.writeDefineSoundToFile((SwfTagDefineSound)tagObj, pBaseName, outputCnt++);
                    } else if (tagObj.tag != 15 && tagObj.tag != 89) {
                        if (tagObj.tag == 18 || tagObj.tag == 45) {
                            if (stream != null) {
                                channel.close();
                                channel = null;
                                stream.close();
                                stream = null;
                            }
                            SwfTagSoundStreamHead streamHead = (SwfTagSoundStreamHead)tagObj;
                            String extStr = ".wav";
                            if (streamHead.format == 2) {
                                extStr = ".mp3";
                            }
                            String fileName = String.valueOf(pBaseName) + "_ss_" + outputCnt++ + extStr;
                            streamHead.setOutputFileName(fileName);
                            System.out.println("\u30b9\u30c8\u30ea\u30fc\u30e0\u30b5\u30a6\u30f3\u30c9 = " + fileName);
                            stream = new FileOutputStream(fileName);
                            channel = stream.getChannel();
                            ByteBuffer mp3Head = this.createMp3FileHeader();
                            ((FileChannel)channel).write(mp3Head);
                        } else if (tagObj.tag == 19) {
                            if (channel != null) {
                                ByteBuffer wb = this.slice(tagObj.dataPosition + 4, tagObj.dataSize - 4);
                                ((FileChannel)channel).write(wb);
                            }
                        } else if (tagObj.tag == 39) {
                            ArrayList<SwfTag> subTagList = ((SwfTagDefineSprite)tagObj).getChildList();
                            this.nestedWriteSoundFile(subTagList, String.valueOf(pBaseName) + "_SP" + i);
                        }
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (channel != null) {
                channel.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    private String writeDefineSoundToFile(SwfTagDefineSound pDefineSound, String pBaseName, int pOutputCnt) throws IOException {
        String extStr = ".wav";
        if (pDefineSound.sound_format == 2) {
            extStr = ".mp3";
        }
        String fileName = String.valueOf(pBaseName) + "_sd_" + pOutputCnt + extStr;
        pDefineSound.setOutputFileName(fileName);
        System.out.println("DefineSound\u304b\u3089\u306e\u51fa\u529b = " + fileName);
        int dataStartPos = pDefineSound.soundDataStartPos;
        int dataSize = pDefineSound.getSoundDataSiz();
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(fileName);
            FileChannel channel = stream.getChannel();
            if (pDefineSound.sound_format == 2) {
                ByteBuffer mp3Head = this.createMp3FileHeader();
                channel.write(mp3Head);
                dataStartPos += 2;
                dataSize -= 2;
            } else {
                ByteBuffer waveHead = this.createWavFileHeader(pDefineSound);
                channel.write(waveHead);
            }
            ByteBuffer wb = this.slice(dataStartPos, dataSize);
            channel.write(wb);
            channel.close();
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return fileName;
    }

    private ByteBuffer createWavFileHeader(SwfTagDefineSound pDefineSound) {
        ByteBuffer waveHead = ByteBuffer.allocate(44);
        waveHead.order(ByteOrder.LITTLE_ENDIAN);
        waveHead.put((byte)82);
        waveHead.put((byte)73);
        waveHead.put((byte)70);
        waveHead.put((byte)70);
        waveHead.putInt(36 + pDefineSound.getSoundDataSiz());
        waveHead.put((byte)87);
        waveHead.put((byte)65);
        waveHead.put((byte)86);
        waveHead.put((byte)69);
        waveHead.put((byte)102);
        waveHead.put((byte)109);
        waveHead.put((byte)116);
        waveHead.put((byte)32);
        waveHead.putInt(16);
        waveHead.putShort((short)1);
        if (pDefineSound.isStereo()) {
            waveHead.putShort((short)2);
        } else {
            waveHead.putShort((short)1);
        }
        waveHead.putInt(pDefineSound.getSampleRateValue());
        waveHead.putInt(pDefineSound.getDataTransRate());
        waveHead.putShort((short)4);
        if (pDefineSound.is16bits()) {
            waveHead.putShort((short)16);
        } else {
            waveHead.putShort((short)8);
        }
        waveHead.put((byte)100);
        waveHead.put((byte)97);
        waveHead.put((byte)116);
        waveHead.put((byte)97);
        waveHead.putInt(pDefineSound.getSoundDataSiz());
        waveHead.clear();
        return waveHead;
    }

    private ByteBuffer createMp3FileHeader() {
        ByteBuffer mp3Head = ByteBuffer.allocate(10);
        mp3Head.put((byte)73);
        mp3Head.put((byte)68);
        mp3Head.put((byte)51);
        mp3Head.put((byte)3);
        mp3Head.put((byte)0);
        mp3Head.put((byte)0);
        mp3Head.put((byte)0);
        mp3Head.put((byte)0);
        mp3Head.put((byte)0);
        mp3Head.put((byte)0);
        mp3Head.clear();
        DDD.dumpHex(mp3Head.array());
        return mp3Head;
    }

    private void writeSoundStartTimeInfo(ArrayList<SwfTag> ptagList, String pInfoFileName) throws IOException {
        block11: {
            this.progressWorked(1);
            this.progressSubTask("\u958b\u59cb\u4f4d\u7f6e\u89e3\u6790\u4e2d");
            System.out.println("\u30b5\u30a6\u30f3\u30c9\u51fa\u529b\u306e\u958b\u59cb\u6642\u9593\u89e3\u6790...\u958b\u59cb");
            Set<ISoundPosition> soundTagSet = TimeLineChecker.checkOutableSound(ptagList);
            if (soundTagSet.isEmpty()) {
                System.out.println("\u30b5\u30a6\u30f3\u30c9\u51fa\u529b\u306e\u958b\u59cb\u6642\u9593\u89e3\u6790\u7d50\u679c\uff65\uff65\uff65\u306a\u3057");
                this.progressSubTask("\u958b\u59cb\u4f4d\u7f6e\u89e3\u6790\u4e2d...\u5bfe\u8c61\u306a\u3057");
                return;
            }
            this.progressWorked(1);
            this.progressSubTask("\u89e3\u6790\u7d50\u679c\u51fa\u529b\u4e2d");
            FileWriter fw = null;
            try {
                try {
                    fw = new FileWriter(pInfoFileName);
                    for (ISoundPosition soundPos : soundTagSet) {
                        String filePath = soundPos.getOutputFileName();
                        Set<Integer> positions = soundPos.getStartFramePossions();
                        Integer[] posAry = positions.toArray(new Integer[0]);
                        if (posAry == null || posAry.length == 0) {
                            System.out.println("\u30b5\u30a6\u30f3\u30c9\u30dd\u30b8\u30b7\u30e7\u30f3\u60c5\u5831\u306a\u3057\uff1a" + filePath);
                            continue;
                        }
                        int fastPos = posAry[0];
                        fw.write(fastPos + "," + filePath + "\n");
                    }
                    fw.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    if (fw != null) {
                        fw.close();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (fw != null) {
                    fw.close();
                }
                throw throwable;
            }
            if (fw != null) {
                fw.close();
            }
        }
        this.progressWorked(1);
        this.progressSubTask("\u89e3\u6790\u7d50\u679c\u51fa\u529b\u7d42\u4e86");
        System.out.println("\u30b5\u30a6\u30f3\u30c9\u51fa\u529b\u306e\u958b\u59cb\u6642\u9593\u89e3\u6790...\u7d42\u4e86");
    }

    public int getSwfVersion() {
        assert (this.header_ != null);
        if (this.header_ == null) {
            throw new RuntimeException();
        }
        return this.header_.version_;
    }

    public int getSwfFps() {
        assert (this.header_ != null);
        if (this.header_ == null) {
            throw new RuntimeException();
        }
        return this.header_.frameRate_dec_;
    }

    public int getSwfFrameCount() {
        assert (this.header_ != null);
        if (this.header_ == null) {
            throw new RuntimeException();
        }
        return this.header_.frameCount_;
    }

    public int getSwfWidth() {
        assert (this.header_ != null);
        if (this.header_ == null) {
            throw new RuntimeException();
        }
        return this.header_.getMaxWidthPix();
    }

    public int getSwfHeight() {
        assert (this.header_ != null);
        if (this.header_ == null) {
            throw new RuntimeException();
        }
        return this.header_.getMaxHeightPix();
    }

    public int getForceFps() {
        return this.forceFps_;
    }

    public void setForceFps(int pForceFps) {
        this.forceFps_ = pForceFps;
    }

    public int getForceWidth() {
        return this.forceWidth_;
    }

    public void setForceWidth(int pForceWidth) {
        this.forceWidth_ = pForceWidth;
    }

    public int getForceHeight() {
        return this.forceHeight_;
    }

    public void setForceHeight(int pForceHeight) {
        this.forceHeight_ = pForceHeight;
    }
}

