/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

abstract class SimpleEUCDecoder
extends CharsetDecoder {
    private final int G0 = 0;
    private final int G1 = 1;
    private final int SS2 = 142;
    private final int SS3 = 143;
    private int firstByte;
    private int state = 0;
    protected static String mappingTableG1;
    protected static String byteToCharTable;

    protected SimpleEUCDecoder(Charset charset) {
        super(charset, 0.5f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        assert (n <= n2);
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        assert (n3 <= n4);
        n3 = n3 <= n4 ? n3 : n4;
        int n5 = 1;
        try {
            for (n = n <= n2 ? n : n2; n < n2; ++n) {
                n5 = 1;
                int n6 = 65533;
                int n7 = byArray[n];
                if (n7 < 0) {
                    n7 += 256;
                }
                switch (this.state) {
                    case 0: {
                        if (n7 == 142 || n7 == 143) {
                            CoderResult.malformedForLength(1);
                        }
                        if (n7 <= 159) {
                            n6 = byteToCharTable.charAt(n7);
                            break;
                        }
                        if (n7 < 161 || n7 > 254) {
                            CoderResult.malformedForLength(1);
                            break;
                        }
                        this.firstByte = n7;
                        this.state = 1;
                        break;
                    }
                    case 1: {
                        this.state = 0;
                        if (n7 < 161 || n7 > 254) {
                            CoderResult.malformedForLength(2);
                        }
                        n6 = mappingTableG1.charAt((this.firstByte - 161) * 94 + n7 - 161);
                        n5 = 2;
                    }
                }
                if (this.state != 0) continue;
                if (n6 == 65533) {
                    CoderResult coderResult = CoderResult.unmappableForLength(n5);
                    return coderResult;
                }
                if (n4 - n3 < 1) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                cArray[n3++] = n6;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n - byteBuffer.arrayOffset());
            charBuffer.position(n3 - charBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        int n2 = 0;
        try {
            while (byteBuffer.hasRemaining()) {
                char c = '\ufffd';
                byte by = byteBuffer.get();
                if (by < 0) {
                    by = (byte)(by + 256);
                }
                n2 = 1;
                switch (this.state) {
                    case 0: {
                        if (by == 142 || by == 143) {
                            CoderResult.malformedForLength(n2);
                        }
                        if (by <= 159) {
                            c = byteToCharTable.charAt(by);
                            break;
                        }
                        if (by < 161 || by > 254) {
                            CoderResult.malformedForLength(1);
                            break;
                        }
                        this.firstByte = by;
                        this.state = 1;
                        break;
                    }
                    case 1: {
                        this.state = 0;
                        if (by < 161 || by > 254) {
                            CoderResult.malformedForLength(2);
                        }
                        c = mappingTableG1.charAt((this.firstByte - 161) * 94 + by - 161);
                        n2 = 2;
                        break;
                    }
                }
                if (this.state != 0) continue;
                if (c == '\ufffd') {
                    CoderResult coderResult = CoderResult.unmappableForLength(n2);
                    return coderResult;
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                ++n;
                charBuffer.put(c);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

