/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.WindowsFlags;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.awt.image.WritableRasterNative;
import sun.awt.windows.D3DBlitLoops;
import sun.awt.windows.Win32BlitLoops;
import sun.awt.windows.Win32D3DRenderer;
import sun.awt.windows.Win32DDRenderer;
import sun.awt.windows.Win32ScaleLoops;
import sun.awt.windows.Win32SurfaceData;
import sun.awt.windows.WinCachingSurfaceManager;
import sun.awt.windows.WinVolatileSurfaceManager;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.PixelToShapeConverter;

public class Win32OffScreenSurfaceData
extends SurfaceData {
    private int width;
    private int height;
    private int transparency;
    private GraphicsConfiguration graphicsConfig;
    private Image image;
    private RenderLoops solidloops;
    private boolean localD3dEnabled = true;
    protected boolean d3dClippingEnabled = false;
    private boolean ddSurfacePunted = false;
    protected static Win32D3DRenderer d3dNoClipPipe;
    protected static Win32D3DRenderer d3dClipPipe;
    protected static Win32DDRenderer ddPipe;
    protected static PixelToShapeConverter d3dTxNoClipPipe;
    protected static PixelToShapeConverter d3dTxClipPipe;
    protected static PixelToShapeConverter ddTxPipe;
    protected Win32D3DRenderer d3dPipe = null;
    protected PixelToShapeConverter d3dTxPipe = null;
    private WritableRasterNative wrn = null;

    private static native void initIDs();

    public static SurfaceType getSurfaceType(ColorModel colorModel, int n) {
        if (n == 3) {
            if (colorModel.getPixelSize() == 16) {
                return Win32SurfaceData.Ushort4444ArgbD3D;
            }
            return Win32SurfaceData.IntArgbD3D;
        }
        boolean bl = n == 2;
        switch (colorModel.getPixelSize()) {
            case 24: 
            case 32: {
                if (colorModel instanceof DirectColorModel) {
                    if (((DirectColorModel)colorModel).getRedMask() == 0xFF0000) {
                        return bl ? Win32SurfaceData.IntRgbDD_BM : Win32SurfaceData.IntRgbD3D;
                    }
                    return bl ? Win32SurfaceData.IntRgbxDD_BM : Win32SurfaceData.IntRgbxD3D;
                }
                return bl ? Win32SurfaceData.ThreeByteBgrDD_BM : Win32SurfaceData.ThreeByteBgrD3D;
            }
            case 15: {
                return bl ? Win32SurfaceData.Ushort555RgbDD_BM : Win32SurfaceData.Ushort555RgbD3D;
            }
            case 16: {
                if (colorModel instanceof DirectColorModel && ((DirectColorModel)colorModel).getBlueMask() == 62) {
                    return bl ? Win32SurfaceData.Ushort555RgbxDD_BM : Win32SurfaceData.Ushort555RgbxD3D;
                }
                return bl ? Win32SurfaceData.Ushort565RgbDD_BM : Win32SurfaceData.Ushort565RgbD3D;
            }
            case 8: {
                if (colorModel.getColorSpace().getType() == 6 && colorModel instanceof ComponentColorModel) {
                    return bl ? Win32SurfaceData.ByteGrayDD_BM : Win32SurfaceData.ByteGrayDD;
                }
                if (colorModel instanceof IndexColorModel && Win32OffScreenSurfaceData.isOpaqueGray((IndexColorModel)colorModel)) {
                    return bl ? Win32SurfaceData.Index8GrayDD_BM : Win32SurfaceData.Index8GrayDD;
                }
                return bl ? Win32SurfaceData.ByteIndexedDD_BM : Win32SurfaceData.ByteIndexedOpaqueDD;
            }
        }
        throw new InvalidPipeException("Unsupported bit depth: " + colorModel.getPixelSize());
    }

    public static Win32OffScreenSurfaceData createData(int n, int n2, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Image image, int n3) {
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)graphicsConfiguration.getDevice();
        if (!win32GraphicsDevice.isOffscreenAccelerationEnabled() || n3 == 3 && !win32GraphicsDevice.isD3DEnabledOnDevice()) {
            return null;
        }
        return new Win32OffScreenSurfaceData(n, n2, Win32OffScreenSurfaceData.getSurfaceType(colorModel, n3), colorModel, graphicsConfiguration, image, n3, win32GraphicsDevice.getScreen());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void validatePipe(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.antialiasHint != 2) {
            if (sunGraphics2D.paintState == 0) {
                if (sunGraphics2D.compositeState == 0) {
                    if (sunGraphics2D.clipState != 2 && this.transparency != 3) {
                        Win32DDRenderer win32DDRenderer;
                        PixelToShapeConverter pixelToShapeConverter;
                        if (WindowsFlags.isD3DEnabled() && this.localD3dEnabled) {
                            pixelToShapeConverter = this.d3dTxPipe;
                            win32DDRenderer = this.d3dPipe;
                        } else {
                            pixelToShapeConverter = ddTxPipe;
                            win32DDRenderer = ddPipe;
                        }
                        sunGraphics2D.imagepipe = imagepipe;
                        if (sunGraphics2D.transformState >= 3) {
                            sunGraphics2D.drawpipe = pixelToShapeConverter;
                            sunGraphics2D.fillpipe = pixelToShapeConverter;
                        } else if (sunGraphics2D.strokeState != 0) {
                            sunGraphics2D.drawpipe = pixelToShapeConverter;
                            sunGraphics2D.fillpipe = win32DDRenderer;
                        } else {
                            sunGraphics2D.drawpipe = win32DDRenderer;
                            sunGraphics2D.fillpipe = win32DDRenderer;
                        }
                        sunGraphics2D.shapepipe = win32DDRenderer;
                        sunGraphics2D.textpipe = sunGraphics2D.textAntialiasHint == 2 ? aaTextRenderer : solidTextRenderer;
                        sunGraphics2D.loops = this.solidloops;
                        return;
                    }
                }
            }
        }
        super.validatePipe(sunGraphics2D);
    }

    public void disableD3D() {
        this.localD3dEnabled = false;
    }

    public static boolean isDDScaleEnabled() {
        return WindowsFlags.isDDScaleEnabled();
    }

    public synchronized Raster getRaster(int n, int n2, int n3, int n4) {
        if (this.wrn == null) {
            this.wrn = WritableRasterNative.createNativeRaster(this.getColorModel(), this, this.width, this.height);
            if (this.wrn == null) {
                throw new InternalError("Unable to create native raster");
            }
        }
        return this.wrn;
    }

    public void lock() {
    }

    public void unlock() {
    }

    public RenderLoops getRenderLoops(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.paintState == 0) {
            if (sunGraphics2D.compositeState == 0) {
                return this.solidloops;
            }
        }
        return super.getRenderLoops(sunGraphics2D);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    private native void initOps(int var1, int var2);

    private native void initSurface(int var1, int var2, int var3, int var4, boolean var5, int var6);

    protected void initD3DPipes() {
        if (this.d3dClippingEnabled) {
            this.d3dPipe = d3dClipPipe;
            this.d3dTxPipe = d3dTxClipPipe;
        } else {
            this.d3dPipe = d3dNoClipPipe;
            this.d3dTxPipe = d3dTxNoClipPipe;
        }
    }

    public native void restoreSurface();

    protected Win32OffScreenSurfaceData(int n, int n2, SurfaceType surfaceType, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Image image, int n3) {
        super(surfaceType, colorModel);
        this.width = n;
        this.height = n2;
        this.graphicsConfig = graphicsConfiguration;
        this.image = image;
        this.transparency = n3;
        this.solidloops = ((Win32GraphicsConfig)this.graphicsConfig).getSolidLoops(surfaceType);
        this.initOps(colorModel.getPixelSize(), n3);
    }

    private Win32OffScreenSurfaceData(int n, int n2, SurfaceType surfaceType, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Image image, int n3, int n4) {
        this(n, n2, surfaceType, colorModel, graphicsConfiguration, image, n3);
        this.initSurface(colorModel.getPixelSize(), n, n2, n4, image instanceof SunVolatileImage, n3);
        this.initD3DPipes();
    }

    public int getTransparency() {
        return this.transparency;
    }

    public SurfaceData getReplacement() {
        return Win32OffScreenSurfaceData.restoreContents(this.image);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.width, this.height);
    }

    private native void nativeInvalidate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        if (this.isValid()) {
            Win32OffScreenSurfaceData win32OffScreenSurfaceData = this;
            synchronized (win32OffScreenSurfaceData) {
                this.wrn = null;
            }
            this.nativeInvalidate();
            super.invalidate();
        }
    }

    public native void setTransparentPixel(int var1);

    public native void flush();

    public boolean surfacePunted() {
        return this.ddSurfacePunted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markSurfaceLost() {
        Object object = this;
        synchronized (object) {
            this.wrn = null;
        }
        this.setSurfaceLost(true);
        object = SurfaceManager.getManager(this.image);
        ((SurfaceManager)object).acceleratedSurfaceLost();
    }

    protected void disableDD() {
        this.markSurfaceLost();
        SurfaceManager surfaceManager = SurfaceManager.getManager(this.image);
        if (surfaceManager instanceof WinVolatileSurfaceManager) {
            ((WinVolatileSurfaceManager)surfaceManager).setAccelerationEnabled(false);
        } else if (surfaceManager instanceof WinCachingSurfaceManager) {
            ((WinCachingSurfaceManager)surfaceManager).setLocalAccelerationEnabled(false);
        }
    }

    static {
        Win32OffScreenSurfaceData.initIDs();
        if (WindowsFlags.isDDEnabled() && WindowsFlags.isDDOffscreenEnabled()) {
            if (WindowsFlags.isDDBlitEnabled()) {
                Win32BlitLoops.register();
            }
            if (WindowsFlags.isDDScaleEnabled()) {
                Win32ScaleLoops.register();
            }
            if (WindowsFlags.isTranslucentAccelerationEnabled()) {
                D3DBlitLoops.register();
            }
        }
        d3dNoClipPipe = new Win32D3DRenderer(false);
        d3dClipPipe = new Win32D3DRenderer(true);
        ddPipe = new Win32DDRenderer();
        if (GraphicsPrimitive.tracingEnabled()) {
            d3dNoClipPipe = d3dNoClipPipe.traceWrapD3D();
            d3dClipPipe = d3dClipPipe.traceWrapD3D();
            ddPipe = ddPipe.traceWrapDD();
        }
        d3dTxNoClipPipe = new PixelToShapeConverter(d3dNoClipPipe);
        d3dTxClipPipe = new PixelToShapeConverter(d3dClipPipe);
        ddTxPipe = new PixelToShapeConverter(ddPipe);
    }
}

