/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp;

import com.sun.org.apache.xerces.internal.impl.xs.opti.DefaultXMLDocumentHandler;
import com.sun.org.apache.xerces.internal.util.AttributesProxy;
import com.sun.org.apache.xerces.internal.util.LocatorProxy;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLLocator;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XNI2SAX
extends DefaultXMLDocumentHandler {
    private ContentHandler fContentHandler;
    private String fVersion;
    protected NamespaceContext fNamespaceContext;
    private final AttributesProxy fAttributesProxy = new AttributesProxy();

    public void setContentHandler(ContentHandler contentHandler) {
        this.fContentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.fContentHandler;
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        this.fVersion = string;
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fNamespaceContext = namespaceContext;
        this.fContentHandler.setDocumentLocator(new LocatorProxy(xMLLocator, this.fVersion));
        try {
            this.fContentHandler.startDocument();
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        try {
            this.fContentHandler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        try {
            this.fContentHandler.processingInstruction(string, xMLString.toString());
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        try {
            String string;
            String string2;
            int n = this.fNamespaceContext.getDeclaredPrefixCount();
            if (n > 0) {
                string2 = null;
                string = null;
                for (int i = 0; i < n; ++i) {
                    string = this.fNamespaceContext.getURI(string2 = this.fNamespaceContext.getDeclaredPrefixAt(i));
                    this.fContentHandler.startPrefixMapping(string2, string == null ? "" : string);
                }
            }
            string2 = qName.uri != null ? qName.uri : "";
            string = qName.localpart;
            this.fAttributesProxy.setAttributes(xMLAttributes);
            this.fContentHandler.startElement(string2, string, qName.rawname, this.fAttributesProxy);
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        try {
            String string = qName.uri != null ? qName.uri : "";
            String string2 = qName.localpart;
            this.fContentHandler.endElement(string, string2, qName.rawname);
            int n = this.fNamespaceContext.getDeclaredPrefixCount();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    this.fContentHandler.endPrefixMapping(this.fNamespaceContext.getDeclaredPrefixAt(i));
                }
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.startElement(qName, xMLAttributes, augmentations);
        this.endElement(qName, augmentations);
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        try {
            this.fContentHandler.characters(xMLString.ch, xMLString.offset, xMLString.length);
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        try {
            this.fContentHandler.ignorableWhitespace(xMLString.ch, xMLString.offset, xMLString.length);
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }
}

