/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUI;
import com.sun.java.swing.plaf.windows.WindowsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class WindowsPopupMenuUI
extends BasicPopupMenuUI {
    static MnemonicListener mnemonicListener = null;
    static final Object GUTTER_OFFSET_KEY = new StringBuilder("GUTTER_OFFSET_KEY");

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsPopupMenuUI();
    }

    public void installListeners() {
        super.installListeners();
        if (!UIManager.getBoolean("Button.showMnemonics") && mnemonicListener == null) {
            mnemonicListener = new MnemonicListener();
            MenuSelectionManager.defaultManager().addChangeListener(mnemonicListener);
        }
    }

    public Popup getPopup(JPopupMenu jPopupMenu, int n, int n2) {
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        return popupFactory.getPopup(jPopupMenu.getInvoker(), jPopupMenu, n, n2);
    }

    static int getTextOffset(JComponent jComponent) {
        int n = -1;
        return n;
    }

    static int getSpanBeforeGutter() {
        return 3;
    }

    static int getSpanAfterGutter() {
        return 3;
    }

    static int getGutterWidth() {
        int n = 2;
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            XPStyle.Skin skin = xPStyle.getSkin(null, TMSchema.Part.MP_POPUPGUTTER);
            n = skin.getWidth();
        }
        return n;
    }

    private static boolean isLeftToRight(JComponent jComponent) {
        boolean bl = true;
        for (int i = jComponent.getComponentCount() - 1; i >= 0 && bl; --i) {
            bl = jComponent.getComponent(i).getComponentOrientation().isLeftToRight();
        }
        return bl;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            XPStyle xPStyle = XPStyle.getXP();
            XPStyle.Skin skin = xPStyle.getSkin(jComponent, TMSchema.Part.MP_POPUPBACKGROUND);
            skin.paintSkin(graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), TMSchema.State.NORMAL);
            int n = WindowsPopupMenuUI.getTextOffset(jComponent);
            if (n >= 0 && WindowsPopupMenuUI.isLeftToRight(jComponent)) {
                skin = xPStyle.getSkin(jComponent, TMSchema.Part.MP_POPUPGUTTER);
                int n2 = WindowsPopupMenuUI.getGutterWidth();
                int n3 = n - WindowsPopupMenuUI.getSpanAfterGutter() - n2;
                jComponent.putClientProperty(GUTTER_OFFSET_KEY, n3);
                Insets insets = jComponent.getInsets();
                skin.paintSkin(graphics, n3, insets.top, n2, jComponent.getHeight() - insets.bottom - insets.top, TMSchema.State.NORMAL);
            } else if (jComponent.getClientProperty(GUTTER_OFFSET_KEY) != null) {
                jComponent.putClientProperty(GUTTER_OFFSET_KEY, null);
            }
        } else {
            super.paint(graphics, jComponent);
        }
    }

    static class MnemonicListener
    implements ChangeListener {
        JRootPane repaintRoot = null;

        MnemonicListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MenuSelectionManager menuSelectionManager = (MenuSelectionManager)changeEvent.getSource();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length == 0) {
                if (!WindowsLookAndFeel.isMnemonicHidden()) {
                    WindowsLookAndFeel.setMnemonicHidden(true);
                    if (this.repaintRoot != null) {
                        Window window = SwingUtilities.getWindowAncestor(this.repaintRoot);
                        WindowsUtils.repaintMnemonicsInWindow(window);
                    }
                }
            } else {
                Component component = (Component)((Object)menuElementArray[0]);
                if (component instanceof JPopupMenu) {
                    component = ((JPopupMenu)component).getInvoker();
                }
                this.repaintRoot = SwingUtilities.getRootPane(component);
            }
        }
    }
}

