/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.i18n.LocaleListener;
import net.jankenpoi.sudokuki.ui.L10nComponent;
import net.jankenpoi.sudokuki.ui.swing.ActionsRepository;
import net.jankenpoi.sudokuki.ui.swing.LanguageDialog;
import net.jankenpoi.sudokuki.ui.swing.LanguageMenu;
import net.jankenpoi.sudokuki.ui.swing.LocaleListenerImpl;
import net.jankenpoi.sudokuki.ui.swing.StockIcons;

public class ToolBar
extends JToolBar
implements L10nComponent {
    private JFrame frame;
    private Action actionInvokeLanguageDialog;
    private final LocaleListener localeListener;

    ToolBar(JFrame jFrame, ActionsRepository actionsRepository) {
        this.frame = jFrame;
        this.setFloatable(false);
        this.addButtons(actionsRepository);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setFocusable(false);
        }
        this.setL10nMessages(null, I18n.gtxt("DETECTED_LANGUAGE"));
        this.localeListener = new LocaleListenerImpl(this);
        I18n.addLocaleListener(this.localeListener);
    }

    private void addButtons(ActionsRepository actionsRepository) {
        Action action = actionsRepository.get("NewGrid");
        Action action2 = actionsRepository.get("Print");
        Action action3 = actionsRepository.get("OpenGrid");
        Action action4 = actionsRepository.get("SaveAs");
        Action action5 = actionsRepository.get("OpenUpdateSite");
        JButton jButton = new JButton(StockIcons.ICON_NEW);
        jButton.setAction(action);
        this.add(jButton);
        jButton = new JButton(action2);
        this.add(jButton);
        jButton = new JButton(action3);
        this.add(jButton);
        jButton = new JButton(action4);
        this.add(jButton);
        jButton = new JButton(action5);
        jButton.setText("");
        jButton.setEnabled(false);
        this.add(jButton);
        this.actionInvokeLanguageDialog = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LanguageDialog languageDialog = new LanguageDialog(ToolBar.this.frame, ToolBar.this);
                languageDialog.setVisible(true);
            }
        };
        jButton = new JButton(this.actionInvokeLanguageDialog);
        jButton.setEnabled(true);
        this.actionInvokeLanguageDialog.putValue("SmallIcon", LanguageMenu.languageIcon(I18n.gtxt("DETECTED_LANGUAGE")));
        this.actionInvokeLanguageDialog.putValue("ShortDescription", I18n.gtxt("Language"));
        jButton.setText("");
        this.add(jButton);
    }

    @Override
    public void setL10nMessages(Locale locale, String string) {
        this.actionInvokeLanguageDialog.putValue("SmallIcon", LanguageMenu.languageIcon(string));
        this.actionInvokeLanguageDialog.putValue("ShortDescription", I18n.gtxt("Language"));
    }
}

