/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.sudokuki.view.GridView;

public class SaveAsAction
extends AbstractAction {
    private final GridView view;
    private final JFrame frame;

    SaveAsAction(JFrame jFrame, GridView gridView) {
        this.frame = jFrame;
        this.view = gridView;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(){

            @Override
            public File getSelectedFile() {
                File file = super.getSelectedFile();
                if (file == null) {
                    return new File("myGrid.skg");
                }
                if (!"skg".equals(SaveAsAction.getExtension(file))) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + ".skg");
                }
                return file;
            }
        };
        jFileChooser.setDialogTitle(I18n.gtxt("Save as..."));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(I18n.gtxt("Sudokuki grid files"), "skg");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        int n = jFileChooser.showSaveDialog(this.frame);
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        file.delete();
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.frame, "<html><table border=\"0\"><tr>" + I18n.gtxt("Failed to save the grid<br/>at the selected location.") + "</tr>" + "</html>", "Sudokuki", 0);
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this.frame, "<html><table border=\"0\"><tr>" + I18n.gtxt("Failed to save the grid<br/>at the selected location.") + "</tr>" + "</html>", "Sudokuki", 0);
            return;
        }
        int[] nArray = this.view.getController().getCellInfosFromModel();
        for (int i = 0; i < nArray.length; ++i) {
            byte by = (byte)(nArray[i] & 0xFF);
            byte by2 = (byte)((nArray[i] & 0xFF00) >> 8);
            try {
                fileOutputStream.write(by);
                fileOutputStream.write(by2);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }
}

