/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.sudokuki.view.GridView;

public class OpenGridAction
extends AbstractAction {
    private final GridView view;
    private final JFrame frame;

    OpenGridAction(JFrame jFrame, GridView gridView) {
        this.frame = jFrame;
        this.view = gridView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(I18n.gtxt("Open grid..."));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(new FileFilter(){

            public String getExtension(File file) {
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string;
            }

            @Override
            public String getDescription() {
                return I18n.gtxt("Sudokuki grid files");
            }

            @Override
            public boolean accept(File file) {
                String string = this.getExtension(file);
                return file.isDirectory() || "skg".equals(string);
            }
        });
        int n = jFileChooser.showOpenDialog(this.frame);
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (fileInputStream == null) {
            JOptionPane.showMessageDialog(this.frame, "<html><table border=\"0\"><tr>File not found:</tr><tr>" + file + "</tr>" + "</html>", "Sudokuki", -1);
            return;
        }
        short[] sArray = new short[81];
        try {
            for (int i = 0; i < 81; ++i) {
                int n2 = fileInputStream.read();
                int n3 = fileInputStream.read();
                short s = (short)(n3 << 8 | n2);
                if ((s & Short.MIN_VALUE) != 0) {
                    throw new IOException("Invalid cell info");
                }
                if (9 < (s & 0xF)) {
                    throw new IOException("Cell value out of range");
                }
                sArray[i] = s;
            }
            this.view.getController().notifyResetGridFromShorts(sArray);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.frame, "<html><table border=\"0\"><tr>" + I18n.gtxt("This file is not a Sudokuki grid.") + "</tr>" + "</html>", "Sudokuki", 0);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("An error occured upon FileInputStream close()");
            }
        }
    }
}

