/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.solver;

import java.util.Random;
import net.jankenpoi.sudokuki.model.GridModel;
import net.jankenpoi.sudokuki.solver.GridSolution;
import net.jankenpoi.sudokuki.solver.GridSolver;
import net.sourceforge.plantuml.sudoku.DLXEngine;

public class DLXGridSolver
implements GridSolver {
    private final GridModel originalGrid;

    public DLXGridSolver(GridModel gridModel) {
        this.originalGrid = gridModel;
    }

    @Override
    public GridSolution resolve() {
        DLXEngine dLXEngine = new DLXEngine(new Random());
        String string = "";
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                byte by = this.originalGrid.getValueAt(i, j);
                string = by == 0 ? string + "." : string + by;
            }
        }
        String string2 = dLXEngine.solve(string).substring(0, 81);
        if (DLXEngine.DBG) {
            System.out.println("solution = " + string2);
        }
        return new GridSolution(true, new GridModel(string2));
    }

    @Override
    public void cancel() {
    }
}

