/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.model;

import java.util.ArrayList;
import java.util.List;
import net.jankenpoi.sudokuki.SudokuGrid;
import net.jankenpoi.sudokuki.generator.SudokuGeneratorFactory;
import net.jankenpoi.sudokuki.model.GridChangedEvent;
import net.jankenpoi.sudokuki.preferences.UserPreferences;
import net.jankenpoi.sudokuki.view.GridListener;

public class GridModel
implements Cloneable {
    public static final int MASK_CELL_VALUES = 15;
    public static final int MASK_CELL_MEMOS = 8176;
    public static final int FLAG_CELL_MEMO_1 = 16;
    public static final int FLAG_CELL_MEMO_2 = 32;
    public static final int FLAG_CELL_MEMO_3 = 64;
    public static final int FLAG_CELL_MEMO_4 = 128;
    public static final int FLAG_CELL_MEMO_5 = 256;
    public static final int FLAG_CELL_MEMO_6 = 512;
    public static final int FLAG_CELL_MEMO_7 = 1024;
    public static final int FLAG_CELL_MEMO_8 = 2048;
    public static final int FLAG_CELL_MEMO_9 = 4096;
    public static final int FLAG_CELL_READ_ONLY = 8192;
    public static final int FLAG_GRID_COMPLETE = 16384;
    private List<GridListener> listeners = new ArrayList<GridListener>();
    private boolean isCustomGridModeON = false;
    private short[] cellInfos = new short[81];

    public GridModel(short[] sArray, int n) {
        this.copyFlagsToGrid(sArray, n);
    }

    private void copyFlagsToGrid(short[] sArray, int n) {
        for (int i = 0; i < this.cellInfos.length; ++i) {
            short s;
            this.cellInfos[i] = s = (short)(sArray[n + i] & 0xF);
            if (1 > s || s > 9) continue;
            int n2 = i;
            this.cellInfos[n2] = (short)(this.cellInfos[n2] | 0x2000);
        }
    }

    public GridModel() {
        this.newGrid();
    }

    public void resetGridModelFromShorts(short[] sArray) {
        this.cellInfos = new short[81];
        for (int i = 0; i < 81; ++i) {
            this.cellInfos[i] = sArray[i];
        }
    }

    private void newGrid() {
        int n = UserPreferences.getInstance().getInteger("minRating", 0);
        int n2 = UserPreferences.getInstance().getInteger("maxRating", Integer.MAX_VALUE);
        SudokuGrid sudokuGrid = SudokuGeneratorFactory.getGenerator().generateGrid(n, n2);
        for (int i = 0; i < this.cellInfos.length; ++i) {
            short s;
            this.cellInfos[i] = s = (short)sudokuGrid.getValueAt(i);
            if (1 > s || s > 9) continue;
            int n3 = i;
            this.cellInfos[n3] = (short)(this.cellInfos[n3] | 0x2000);
        }
    }

    public GridModel(String string) {
        if (string == null) {
            return;
        }
        for (int i = 0; i < string.length(); ++i) {
            short s;
            this.cellInfos[i] = s = Short.valueOf(string.substring(i, i + 1)).shortValue();
            if (1 > s || s > 9) continue;
            int n = i;
            this.cellInfos[n] = (short)(this.cellInfos[n] | 0x2000);
        }
    }

    public void addGridListener(GridListener gridListener) {
        this.listeners.add(gridListener);
    }

    short getCellInfosAt(int n, int n2) {
        return this.cellInfos[9 * n + n2];
    }

    public void setMemosForAllCells() {
        byte by;
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < 9; ++n3) {
            for (n2 = 0; n2 < 9; ++n2) {
                if (this.isCellFilled(n3, n2)) continue;
                this.cellInfos[9 * n3 + n2] = 8176;
            }
        }
        for (n3 = 0; n3 < 9; n3 += 3) {
            for (n2 = 0; n2 < 9; n2 += 3) {
                int n4;
                int n5;
                int n6;
                n = 0;
                for (by = 0; by < 3; ++by) {
                    for (n6 = 0; n6 < 3; ++n6) {
                        n5 = n2 + n6;
                        n4 = n3 + by;
                        if (!this.isCellFilled(n5, n4)) continue;
                        byte by2 = this.getValueAt(n5, n4);
                        n = (short)(n | this.getMemoFlag(by2));
                    }
                }
                for (by = 0; by < 3; ++by) {
                    for (n6 = 0; n6 < 3; ++n6) {
                        n5 = n2 + n6;
                        n4 = n3 + by;
                        if (this.isCellFilled(n5, n4)) continue;
                        int n7 = 9 * n5 + n4;
                        this.cellInfos[n7] = (short)(this.cellInfos[n7] & ~n);
                    }
                }
            }
        }
        for (n3 = 0; n3 < 9; ++n3) {
            n2 = 0;
            for (n = 0; n < 9; ++n) {
                if (!this.isCellFilled(n3, n)) continue;
                by = this.getValueAt(n3, n);
                n2 = (short)(n2 | this.getMemoFlag(by));
            }
            for (n = 0; n < 9; ++n) {
                if (this.isCellFilled(n3, n)) continue;
                int n8 = 9 * n3 + n;
                this.cellInfos[n8] = (short)(this.cellInfos[n8] & ~n2);
            }
        }
        for (n3 = 0; n3 < 9; ++n3) {
            n2 = 0;
            for (n = 0; n < 9; ++n) {
                if (!this.isCellFilled(n, n3)) continue;
                by = this.getValueAt(n, n3);
                n2 = (short)(n2 | this.getMemoFlag(by));
            }
            for (n = 0; n < 9; ++n) {
                if (this.isCellFilled(n, n3)) continue;
                int n9 = 9 * n + n3;
                this.cellInfos[n9] = (short)(this.cellInfos[n9] & ~n2);
            }
        }
        this.fireGridChanged(new GridChangedEvent(this, 0, 0, 0));
    }

    public void setMemosForThisCell(int n, int n2) {
        if (this.isCellFilled(n, n2)) {
            return;
        }
        this.cellInfos[9 * n + n2] = 8176;
        int n3 = 3 * (n2 / 3);
        int n4 = 3 * (n / 3);
        byte by = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n5 = n4 + j;
                int n6 = n3 + i;
                if (!this.isCellFilled(n5, n6)) continue;
                byte by2 = this.getValueAt(n5, n6);
                by = (byte)(by | this.getMemoFlag(by2));
            }
        }
        int n7 = 9 * n + n2;
        this.cellInfos[n7] = (short)(this.cellInfos[n7] & ~by);
        n3 = 0;
        for (n4 = 0; n4 < 9; ++n4) {
            if (!this.isCellFilled(n, n4)) continue;
            by = this.getValueAt(n, n4);
            n3 = (short)(n3 | this.getMemoFlag(by));
        }
        for (n4 = 0; n4 < 9; ++n4) {
            if (this.isCellFilled(n, n4)) continue;
            int n8 = 9 * n + n4;
            this.cellInfos[n8] = (short)(this.cellInfos[n8] & ~n3);
        }
        n3 = 0;
        for (n4 = 0; n4 < 9; ++n4) {
            if (!this.isCellFilled(n4, n2)) continue;
            by = this.getValueAt(n4, n2);
            n3 = (short)(n3 | this.getMemoFlag(by));
        }
        for (n4 = 0; n4 < 9; ++n4) {
            if (this.isCellFilled(n4, n2)) continue;
            int n9 = 9 * n4 + n2;
            this.cellInfos[n9] = (short)(this.cellInfos[n9] & ~n3);
        }
        this.fireGridChanged(new GridChangedEvent(this, n, n2, this.cellInfos[9 * n + n2]));
    }

    public void setCellMemos(int n, int n2, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.setCellMemo(n, n2, byArray[i]);
        }
        this.fireGridChanged(new GridChangedEvent(this, n, n2, this.cellInfos[9 * n + n2]));
    }

    private short getMemoFlag(byte by) {
        switch (by) {
            case 1: {
                return 16;
            }
            case 2: {
                return 32;
            }
            case 3: {
                return 64;
            }
            case 4: {
                return 128;
            }
            case 5: {
                return 256;
            }
            case 6: {
                return 512;
            }
            case 7: {
                return 1024;
            }
            case 8: {
                return 2048;
            }
            case 9: {
                return 4096;
            }
        }
        throw new IllegalArgumentException("GridModel.getMemoFlag() value " + by + " is illegal");
    }

    public byte getNbOfPossibleValues(int n, int n2) {
        short s = this.cellInfos[9 * n + n2];
        byte by = 0;
        for (byte by2 = 1; by2 <= 9; by2 = (byte)(by2 + 1)) {
            by = (byte)(by + ((s & this.getMemoFlag(by2)) != 0 ? (byte)1 : 0));
        }
        return by;
    }

    private void setCellMemo(int n, int n2, byte by) {
        int n3 = 9 * n + n2;
        this.cellInfos[n3] = (short)(this.cellInfos[n3] | this.getMemoFlag(by));
    }

    public void clearCellMemos(int n, int n2) {
        int n3 = 9 * n + n2;
        this.cellInfos[n3] = (short)(this.cellInfos[n3] & 0xFFFFE00F);
    }

    public boolean isCellValueSet(int n, int n2, Byte by) {
        return (this.cellInfos[9 * n + n2] & by) != 0;
    }

    public boolean isCellFilled(int n, int n2) {
        return (this.cellInfos[9 * n + n2] & 0xF) != 0;
    }

    public void setCellReadOnly(int n, int n2) {
        int n3 = 9 * n + n2;
        this.cellInfos[n3] = (short)(this.cellInfos[n3] | 0x2000);
    }

    public void setCellValue(int n, int n2, int n3, boolean bl) {
        int n4 = 9 * n + n2;
        this.cellInfos[n4] = (short)(this.cellInfos[n4] & 0xFFFFFFF0);
        int n5 = 9 * n + n2;
        this.cellInfos[n5] = (short)(this.cellInfos[n5] | n3);
        this.clearCellMemos(n, n2);
        if (!bl) {
            this.fireGridChanged(new GridChangedEvent(this, n, n2, this.cellInfos[9 * n + n2]));
        }
        if (!bl && this.isGridFull()) {
            GridValidity gridValidity = this.checkGridValidity();
            if (gridValidity.isGridValid()) {
                this.setGridComplete();
            }
            this.fireGridChanged(new GridChangedEvent(this, 0, 0, 0));
        }
    }

    public void fireGridChanged(GridChangedEvent gridChangedEvent) {
        for (GridListener gridListener : this.listeners) {
            gridListener.gridChanged(gridChangedEvent);
        }
    }

    public boolean isCellMemoSet(int n, int n2, byte by) {
        return (this.cellInfos[9 * n + n2] & this.getMemoFlag(by)) != 0;
    }

    public boolean isCellReadOnly(int n, int n2) {
        return !this.isCustomGridModeON && (this.cellInfos[9 * n + n2] & 0x2000) != 0;
    }

    public boolean isGridFull() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.isCellFilled(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isGridComplete() {
        return (this.cellInfos[0] & 0x4000) != 0;
    }

    public void setGridResolved() {
        this.cellInfos[0] = (short)(this.cellInfos[0] | 0x4000);
        this.fireGridResolved();
    }

    private void fireGridResolved() {
        for (GridListener gridListener : this.listeners) {
            gridListener.gridResolved();
        }
    }

    public void setGridComplete() {
        this.cellInfos[0] = (short)(this.cellInfos[0] | 0x4000);
        this.fireGridComplete();
    }

    private void fireGridComplete() {
        for (GridListener gridListener : this.listeners) {
            gridListener.gridComplete();
        }
    }

    public byte getValueAt(int n, int n2) {
        byte by = (byte)(this.cellInfos[9 * n + n2] & 0xF);
        return by;
    }

    public int[] cloneCellInfosAsInts() {
        int[] nArray = new int[this.cellInfos.length];
        for (int i = 0; i < this.cellInfos.length; ++i) {
            nArray[i] = this.cellInfos[i];
        }
        return nArray;
    }

    public void requestNewGrid() {
        this.newGrid();
    }

    public void clearAllUserMoves() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.isCellReadOnly(i, j)) continue;
                int n = 9 * i + j;
                this.cellInfos[n] = (short)(this.cellInfos[n] & 0xFFFFFFF0);
            }
        }
        this.fireGridChanged(new GridChangedEvent(this, 0, 0, 0));
    }

    public void clearAllUserMemos() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.clearCellMemos(i, j);
            }
        }
        this.fireGridChanged(new GridChangedEvent(this, 0, 0, 0));
    }

    public void enterCustomGridMode() {
        this.isCustomGridModeON = true;
        this.fireGridChanged(new GridChangedEvent(this, 0, 0, 0));
    }

    public GridValidity getGridValidity() {
        if (!this.isCustomGridModeON && !this.isGridFull()) {
            return GridValidity.VALID;
        }
        return this.checkGridValidity();
    }

    public void exitCustomGridMode() {
        this.isCustomGridModeON = false;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.isCellFilled(i, j)) {
                    this.setCellReadOnly(i, j);
                    continue;
                }
                int n = 9 * i + j;
                this.cellInfos[n] = (short)(this.cellInfos[n] & 0xFFFFDFFF);
            }
        }
        this.fireGridChanged(new GridChangedEvent(this, 0, 0, 0));
    }

    public boolean getCustomGridMode() {
        return this.isCustomGridModeON;
    }

    private GridValidity checkGridValidity() {
        int n;
        int n2;
        byte[] byArray;
        int n3;
        boolean bl = true;
        Integer n4 = null;
        Integer n5 = null;
        Integer n6 = null;
        Integer n7 = null;
        block0: for (n3 = 0; bl && n3 < 9; ++n3) {
            byArray = new byte[10];
            for (n2 = 0; n2 < 9; ++n2) {
                n = this.getValueAt(n3, n2);
                if (byArray[n] != 0) {
                    bl = false;
                    n4 = n3;
                    continue block0;
                }
                byArray[n] = n;
            }
        }
        block2: for (n3 = 0; bl && n3 < 9; ++n3) {
            byArray = new byte[10];
            for (n2 = 0; n2 < 9; ++n2) {
                n = this.getValueAt(n2, n3);
                if (byArray[n] != 0) {
                    bl = false;
                    n5 = n3;
                    continue block2;
                }
                byArray[n] = n;
            }
        }
        for (n3 = 0; bl && n3 < 9; n3 += 3) {
            for (int i = 0; bl && i < 9; i += 3) {
                int[] nArray = new int[10];
                block6: for (n = 0; bl && n < 3; ++n) {
                    for (int j = 0; bl && j < 3; ++j) {
                        int n8 = i + j;
                        int n9 = n3 + n;
                        byte by = this.getValueAt(n8, n9);
                        if (nArray[by] != 0) {
                            bl = false;
                            n6 = n3;
                            n7 = i;
                            continue block6;
                        }
                        nArray[by] = by;
                    }
                }
            }
        }
        return GridValidity.valueOf(bl, n4, n5, n6, n7);
    }

    public boolean areSomeMemosSet() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if ((this.cellInfos[9 * i + j] & 0x1FF0) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean areSomeCellsFilled() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.isCellReadOnly(i, j) || (this.cellInfos[9 * i + j] & 0xF) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean areSomeCellsEmpty() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.isCellFilled(i, j)) continue;
                return true;
            }
        }
        return false;
    }

    public int[] asIntArray() {
        int[] nArray = new int[this.cellInfos.length];
        for (int i = 0; i < this.cellInfos.length; ++i) {
            nArray[i] = this.cellInfos[i];
        }
        return nArray;
    }

    public static class GridValidity {
        public static final GridValidity VALID = new GridValidity(true, null, null, null, null);
        private boolean isValid = true;
        private Integer firstErrorLine = null;
        private Integer firstErrorColumn = null;
        private Integer firstErrorSquareX = null;
        private Integer firstErrorSquareY = null;

        private GridValidity(boolean bl, Integer n, Integer n2, Integer n3, Integer n4) {
            this.isValid = bl;
            this.firstErrorLine = n;
            this.firstErrorColumn = n2;
            this.firstErrorSquareX = n3;
            this.firstErrorSquareY = n4;
        }

        private static GridValidity valueOf(boolean bl, Integer n, Integer n2, Integer n3, Integer n4) {
            if (bl) {
                return VALID;
            }
            return new GridValidity(bl, n, n2, n3, n4);
        }

        public boolean isGridValid() {
            return this.isValid;
        }

        public Integer getFirstErrorLine() {
            return this.firstErrorLine;
        }

        public Integer getFirstErrorColumn() {
            return this.firstErrorColumn;
        }

        public Integer getFirstErrorSquareX() {
            return this.firstErrorSquareX;
        }

        public Integer getFirstErrorSquareY() {
            return this.firstErrorSquareY;
        }
    }
}

