/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.i18n;

import gnu.gettext.GettextResource;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import net.jankenpoi.i18n.LocaleListener;

public class I18n {
    private static ResourceBundle catalog;
    private static Locale currentLocale;
    private static Object lock;
    private static final ArrayList<LocaleListener> listeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(String string) {
        String[] stringArray = string.split("_");
        String string2 = stringArray[0];
        String string3 = stringArray.length > 1 ? stringArray[1] : "";
        Object object = lock;
        synchronized (object) {
            try {
                ResourceBundle resourceBundle;
                if (!"".equals(string)) {
                    currentLocale = new Locale(string2, string3);
                }
                if (currentLocale == null) {
                    currentLocale = new Locale(System.getenv("LANG"));
                }
                catalog = resourceBundle = ResourceBundle.getBundle(I18n.class.getName().replace("I18n", "sudokuki"), currentLocale);
                for (int i = 0; i < listeners.size(); ++i) {
                    listeners.get(i).onLocaleChanged(currentLocale);
                }
            }
            catch (Exception exception) {
                try {
                    if (catalog == null) {
                        if (System.getenv("LANG") != null) {
                            System.out.println("I18n unable to find translations for (LANG) locale " + System.getenv("LANG"));
                        }
                        catalog = ResourceBundle.getBundle(I18n.class.getName().replace("I18n", "sudokuki"), Locale.getDefault());
                        currentLocale = Locale.getDefault();
                    }
                }
                catch (Exception exception2) {
                    System.out.println("I18n unable to find translations for (JVM) locale " + Locale.getDefault());
                    catalog = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLocaleListener(LocaleListener localeListener) {
        ArrayList<LocaleListener> arrayList = listeners;
        synchronized (arrayList) {
            if (localeListener != null) {
                listeners.add(localeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLocaleListener(LocaleListener localeListener) {
        ArrayList<LocaleListener> arrayList = listeners;
        synchronized (arrayList) {
            if (localeListener != null) {
                listeners.remove(localeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String gtxt(String string) {
        Object object = lock;
        synchronized (object) {
            if (catalog != null) {
                return GettextResource.gettext(catalog, string);
            }
            return string;
        }
    }

    static {
        lock = new Object();
        listeners = new ArrayList();
        I18n.reset("");
    }
}

