/*
 * Sudokuki - essential sudoku game
 * Copyright (C) 2007-2016 Sylvain Vedrenne
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package net.jankenpoi.sudokuki.ui.swing;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import net.jankenpoi.sudokuki.resources.UIResources;

public class StockIcons {

	/*
	 * Current flag image icons thanks to the PIWIK project. For example, visit:
	 * https://sourceforge.net/apps/piwik/sudokuki/plugins/UserCountry/flags/
	 */
	/* 
* https://upload.wikimedia.org/wikipedia/commons/thumb/0/0d/Flag_of_Saudi_Arabia.svg/16px-Flag_of_Saudi_Arabia.svg.png
	 */
	public final static ImageIcon ICON_FLAG_AR = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/sa.png"));
	/* 
* https://upload.wikimedia.org/wikipedia/en/thumb/0/05/Flag_of_Brazil.svg/16px-Flag_of_Brazil.svg.png
	 */
	public final static ImageIcon ICON_FLAG_BR = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/br.png"));
	/* 
* https://upload.wikimedia.org/wikipedia/en/thumb/b/ba/Flag_of_Germany.svg/16px-Flag_of_Germany.svg.png
	 */
	public final static ImageIcon ICON_FLAG_DE = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/de.png"));
	/* 
* https://upload.wikimedia.org/wikipedia/commons/thumb/5/5c/Flag_of_Greece.svg/16px-Flag_of_Greece.svg.png
	 */
	public final static ImageIcon ICON_FLAG_EL = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/el.png"));
	/* 
* https://upload.wikimedia.org/wikipedia/en/thumb/a/ae/Flag_of_the_United_Kingdom.svg/16px-Flag_of_the_United_Kingdom.svg.png
* https://upload.wikimedia.org/wikipedia/commons/thumb/a/ae/Flag_of_the_United_Kingdom.svg/21px-Flag_of_the_United_Kingdom.svg.png
	 */
	public final static ImageIcon ICON_FLAG_EN = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/en.png"));
	/* 
	 * https://upload.wikimedia.org/wikipedia/commons/7/7e/Icons-flag-eo.png
	 */
	public final static ImageIcon ICON_FLAG_EO = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/eo.png"));
	/* 
* https://upload.wikimedia.org/wikipedia/en/thumb/9/9a/Flag_of_Spain.svg/16px-Flag_of_Spain.svg.png
	 */
	public final static ImageIcon ICON_FLAG_ES = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/es.png"));
	/* 
* https://upload.wikimedia.org/wikipedia/en/thumb/c/c3/Flag_of_France.svg/16px-Flag_of_France.svg.png
	 */
	public final static ImageIcon ICON_FLAG_FR = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/fr.png"));
	/* 
* https://upload.wikimedia.org/wikipedia/commons/thumb/c/c1/Flag_of_Hungary.svg/21px-Flag_of_Hungary.svg.png
	 */
	public final static ImageIcon ICON_FLAG_HU = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/hu.png"));
	/* 
* https://upload.wikimedia.org/wikipedia/en/thumb/9/9e/Flag_of_Japan.svg/16px-Flag_of_Japan.svg.png
	 */
	public final static ImageIcon ICON_FLAG_JA = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/ja.png"));
	/* 
* https://upload.wikimedia.org/wikipedia/commons/thumb/1/11/Flag_of_Lithuania.svg/16px-Flag_of_Lithuania.svg.png
	 */
	public final static ImageIcon ICON_FLAG_LV = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/lv.png"));
        /* 
* https://upload.wikimedia.org/wikipedia/commons/thumb/2/20/Flag_of_the_Netherlands.svg/16px-Flag_of_the_Netherlands.svg.png
         */
        public final static ImageIcon ICON_FLAG_NL = new ImageIcon(
                        UIResources.class
                                        .getResource("images/countryFlags/nl.png"));
        /*
* https://upload.wikimedia.org/wikipedia/en/thumb/1/12/Flag_of_Poland.svg/16px-Flag_of_Poland.svg.png
         */
        public final static ImageIcon ICON_FLAG_PL = new ImageIcon(
                        UIResources.class
                                        .getResource("images/countryFlags/pl.png"));
	/* 
* https://upload.wikimedia.org/wikipedia/commons/thumb/5/5c/Flag_of_Portugal.svg/16px-Flag_of_Portugal.svg.png
	 */
	public final static ImageIcon ICON_FLAG_PT = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/pt.png"));
	/* 
* https://upload.wikimedia.org/wikipedia/en/thumb/f/f3/Flag_of_Russia.svg/16px-Flag_of_Russia.svg.png
	 */
	public final static ImageIcon ICON_FLAG_RU = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/ru.png"));
	/* 
* https://upload.wikimedia.org/wikipedia/en/thumb/4/41/Flag_of_India.svg/16px-Flag_of_India.svg.png
	 */
	public final static ImageIcon ICON_FLAG_TA = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/in.png"));
	/* 
* https://upload.wikimedia.org/wikipedia/commons/thumb/b/b4/Flag_of_Turkey.svg/16px-Flag_of_Turkey.svg.png
	 */
	public final static ImageIcon ICON_FLAG_TR = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/tr.png"));
	/* 
* https://upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Flag_of_the_People%27s_Republic_of_China.svg/16px-Flag_of_the_People%27s_Republic_of_China.svg.png
	 */
	public final static ImageIcon ICON_FLAG_ZH = new ImageIcon(
			UIResources.class
					.getResource("images/countryFlags/zh.png"));
	
	public final static ImageIcon ICON_NEW = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/document-new.png"));
	public static final Icon ICON_PRINT = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/document-print.png"));
	public static final Icon ICON_PRINTER_INFO = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/printer-info.png"));
	public static final Icon ICON_OPEN = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/document-open.png"));
	public static final Icon ICON_SAVE_AS = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/document-save-as.png"));
	public static final Icon ICON_QUIT = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/application-exit.png"));
	public static final Icon ICON_UNDO = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/edit-undo-ltr.png"));
	public static final Icon ICON_CLEAR = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/edit-clear.png"));
	public static final Icon ICON_CLEAR_ALL_MEMOS = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/erase-all-memos.png"));
	public static final Icon ICON_SET_MEMOS_HERE = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/set-memos-here.png"));
	public static final Icon ICON_SET_ALL_MEMOS = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/set-all-memos.png"));
	public static final Icon ICON_SOLUTION_MENU = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/solution-menu.png"));
	public static final Icon ICON_EDIT = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/gtk-edit.png"));
	public static final Icon ICON_PLAY = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/media-playback-start-ltr.png"));
	public static final Icon ICON_GO_NEXT = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/go-next-ltr.png"));
	public static final Icon ICON_GO_JUMP = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/go-jump-ltr.png"));
	public static final Icon ICON_HELP_ABOUT = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/help-about.png"));
	public static final Icon ICON_PREFERENCES = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/gtk-preferences.png"));
	public static final Icon ICON_GO_HOME = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/go-home.png"));
	public static final Icon ICON_FONT = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/gtk-font.png"));
	public static final Icon ICON_PLUS = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/list-add.png"));
	public static final Icon ICON_VIEW_REFRESH = new ImageIcon(
			UIResources.class
					.getResource("images/gtk+/stock-icons/16/view-refresh.png"));
	public static final Icon ICON_UPDATE_AVAILABLE = new ImageIcon(
			UIResources.class
			.getResource("images/gtk+/stock-icons/16/view-refresh-update-available.png"));
	public static final Icon ICON_CHECK_SPELLING = new ImageIcon(
			UIResources.class
			.getResource("images/gtk+/stock-icons/16/tools-check-spelling.png"));
	public static final Icon ICON_TRANSLATE = new ImageIcon(
			UIResources.class
			.getResource("images/gtk+/stock-icons/16/earth.png"));

/* https://upload.wikimedia.org/wikipedia/commons/thumb/0/0d/Flag_of_Saudi_Arabia.svg/16px-Flag_of_Saudi_Arabia.svg.png
* https://upload.wikimedia.org/wikipedia/en/thumb/9/9a/Flag_of_Spain.svg/16px-Flag_of_Spain.svg.png
* https://upload.wikimedia.org/wikipedia/en/thumb/b/ba/Flag_of_Germany.svg/16px-Flag_of_Germany.svg.png
* https://upload.wikimedia.org/wikipedia/en/thumb/a/ae/Flag_of_the_United_Kingdom.svg/16px-Flag_of_the_United_Kingdom.svg.png
* https://upload.wikimedia.org/wikipedia/commons/7/7e/Icons-flag-eo.png
* https://upload.wikimedia.org/wikipedia/commons/thumb/5/5c/Flag_of_Greece.svg/16px-Flag_of_Greece.svg.png
* https://upload.wikimedia.org/wikipedia/en/thumb/c/c3/Flag_of_France.svg/16px-Flag_of_France.svg.png
* https://upload.wikimedia.org/wikipedia/commons/thumb/c/c1/Flag_of_Hungary.svg/16px-Flag_of_Hungary.svg.png
* https://upload.wikimedia.org/wikipedia/en/thumb/4/41/Flag_of_India.svg/16px-Flag_of_India.svg.png
* https://upload.wikimedia.org/wikipedia/en/thumb/9/9e/Flag_of_Japan.svg/16px-Flag_of_Japan.svg.png
* https://upload.wikimedia.org/wikipedia/commons/thumb/1/11/Flag_of_Lithuania.svg/16px-Flag_of_Lithuania.svg.png
* https://upload.wikimedia.org/wikipedia/commons/thumb/2/20/Flag_of_the_Netherlands.svg/16px-Flag_of_the_Netherlands.svg.png
* https://upload.wikimedia.org/wikipedia/en/thumb/1/12/Flag_of_Poland.svg/16px-Flag_of_Poland.svg.png
* https://upload.wikimedia.org/wikipedia/commons/thumb/5/5c/Flag_of_Portugal.svg/16px-Flag_of_Portugal.svg.png
* https://upload.wikimedia.org/wikipedia/en/thumb/0/05/Flag_of_Brazil.svg/16px-Flag_of_Brazil.svg.png
* https://upload.wikimedia.org/wikipedia/en/thumb/f/f3/Flag_of_Russia.svg/16px-Flag_of_Russia.svg.png
* https://upload.wikimedia.org/wikipedia/commons/thumb/b/b4/Flag_of_Turkey.svg/16px-Flag_of_Turkey.svg.png
* https://upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Flag_of_the_People%27s_Republic_of_China.svg/16px-Flag_of_the_People%27s_Republic_of_China.svg.png
*/



}
