/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.view;

import net.jankenpoi.sudokuki.controller.GridController;
import net.jankenpoi.sudokuki.model.GridChangedEvent;
import net.jankenpoi.sudokuki.model.GridModel;
import net.jankenpoi.sudokuki.view.GridListener;

public abstract class GridView
implements GridListener {
    private GridController controller = null;
    private GridModel model = null;

    public GridView(GridModel gridModel) {
        this.model = gridModel;
    }

    public final GridController getController() {
        return this.controller;
    }

    public final void setController(GridController gridController) {
        this.controller = gridController;
    }

    @Override
    public abstract void gridChanged(GridChangedEvent var1);

    public abstract void display();

    public abstract void close();

    public byte getValueAt(int n, int n2) {
        return this.model.getValueAt(n, n2);
    }

    public boolean isCellValueSet(int n, int n2, Byte by) {
        return this.model.isCellValueSet(n, n2, by);
    }

    public boolean isCellValueSet(int n, int n2) {
        for (byte by = 1; by <= 9; by = (byte)(by + 1)) {
            if (!this.isCellValueSet(n, n2, by)) continue;
            return true;
        }
        return false;
    }

    public boolean isCellReadOnly(int n, int n2) {
        return this.model.isCellReadOnly(n, n2);
    }

    public boolean isCellMemoSet(int n, int n2, byte by) {
        return this.model.isCellMemoSet(n, n2, by);
    }

    public boolean isGrigComplete() {
        return this.model.isGridComplete();
    }

    public GridModel.GridValidity getGridValidity() {
        return this.model.getGridValidity();
    }
}

