/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.sudokuki.model.GridModel;
import net.jankenpoi.sudokuki.solver.DLXGridSolver;
import net.jankenpoi.sudokuki.solver.GridSolution;
import net.jankenpoi.sudokuki.solver.GridSolver;
import net.jankenpoi.sudokuki.view.GridView;

public class ResolveGridDialog
extends JDialog {
    private final JFrame parent;
    private int status = -1;
    private final GridView view;
    private final SwingWorker<Integer, Void> worker;
    private final GridSolver solver;
    private final GridModel gridToSolve;

    public ResolveGridDialog(JFrame jFrame, GridView gridView) {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.view = gridView;
        this.setResizable(false);
        short[] sArray = new short[81];
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (!gridView.isCellReadOnly(i, j)) continue;
                sArray[9 * i + j] = gridView.getValueAt(i, j);
            }
        }
        this.gridToSolve = new GridModel(sArray, 0);
        this.solver = new DLXGridSolver(this.gridToSolve);
        this.worker = new SwingWorker<Integer, Void>(){

            @Override
            protected Integer doInBackground() {
                return ResolveGridDialog.this.resolveGrid();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    ResolveGridDialog.this.status = (Integer)this.get();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return;
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                    return;
                }
                finally {
                    ResolveGridDialog.this.dispose();
                }
            }
        };
        this.initComponents();
        this.worker.execute();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        GridLayout gridLayout = new GridLayout(3, 1);
        container.setLayout(gridLayout);
        JLabel jLabel = new JLabel("<html><table border=\"0\"><tr>" + I18n._("Grid resolution in progress...") + "</tr>" + "</html>");
        JLabel jLabel2 = new JLabel("");
        JButton jButton = new JButton(I18n._("Cancel"));
        jButton.setHorizontalTextPosition(0);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResolveGridDialog.this.clickedCancel();
            }
        });
        container.add(jLabel);
        container.add(jLabel2);
        FlowLayout flowLayout = new FlowLayout(1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(flowLayout);
        jPanel.add(jButton);
        container.add(jPanel);
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    private void clickedCancel() {
        this.solver.cancel();
    }

    public int getResult() {
        return this.status;
    }

    private Integer resolveGrid() {
        GridSolution gridSolution = this.solver.resolve();
        if (gridSolution == null) {
            return 1;
        }
        if (gridSolution.isSolved()) {
            GridModel gridModel = gridSolution.getSolutionGrid();
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 9; ++j) {
                    byte by = gridModel.getValueAt(i, j);
                    this.view.getController().notifyGridValueChanged(i, j, by, true);
                }
            }
            return 0;
        }
        return 2;
    }
}

