/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.sudokuki.SudokuGrid;
import net.jankenpoi.sudokuki.generator.SudokuGeneratorFactory;
import net.jankenpoi.sudokuki.preferences.UserPreferences;
import net.jankenpoi.sudokuki.ui.swing.SwingMultiGrid;
import net.jankenpoi.sudokuki.view.GridView;

public class PrintMultiDialog
extends JDialog {
    private JFrame parent;
    private final SwingWorker<Integer, Void> worker;
    private Object lock = new Object();
    private boolean cancelledDialog = false;

    public PrintMultiDialog(JFrame jFrame, GridView gridView) {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.setResizable(false);
        short[] sArray = new short[81];
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (!gridView.isCellReadOnly(i, j)) continue;
                sArray[9 * i + j] = gridView.getValueAt(i, j);
            }
        }
        this.worker = new SwingWorker<Integer, Void>(){

            @Override
            protected Integer doInBackground() {
                return PrintMultiDialog.this.generateFourGrids();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return;
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                    return;
                }
                catch (CancellationException cancellationException) {
                    cancellationException.printStackTrace();
                }
                finally {
                    PrintMultiDialog.this.dispose();
                }
            }
        };
        this.initComponents();
        this.worker.execute();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        GridLayout gridLayout = new GridLayout(3, 1);
        container.setLayout(gridLayout);
        JLabel jLabel = new JLabel("<html><table border=\"0\"><tr>" + I18n._("Generating and sending four grids") + "</tr>" + "</html>");
        JLabel jLabel2 = new JLabel("<html><table border=\"0\"><tr>" + I18n._("to the printer...") + "</tr>" + "</html>");
        JButton jButton = new JButton(I18n._("Cancel"));
        jButton.setHorizontalTextPosition(0);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintMultiDialog.this.clickedCancel();
            }
        });
        container.add(jLabel);
        container.add(jLabel2);
        FlowLayout flowLayout = new FlowLayout(1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(flowLayout);
        jPanel.add(jButton);
        container.add(jPanel);
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clickedCancel() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelledDialog = true;
        }
        this.worker.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dialogCancelled() {
        Object object = this.lock;
        synchronized (object) {
            return this.cancelledDialog;
        }
    }

    private int generateFourGrids() {
        if (this.dialogCancelled()) {
            return 1;
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.dialogCancelled()) {
            return 1;
        }
        int n = UserPreferences.getInstance().getInteger("minRating", 0);
        int n2 = UserPreferences.getInstance().getInteger("maxRating", Integer.MAX_VALUE);
        SudokuGrid sudokuGrid = SudokuGeneratorFactory.getGenerator().generateGrid(n, n2);
        if (this.dialogCancelled()) {
            return 1;
        }
        SudokuGrid sudokuGrid2 = SudokuGeneratorFactory.getGenerator().generateGrid(n, n2);
        if (this.dialogCancelled()) {
            return 1;
        }
        SudokuGrid sudokuGrid3 = SudokuGeneratorFactory.getGenerator().generateGrid(n, n2);
        if (this.dialogCancelled()) {
            return 1;
        }
        SudokuGrid sudokuGrid4 = SudokuGeneratorFactory.getGenerator().generateGrid(n, n2);
        printerJob.setPrintable(new SwingMultiGrid(sudokuGrid, sudokuGrid2, sudokuGrid3, sudokuGrid4));
        if (this.dialogCancelled()) {
            return 1;
        }
        boolean bl = printerJob.printDialog();
        if (bl) {
            try {
                if (this.dialogCancelled()) {
                    return 1;
                }
                printerJob.print();
                if (this.dialogCancelled()) {
                    return 1;
                }
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
        }
        return 0;
    }
}

