/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.sudokuki.ui.swing.CheckUpdateDialog;
import net.jankenpoi.sudokuki.ui.swing.NewVersionFoundDialog;

public class CheckUpdateAction
extends AbstractAction {
    private Action openUpdateSiteAction;
    private JFrame frame;

    public CheckUpdateAction(JFrame jFrame, Action action) {
        this.frame = jFrame;
        this.openUpdateSiteAction = action;
        this.performSilentCheck();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        CheckUpdateDialog checkUpdateDialog = new CheckUpdateDialog(this.frame, this);
        checkUpdateDialog.setVisible(true);
        int n = checkUpdateDialog.getResult();
        if (n == 0) {
            JOptionPane.showMessageDialog(this.frame, "<html><table border=\"0\"><tr>" + I18n._("This version of Sudokuki is up-to-date.") + "</tr>" + "</html>", "Sudokuki", -1);
        } else if (n == 1) {
            this.openUpdateSiteAction.setEnabled(true);
            NewVersionFoundDialog newVersionFoundDialog = new NewVersionFoundDialog(this.frame);
            newVersionFoundDialog.setVisible(true);
        } else if (n == -1) {
            JOptionPane.showMessageDialog(this.frame, "<html><table border=\"0\"><tr>" + I18n._("Unable to retrieve update information.<br/><br/>Please check on the following website<br/>if a new version of Sudokuki is available:<br/><br/>") + "http://sourceforge.net/projects/sudokuki/files/sudokuki" + "</tr>" + "</html>", "Sudokuki", 2);
        }
    }

    public void performSilentCheck() {
        CheckUpdateDialog checkUpdateDialog = new CheckUpdateDialog(this.frame, this);
        checkUpdateDialog.setVisible(false);
    }

    void notifyNewVersionFound() {
        this.openUpdateSiteAction.setEnabled(true);
    }
}

