////////////////////////////////////////////////////////////////////////////////
// sudokuki - C++ graphical sudoku game                                       //
// Copyright (C) 2007-2009 Sylvain Vedrenne                                   //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License along    //
// with this program; if not, write to the Free Software Foundation, Inc.,    //
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.              //
////////////////////////////////////////////////////////////////////////////////
#include <string.h>//std::memcpy
#include <iostream>
#include <sstream>
//#include <string>
#include "player.hh"
#include "grid.hh"
#include "tst_grid.hh"
//#include "tst_player.hh"

/*****************************************************************************/
/* use this to configure local traces */
#define TRACES_PLAYER_CC 0

/* use this to deactivate local traces when ALL_TRACES is defined */
#define NO_TRACES_PLAYER_CC 1

#if (ALL_TRACES/*defined in sudokukimm.h*/ ||TRACES_PLAYER_CC)&&!NO_TRACES_PLAYER_CC
#define DBGM_TRACES 1
#else
#define DBGM_TRACES 0
#endif
#include "../dbgm_traces.h"
/*****************************************************************************/
bool
player::go_back_one_grid()
{
	if ( m_cur_grid_idx > 1 ) {
		m_cur_grid_idx--;
	}
	return 1;
}
/*****************************************************************************/
int
player::get_current_grid_index()
{
	return m_cur_grid_idx;
}
/*****************************************************************************/
int
player::set_cell_value( int li, int co, int val )
{
	DBGF("(%d,%d,%d)", li, co, val);

	/* Copy the current grid to the next grid position
	 */
	short* p_cur = m_pmem + (m_cur_grid_idx-1)*grid_len; // location in memory of current grid
	short* p_next = p_cur + grid_len;
	memcpy( p_next, p_cur, grid_len*sizeof(short) ); // copy 1st grid (generated grid) to 2nd position

	grid tmp_grid_1( p_next, false );// temporary object used to WRITE in the player memory

	int cell_filled_result = 0;
	cell_filled_result = tmp_grid_1.is_value_available(li, co, val);
	if ( 1 == cell_filled_result ) {

		tst_grid tst_grid_1( &tmp_grid_1 );
		tst_grid_1.dump();

		cell_filled_result = tmp_grid_1.set_cell_value(li, co, val);
		m_number_of_filled_cells++;
		DBGF("player.cc::set_cell_value m_how_many_numbers++ => %d", m_number_of_filled_cells);

		tst_grid_1.dump();
	}

//	short int dli, dco, dnb;
//	int result = -1;
//	result = tmp_grid_1.pop_min_poss_cell(&dli, &dco, &dnb);
//	if ( 2 == result ) {
//		_DBGM("cell_value_set(%d,%d,%d)=> CONGRATULATIONS - GRID COMPLETE!");
//		return 100;
//	}

	if ( 1==cell_filled_result/* Ok */ || /* dead end */3==cell_filled_result) {
		m_cur_grid_idx++;
		m_pcur_grid = m_pcur_grid + grid_len;
		{
			short int dli, dco, dnb;
			int result = -1;
			result = tmp_grid_1.pop_min_poss_cell(&dli, &dco, &dnb);
			if ( 2 == result ) {
				_DBGM("cell_value_set(%d,%d,%d)=> CONGRATULATIONS - GRID COMPLETE!");
				return 100;
			}
		}
	} else {
		assert( 0 == cell_filled_result );
		// Clean the next grid's position since the cell could not be filled
		std::fill( p_next, p_next + grid_len, short(VAL::UNUSED) );
	}

	_DBGF("cell_value_set(%d,%d,%d)=>%d", li, co, val, cell_filled_result);
	return cell_filled_result;
}
/*****************************************************************************/
bool
player::is_value_possible( int li, int co, int val )
{
	short* p_cur = m_pmem + (m_cur_grid_idx-1)*grid_len; // location in memory of current grid
	grid tmp_grid_1( p_cur, false );// temporary object used to READ in the player memory

	if ( tmp_grid_1.is_cell_filled(li, co) ) {
		return false;
	} else {
		int result = tmp_grid_1.is_value_available(li, co, val);
		DBGF("(%d,%d):%d\n", li, co, value);
		return (1==result);
	}
}
/*****************************************************************************/
int
player::get_cell_value( int li, int co )
{
	short* p_cur = m_pmem + (m_cur_grid_idx-1)*grid_len; // location in memory of current grid
	grid tmp_grid_1( p_cur, false );// temporary object used to READ in the player memory

	int value = tmp_grid_1.get_value_in_cell( li, co );
	_DBGF("player::cell_value_get(%d,%d):%d\n", li, co, value);
	DBGF("player::cell_value_get, value:%d",value);
	return value;
}
/*****************************************************************************/
std::map<int, int>
player::get_current_grid_values()
{
	std::map<int, int> tmp_map;

	grid* p_cur_grid = new grid( m_pmem + (m_cur_grid_idx-1)*grid_len, false );
	for ( int li=0; li<9; li++ ) {
		for ( int co=0; co<9; co++ ) {
			int value = p_cur_grid->get_value_in_cell(li, co);
//			tmp_map.insert( std::pair<int, int>(100+li*10+co, value ));
			tmp_map.insert( std::pair<int, int>(li*9+co, value ));
		}
	}

	return tmp_map;
}
/*****************************************************************************/
std::string
player::get_current_grid_values_string()
{
	std::map<int, int> tmp_map;

	grid* p_cur_grid = new grid( m_pmem + (m_cur_grid_idx-1)*grid_len, false );
	std::ostringstream oss;

	for ( int li=0; li<9; li++ ) {
		for ( int co=0; co<9; co++ ) {
			int value = p_cur_grid->get_value_in_cell(li, co);
			if ( 1 <= value && value <= 9 ) {
				oss << value;
			} else {
				oss << "-";
			}
		}
	}
	DBGF("get_current_grid_values_string() value:%s", oss.str().c_str() );
	return oss.str();
}
/*****************************************************************************/
void
player::init( const string grid_str )
{
	_DBGM("player::init");
	grid_tool::init(grid_str);
	m_cur_grid_idx = 1;
	_DBGM("end of player::init\n");
}
/*****************************************************************************/
short char2short_( const char car )
{
	short tmp_short = car - '0';

	if ( 1<=tmp_short && tmp_short<=9 ) {
		return tmp_short; // cell with a value (1..9)
	} else {
		return short(VAL::EMPTY);
	}
}

int
player::fill_additional_moves( const string grid_str )
{
	// Writes in the player memory additional numbers (saved moves), using the string grid_str

	for ( int li=0; li<nb_lines; li++ ) {
		for ( int co=0; co<nb_cols; co++ ) {
			short tmp_int = char2short_( grid_str[ nb_cols*li + co ] );
			if ( 0 < tmp_int ) { // if value means "empty", do nothing
				if ( is_cell_empty( li, co ) ) {
					assert(	0 != set_cell_value( li, co, tmp_int ) );
					m_number_of_filled_cells++;
					DBGF("player.cc::fill_additional_moves m_number_of_filled_cells++ => %d", m_number_of_filled_cells);
				}
			}
		}
	}

#if GRID_COMPLETE_TRACES
	tst_grid tst_grid( &tmp_grid_1 );
	tst_grid.dump();
#endif

	_DBGM("\n player::fill_additional_moves \n");
	return 1;
}
/*****************************************************************************/
bool
player::is_cell_empty( int li, int co )
{
	int value = get_cell_value( li, co );
	if ( 1<=value && value<=9 ) {
		return false;
	} else {
		return true;
	}
}
/*****************************************************************************/
