/*
University of Illinois/NCSA Open Source License

Copyright (c) 2006 mnagaku All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal with
the Software without restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimers.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimers in the documentation and/or
  other materials provided with the distribution.
* Neither the names of mnagaku, nor the names of its contributors may be used to
  endorse or promote products derived from this Software without specific prior
  written permission. 

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE CONTRIBUTORS
OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS WITH THE SOFTWARE.
*/
/*
{Ql(http://www.opensource.jp/licenses/UoI-NCSA.html)

CmCw/NCSAI[v\[XECZX

Copyright (c) 2006 mnagaku All rights reserved.

ȉɒ߂ɏ]A{\tgEFAъ֘Ãt@C
(ȉu\tgEFAv)̕擾邷ׂĂ̐lɑ΂A\tgEFA𖳐
Ƃ𖳏ŋ܂B
ɂ́A\tgEFA̕gpAʁAύXAAfځAЕzA
TuCZXA/܂͔̔錠Aу\tgEFA񋟂鑊
Ƃ錠Ɋ܂܂܂B

* \[XER[hĔЕzꍇ́AL̒쌠\A{ځAщL
  Ɛӏ\[XER[hɋLڂȂ΂Ȃ܂B
* oCi`ōĔЕzꍇ́AL̒쌠\A{ځAщL
  ƐӏAЕzƋɒ񋟂镶A/܂͑̎ɓ]ڂȂ
  Ȃ܂B
* OɏʂŖmȋ󂯂邱ƂȂA{\tgEFAhi𐥔F
  ܂͑iړIŁAmnagaku̖OA܂̓Rgr[^[̖O
  gpĂ͂Ȃ܂B

\tgEFÁû܂܁vŁAł邩Öقł邩킸A̕ۏ؂
Ȃ񋟂܂Błۏ؂Ƃ́AiA̖ړIւ̓KA
NQɂĂ̕ۏ؂܂݂܂AɌ肳̂ł͂܂B
Rgr[^[܂͒쌠҂́A_sׁAs@sׁA܂͂ȊO
낤ƁA\tgEFAɋN܂͊֘AA邢̓\tgEFA̎gp܂
̑̎舵ɂĐ؂̐AQȂ̋`ɂĉ̐ӔC
Ȃ̂Ƃ܂B
*/
/*
StringSearch
by mnagaku @ 2006/02/02

StringSearch́Ap̕񃊃e܂JavaŋLqꂽ\[XZbgɑ΂A
ċAIɃ\[Xc[A\[Xt@C̃bZ[WƎv镶
oAw肳ꂽ\bhŃbsOꂽԂɒu܂B
̌oꂽ\[Xt@C̃IWíA.old̊gqtŕۑ܂B
݁AoꂽpA\{ƂāAIɖ|
s悤ɂȂĂ܂B
oꂽƂ̓{master.cvsɕۑ܂B
ɁALocalString.java\[Xc[ɒu܂B

̌Amaster.cvs1sڂt@Ccharset(uShift_JISvȂ)A
t@CA̖gP[.txt(uja_JP.txtvȂ)ɕύXA
LocalString.javaƂɃvWFNgɊ܂܂悤ɂAbuild܂B
ƁAbuildꂽs`́ALocalString.javaʂĖ|󃊃\[X擾A
\Ɏgp悤ɂȂ܂B

*.javaΏۂƂĕ񃊃e𒊏o܂B
oALȊO̕3̏ꍇ́AuΏۂɊ܂߂܂B
óA܂܂u\"vu""vɕϊA
MS ExcelŕҏW\ȃJ}؂csvt@Cmaster.csvɏ܂܂B

StringSearch.jar̍
javac -source 1.4 -target 1.4 StringSearch.java
jar cvfm StringSearch.jar StringSearch.mf *.class *.java

usage
java -jar StringSearch.jar [-package pbP[W] [-length o̍ŒZ]
*/

import java.net.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;

import javax.swing.text.*;
import javax.swing.text.html.*;
import javax.swing.text.html.parser.*;



// |
class ExciteTranslate extends HTMLEditorKit.ParserCallback {

	int textareaCount = 0;
	boolean inTextarea = false;
	String result = null;


	public void handleText(char[] data, int pos) {
		if(inTextarea && textareaCount == 2)result = new String(data);
	}


	public void handleStartTag(HTML.Tag tag,MutableAttributeSet attrs,int pos) {
		if(tag.equals(HTML.Tag.TEXTAREA)){inTextarea=true;textareaCount++;}
	}


	public void handleEndTag(HTML.Tag tag, int pos) {
		if(tag.equals(HTML.Tag.TEXTAREA))inTextarea = false;
	}


	void translate(String txt) {
		textareaCount = 0;
		inTextarea = false;
		result = null;
		try {
			URLConnection uc=(new URL("http://www.excite.co.jp/world/english/"))
				.openConnection();
			uc.setDoOutput(true);
			PrintWriter post = new PrintWriter(uc.getOutputStream());
			post.print("wb_lp=ENJA&before="+URLEncoder.encode(txt,"US-ASCII"));
			post.close();
			BufferedReader in = new BufferedReader(new InputStreamReader(
				uc.getInputStream()));

			ParserDelegator parser = new ParserDelegator();
			parser.parse(new InputStreamReader(uc.getInputStream()),this,true);
		} catch(Exception e) {
			e.printStackTrace();
			result = null;
		}
		textareaCount = 0;
		inTextarea = false;
	}


	public String get(String txt) {
		int wait;
		try {
			for(translate(txt), wait = 2000; result == null && wait < 600000;
				Thread.sleep(wait), wait *= 2, translate(txt));
		} catch(Exception e) {e.printStackTrace();}
		return result;
	}
}



public class StringSearch {



// ΏۂƂȂt@C̃tB^OsFileFilterImpNX
	static class FileFilterImp implements FileFilter {

		boolean passDir = false; // fBNgԂ(tB^Ȃ)ǂ
		Pattern p; // t@C̐K\


// RXgN^
		public FileFilterImp(String match, boolean passDir) {
			p = Pattern.compile(match);
			this.passDir = passDir;
		}


// tB^O
		public boolean accept(File pathname) {
			if(pathname.isDirectory()) // fBNgpassDirɏ
				return passDir;
// t@C}b`Ȃtrue
			if(p.matcher(pathname.getName()).matches())
				return true;
// }b`ȂȂfalseBƁAt@CƂďo
			else {
				System.out.println("Info : other file : "
					+ pathname.getPath().substring(2));
				return false;
			}
		}
	}



	static int length = 3; // oΏۂƂ镶(LA󔒕)̉
	static FileFilter ff;
	static LinkedHashMap stringList; // ȍW
	static Pattern p, lp, fp, csvp, sp;
	static String method; // bv郁\bh
// bv郁\bh̃NX̃pbP[W
	static String packageName = null;


	public static void main(String[] args) {
// Javã\[Xt@C𓾂邽߂̃tB^
		ff = new FileFilterImp("^\\w*\\.java$", true);
// 񃊃e̐K\(e܂)
		p = Pattern.compile("(\"(\\\\\"|[^\"])*\")|('.*')");
		lp = Pattern.compile("\\s|\\W"); // L(Pꕶ)A󔒕̐K\
		csvp = Pattern.compile("\\\\\""); // u\"v̐K\
		sp = Pattern.compile("\\s"); // 󔒕̐K\
		fp = Pattern.compile(":|/|(\\.\\w)"); // \[X̐K\
		stringList = new LinkedHashMap();

// sɈŁAbv郁\bh̃NX̃pbP[Wݒ肵
// oΏۂƂ镶(LA󔒕)̉AύXł
		for(int i = 0; i < args.length; i++)
			if(args[i].compareTo("-package") == 0 && i + 1 < args.length
				&& args[i + 1].indexOf("-") != 0)
				packageName = args[i + 1];
			else if(args[i].compareTo("-length") == 0 && i + 1 < args.length
				&& args[i + 1].indexOf("-") != 0)
				length = Integer.parseInt(args[i + 1]);

		if(packageName == null)
			method = "LocalString.get";
		else
			method = packageName + ".LocalString.get";

		if(!searchDir(new File("."))) // JgfBNgȉċAIɌ
			return;

// oJ}؂csvAmaster.csvƂăt@Cɏo
// "ho\"ge" -> """ho""ge""" ɕϊďo
// |{
		System.out.println("Translation start : total line = "
			+ stringList.size() + " : " + (new Date()).toString());
		Set ite = stringList.entrySet();
		try {
			ExciteTranslate et = new ExciteTranslate();
			PrintWriter out = new PrintWriter(new BufferedWriter(
				new FileWriter("master.csv")));
			int strCount = 1;
			for(Iterator i = ite.iterator(); i.hasNext(); strCount++) {
				Map.Entry me = (Map.Entry)(i.next());
				String str = (String)(me.getKey());
				str = str.substring(1, str.length() - 1);
				Matcher csvm = csvp.matcher(str);
				str = csvm.replaceAll("\"\"");
				String translateStr = et.get(str);
				if(translateStr == null) {
					System.out.println("retry over : line = " + strCount
						+ " : " + (new Date()).toString());
					translateStr = "";
				} else if(translateStr.compareToIgnoreCase(str) == 0) {
					System.out.println("can't tlanslate : line = " + strCount
						+ " : " + str + " : " + (new Date()).toString());
					translateStr = "";
				}
				out.println("\"\"\"" + me.getValue() + "\"\"\",\"\"\""
					+ str + "\"\"\",\"\"\"" + translateStr +"\"\"\",");
			}
			out.close();
		} catch(Exception e) {
			System.out.println("Error : write master.csv");
			e.printStackTrace();
			return;
		}
		System.out.println("Translation end : " + (new Date()).toString());

// LocalString.javafo
		try {
			BufferedReader in = new BufferedReader(new InputStreamReader(
				Class.forName("StringSearch").getResource("LocalString.java")
				.openStream()));
			PrintWriter out = new PrintWriter(new BufferedWriter(
				new FileWriter("LocalString.java")));

			String line;
			while((line = in.readLine()) != null) {
				if(packageName == null) {
					if(line.indexOf("package LocalStringPackage;") >= 0)
						continue;
					out.println(line.replaceAll("LocalStringPackage\\.", ""));
				} else
					out.println(line.replaceAll("LocalStringPackage",
						packageName));
			}

			in.close();
			out.close();
		} catch(Exception e) {
			System.out.println("Error : write LocalString.java");
			e.printStackTrace();
			return;
		}
	}


// fBNgċAIɌAJavã\[Xt@C
	static boolean searchDir(File currentDir) {
		File[] currentFiles = currentDir.listFiles(ff);
		for(int i = 0; i < currentFiles.length; i++) {
			if(currentFiles[i].isDirectory())
				searchDir(currentFiles[i]);
			else if(!execute(currentFiles[i]))
				return false;
		}
		return true;
	}


// Javã\[Xt@C̕񃊃eo
	static boolean execute(File file) {
		try {
			boolean hasString = false;
			String line = null, paths, str;
			BufferedReader in = new BufferedReader(new FileReader(file));
			Matcher m, lm, fm, sm;

			System.out.println("execute : " + file.getPath());
// \bhŃbv\[Xt@C̏o
			PrintWriter out = new PrintWriter(new BufferedWriter(
				new FileWriter(file.getPath() + ".new")));
// 1s
			for(int i = 1; (line = in.readLine()) != null; i++) {
// ꂩ珑ނ͂̃\bhG[
				if(line.indexOf(method) >= 0) {
					System.out.println("Error : find method string at "
						+ i +" : " + line);
					return false;
				}
// 񃊃e̎擾
				m = p.matcher(line);
				StringBuffer sb = new StringBuffer();
				while(m.find()) {
// e͌oȂ
					if(line.charAt(m.start()) == '\'') {
						System.out.println("Info : single quart at "
							+ i +" : " + m.group());
						continue;
					}
// (LA󔒕)𒴂Ă邩
					lm = lp.matcher(m.group());
					str = lm.replaceAll("");
					if(str.length() < length) {
						System.out.println("Info : too short string at "
							+ i +" : " + m.group());
						continue;
					}
// 󔒂ȂA(/.)ȂŃJgɓt@C݂邩A
// 󔒂ȂA(/.)肾A\[XwƔfAoȂ
					sm = sp.matcher(m.group());
					str = sm.replaceAll("");
					if(str.length() == m.group().length()) {
						fm = fp.matcher(str);
						if(fm.find() || (new File(file.getParent()
							+ File.separator + str.replaceAll("\\\"", "")))
							.exists()) {
							System.out.println("Info : path to resource at "
								+ i + " : " + str);
							continue;
						}
					}
// oWɒǉ
					if((paths = (String)stringList.get(m.group())) == null)
						stringList.put(m.group(),
							file.getPath().substring(2) + ":" + i + ";");
// Ɍoς݂̕Čoꍇ́AoꏊɒǋLďWɖ߂
					else {
						paths += file.getPath().substring(2) + ":" + i + ";";
						stringList.remove(m.group());
						stringList.put(m.group(), paths);
					}
// \bhŃbv
					m.appendReplacement(sb, method + "\\($1\\)");
					hasString = true;
				}
				m.appendTail(sb);
// so
				out.println(sb.toString());
			}
			in.close();
			out.close();
// oďsĂA\[XuāA
// IWi.old
			if(hasString) {
				if(!file.renameTo(new File(file.getPath() + ".old"))) {
					System.out.println("Error : " + file.getName()
						+ " : rename current2old");
					return false;
				}
				if(!(new File(file.getPath() + ".new")).renameTo(file)) {
					System.out.println("Error : " + file.getName()
						+ " : rename new2current");
					return false;
				}
				return true;
			} else if(!(new File(file.getPath() + ".new")).delete()) {
				System.out.println("Error : "+file.getName()+" : delete new");
				return false;
			}
		} catch(Exception e) {
			System.out.println("Error : " + file.getName());
			e.printStackTrace();
		}
		return true;
	}
}
