/*
 * Copyright 2003-2006 Stream Converter Project Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.stconv.storage;

import java.io.InputStream;
import java.io.OutputStream;

public interface StreamStorage {
    /**
     * Initialize this StreamStorage object.
     * 
     * @param in
     *            an input stream that you want to convert
     * @param encoding
     *            an encoding for the given input stream
     * @throws StreamStorageException
     */
    public abstract void init(InputStream in, String encoding)
            throws StreamStorageException;

    /**
     * Destroys instances, such as caches, in this class
     */
    public abstract void destroy();

    /**
     * Commits a written output stream, and then you can get the commited stream
     * from getInputStream().
     * 
     * @throws StreamStorageException
     */
    public abstract void commit() throws StreamStorageException;

    /**
     * @return Returns the converted byte stream.
     * @throws StreamStorageException
     */
    public abstract InputStream getResultInputStream()
            throws StreamStorageException;

    /**
     * @return Returns the encoding.
     */
    public abstract String getEncoding();

    /**
     * @return Returns the inputStream.
     */
    public abstract InputStream getInputStream();

    /**
     * @return Returns the outputStream.
     */
    public abstract OutputStream getOutputStream();

    public abstract void addCallback(String key, Callback callback);

    public abstract Callback getCallback(String key);

    public abstract Callback removeCallback(String key);
}
