/*
 * Copyright 2003-2006 Stream Converter Project Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.stconv.wiki.pukiwiki.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;

/**
 * 
 * Enclosing Inline Element with ''' puts emphasis on the element (Italics).
 * @author takeharu
 *
 */
public class ConvertItaricFontValve extends AbstractWikiValve {
    private String pattern = "'{3}";
    
    boolean isTagStarted;
    
    protected String getPattern()
    {
        return this.pattern;
    }

    protected void writeMatchLine(BufferedWriter writer, String line)
            throws IOException
    {   
        String s = line;
        int idx = 0;
        while(s.indexOf("'''") != -1) {
            if(this.isTagStarted) {
                s = s.replaceFirst("'{3}", "</em>");
                this.isTagStarted = false;
            }else {
                s = s.replaceFirst("'{3}", "<em>");
                this.isTagStarted = true;
            }
        }
        writer.write(s);
        writer.newLine();
    }
}
