package jp.sf.stconv.wiki.pukiwiki.pipeline.valve;

import jp.sf.stconv.storage.StreamStorage;
import jp.sf.stconv.wiki.pipeline.callback.LinkGeneratorCallback;
import jp.sf.stconv.wiki.pipeline.callback.impl.SimpleLinkGeneratorCallbackImpl;

public class ConvertPageLinkValveTest extends AbstractValveTest {
    /** Convert String */
    private static final String CONVERT_STRING = "[[Page1]]";

    /** Result String */
    private static final String CONVERT_RESULT = "<a href=\"http://localhost:8080/index.jsp?pageName=Page1\">Page1</a>";

    /** Convert String */
    private static final String CONVERT_STRING2 = "This is a [[Page2]].";

    /** Result String */
    private static final String CONVERT_RESULT2 = "This is a <a href=\"http://localhost:8080/index.jsp?pageName=Page2\">Page2</a>.";

    /** Convert String */
    private static final String CONVERT_STRING3 = "[[Page3]] is [[Page4]].";

    /** Result String */
    private static final String CONVERT_RESULT3 = "<a href=\"http://localhost:8080/index.jsp?pageName=Page3\">Page3</a> is <a href=\"http://localhost:8080/index.jsp?pageName=Page4\">Page4</a>.";

    /**
     * Default constructor
     */
    public ConvertPageLinkValveTest() {
        super();
    }

    /**
     * Default constructor
     * 
     * @param arg0
     */
    public ConvertPageLinkValveTest(String arg0) {
        super(arg0);
    }

    /**
     * Setup
     */
    protected void setUp() throws Exception {
        valveList.add(new ConvertPageLinkValve());
    }

    protected void addCallbacks(StreamStorage storage) {
        storage.addCallback(LinkGeneratorCallback.LINK_GENERATOR_CALLBACK,
                new SimpleLinkGeneratorCallbackImpl(
                        "http://localhost:8080/index.jsp", "UTF-8"));
    }

    /**
     * Rigourous Test :-)
     */
    public void testInvoke() {
        assertEquals(CONVERT_RESULT, doLineInvoke(CONVERT_STRING));
        assertEquals(CONVERT_RESULT2, doLineInvoke(CONVERT_STRING2));
        assertEquals(CONVERT_RESULT3, doLineInvoke(CONVERT_STRING3));
    }

}
