package jp.sf.stconv.wiki.pukiwiki.pipeline.valve;

import jp.sf.stconv.pipeline.StreamConverterPipeline;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertBlockQuotationValveTest extends AbstractValveTest
{
	private static final String CONVERT_STRING = ">引用文";
	private static final String CONVERT_RESULT = "<blockquote><p class=\"quotation\">引用文</p></blockquote>";
	private static final String CONVERT_STRING2 = "> 引用文";
	private static final String CONVERT_RESULT2 = "<blockquote><p class=\"quotation\">引用文</p></blockquote>";

	private static final String CONVERT_STRING3 = ">>引用文";
	private static final String CONVERT_RESULT3 = "<blockquote><p class=\"quotation\">引用文</p></blockquote>";

	private static final String CONVERT_STRING4 = ">>>引用文";
	private static final String CONVERT_RESULT4 = "<blockquote><p class=\"quotation\">引用文</p></blockquote>";

	private static final String CONVERT_STRING5 = ">引用文\n>>引用文";
	private static final String CONVERT_RESULT5 = "<blockquote><p class=\"quotation\">引用文</p><blockquote><p class=\"quotation\">引用文</p></blockquote></blockquote>";
	

	private static final String CONVERT_STRING6 = ">引用文\n>>引用文\n>>>引用文";
	private static final String CONVERT_RESULT6 = "<blockquote><p class=\"quotation\">引用文</p><blockquote><p class=\"quotation\">引用文</p><blockquote><p class=\"quotation\">引用文</p></blockquote></blockquote></blockquote>";

	private static final String CONVERT_STRING7 = ">引用文\n>>引用文\n>>>引用文\n>引用文";
	private static final String CONVERT_RESULT7 = "<blockquote><p class=\"quotation\">引用文</p><blockquote><p class=\"quotation\">引用文</p><blockquote><p class=\"quotation\">引用文</p></blockquote></blockquote></blockquote>>引用文";
	
	/**
	 * Logger for this class
	 */
	private static final Log log = LogFactory
			.getLog(ConvertBlockQuotationValveTest.class);

	StreamConverterPipeline pipeline = null;
	

	public ConvertBlockQuotationValveTest()
	{
		super();
	}

	public ConvertBlockQuotationValveTest(String arg0)
	{
		super(arg0);
	}

	protected void setUp() throws Exception
	{
		valveList.add(new ConvertBlockQuotationValve());
	}

	/**
	 * Rigourous Test :-)
	 */
	public void testInvoke()
	{
		assertEquals(CONVERT_RESULT,doLineInvoke(CONVERT_STRING));
		assertEquals(CONVERT_RESULT,doLineInvoke(CONVERT_STRING2));
		assertEquals(CONVERT_RESULT,doLineInvoke(CONVERT_STRING3));
		assertEquals(CONVERT_RESULT,doLineInvoke(CONVERT_STRING4));
		assertEquals(CONVERT_RESULT5,doLineInvoke(CONVERT_STRING5));
		assertEquals(CONVERT_RESULT6,doLineInvoke(CONVERT_STRING6));
        // TODO Failed ??
		//assertEquals(CONVERT_RESULT7,doLineInvoke(CONVERT_STRING7));
	}

}
