/*
 * Copyright 2003-2006 Stream Converter Project Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.stconv.wiki.pukiwiki.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;

/**
 * @author takeharu
 *
 */
public class ConvertTableValve extends AbstractWikiValve {
    private String pattern = "\\|.*\\|$";

    private boolean isTagStarted;

    protected String getPattern()
    {
        
        return this.pattern;
    }

    protected void writeMatchLine(BufferedWriter writer, String line)
            throws IOException
    {
        if(!this.isTagStarted)
        {
            writer.write("<table>");
            writer.newLine();
            this.isTagStarted = true;
        }
        String[] values = line.split("\\|");        
        writer.write("<tr>");
        for(int i=1;i<values.length;i++)
        {
            String s = values[i];
            if(s.startsWith("*")) 
            {
                s = s.substring(1);
                writer.write("<th>" + s + "</th>");
            }else
            {
                writer.write("<td>" + s + "</td>");
            }
        }
        writer.write("</tr>");
        writer.newLine();
    }

    protected void writeUnmatchLine(BufferedWriter writer, String line)
            throws IOException
    {
        if(this.isTagStarted)
        {
            writer.write("</table>");
            writer.newLine();
            writer.write(line);
            writer.newLine();
            this.isTagStarted = false;
        }
        else
        {
            super.writeUnmatchLine(writer, line);
        }
    }

    protected void finish(BufferedWriter writer) throws IOException
    {
        if(this.isTagStarted)
        {
            writer.write("</table>");
            writer.newLine();
            this.isTagStarted = false;
        }
        else
        {
            super.finish(writer);
        }
    }
}
