/*
 * Copyright 2003-2006 Stream Converter Project Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.stconv.wiki.pukiwiki.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;

import org.apache.commons.lang.StringEscapeUtils;

/**
 * @author takeharu
 *
 */
public class ConvertPreValve extends AbstractWikiValve {
    private String pattern = "^\\s.*";

    private boolean isTagStarted;

    protected String getPattern()
    {
        return this.pattern;
    }

    protected void writeMatchLine(BufferedWriter writer, String line)
            throws IOException
    {
        if(!this.isTagStarted)
        {
            writer.write("<pre>");
            this.isTagStarted = true;
        }
        writer.write(StringEscapeUtils.escapeHtml(line.substring(1)));
        writer.newLine();
    }

    /**
     * 不一致の行に対しては何も行いません。
     * TODO 内部テキストのタグはエスケープする必要があるかも。
     */
    protected void writeUnmatchLine(BufferedWriter writer, String line)
            throws IOException
    {
        if(this.isTagStarted)
        {
            writer.write("</pre>");
            this.isTagStarted = false;
        }else {
            super.writeUnmatchLine(writer,line);
        }
    }

    protected void finish(BufferedWriter writer) throws IOException
    {
        if(this.isTagStarted)
        {
            writer.write("</pre>");
            this.isTagStarted = false;
        }
        else
        {
            super.finish(writer);
        }
    }
}
