package jp.sf.stconv.wiki.pukiwiki.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.sf.stconv.storage.StreamStorage;
import jp.sf.stconv.wiki.pipeline.callback.LinkGeneratorCallback;

public class ConvertPageLinkValve extends AbstractWikiValve {

    private String pattern = ".*\\[\\[([^\\]]+)\\]\\].*";

    protected String getPattern() {
        return this.pattern;
    }

    protected void writeMatchLine(StreamStorage storage, BufferedWriter writer,
            String line) throws IOException {
        LinkGeneratorCallback callback = (LinkGeneratorCallback) storage
                .getCallback(LinkGeneratorCallback.LINK_GENERATOR_CALLBACK);
        if (callback == null) {
            writeUnmatchLine(writer, line);
            return;
        }

        Pattern pattern = Pattern.compile("\\[\\[([^\\]]+)\\]\\]");
        Matcher matcher = pattern.matcher(line);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String pageName = matcher.group(1);
            callback.init();
            callback.addAttribute(LinkGeneratorCallback.PAGE_NAME, pageName);
            matcher.appendReplacement(buf, "<a href=\""
                    + callback.getUrl() + "\">" + pageName + "</a>");
        }
        matcher.appendTail(buf);

        writer.write(buf.toString());
        writer.newLine();
    }

}
