package jp.sf.stconv.hatena.pipeline.valve;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

import jp.sf.stconv.pipeline.StreamConverterPipeline;
import jp.sf.stconv.pipeline.PipelineException;
import jp.sf.stconv.storage.StreamStorage;
import jp.sf.stconv.storage.StreamStorageException;
import jp.sf.stconv.storage.impl.FileStreamStorageImpl;
import junit.framework.TestCase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertMailtoLinkValveTest extends TestCase
{
	private static final String CONVERT_STRING = "[mailto:info@hatena.ne.jp]にメールしてね。";
	private static final String CONVERT_RESULT = "<p><a href=\"mailto:info@hatena.ne.jp\">info@hatena.ne.jp</a>にメールしてね。</p>";

	/**
	 * Logger for this class
	 */
	private static final Log log = LogFactory
			.getLog(ConvertMailtoLinkValveTest.class);

	StreamConverterPipeline pipeline = null;
	List valveList = new ArrayList();

	public ConvertMailtoLinkValveTest()
	{
		super();
	}

	public ConvertMailtoLinkValveTest(String arg0)
	{
		super(arg0);
	}

	protected void setUp() throws Exception
	{
		valveList.add(new ConvertMailtoLinkValve());
	}

	/**
	 * Rigourous Test :-)
	 */
	public void testInvoke()
	{
		StringBuffer buffer = new StringBuffer();
		try
		{
			pipeline = new StreamConverterPipeline("",valveList);
			StreamStorage storage = new FileStreamStorageImpl(
					new ByteArrayInputStream(CONVERT_STRING.getBytes("UTF-8")),
					"UTF-8");
			pipeline.invoke(storage);

			BufferedReader r = null;
			try
			{
				r = new BufferedReader(new InputStreamReader(storage
						.getResultInputStream(), storage.getEncoding()));
				String l = null;
				while ((l = r.readLine()) != null)
				{
					buffer.append(l);
				}
			}
			catch (UnsupportedEncodingException e)
			{
				log.warn("Unsupported Encoding. ", e);
			}
			catch (StreamStorageException e)
			{
				log.warn("Stream Storage Exception. ", e);
			}
			catch (IOException e)
			{
				log.error("I/O Exception. ", e);
			}
			finally
			{
				if(r != null)
				{
					try
					{
						r.close();
					}
					catch (IOException e)
					{
					}
				}
			}
			storage.destroy();
		}
		catch (StreamStorageException e)
		{
			log.error("StreamStorage Exception.", e);
		}
		catch (PipelineException e)
		{
			log.error("Pipeline Exception.", e);
		}
		catch (Exception e)
		{
			log.error("Exception.", e);
		}

		assertEquals(CONVERT_RESULT,buffer.toString());
	}

}
