package jp.sf.stconv.hatena.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;

public class ConvertPreValve extends AbstractHatenaValve
{


	
	private String pattern = "^\\>\\|";

	private boolean tagStartFlg;

	protected String getPattern()
	{
		return pattern;
	}

	/**
	 * 整形済みテキストブロックの開始行、終了行に対して<pre>タグを挿入します。
	 * 
	 */
	protected void writeMatchLine(BufferedWriter writer, String line)
			throws IOException
	{
		if(!tagStartFlg && !line.startsWith(">||"))
		{
			writer.write("<pre>");
			tagStartFlg = true;
		}
			writer.newLine();
	}
	
	protected void writeUnmatchLine(BufferedWriter writer, String line)
			throws IOException
	{
		if(tagStartFlg && line.endsWith("|<") && !line.endsWith("||<"))
		{
			writer.write(line.substring(0, line.length() - 2) + "</pre>");
			writer.newLine();
			tagStartFlg = false;
		}
		else
		{
			writer.write(line);
			writer.newLine();

		}
	}	

}
